# RCBP: Relation Classification via Bidirectional Prompt Learning with Data Augmentation by Large Language Model 

## Overview

![](D:\research\PromptCode\upload_code_and_pdf\figs\model.jpg)

## Environment

The model is implemented using PyTorch. The versions of packages used are shown below.

- numpy==1.18.0
- scikit-learn==0.22.1
- scipy==1.4.1
- torch==1.4.0
- tqdm==4.41.1
- transformers==4.0.0

Our model is tested on one RTX 4090 Graphics Card.

## Data Preparation

You can download the original datasets in the link below.

https://drive.google.com/file/d/1LNqRZEXeN8m3TGtEVr-MYJfqdD2Tx4UA/view?usp=sharing

## Training and predicting

### TACRED

Do the following commands in sequence.

```bash
python .\src\tacred\main+cls.py --template_dir Bidirectionaltemp2.txt --data_dir ./data/tacred --cls_ratio 0 --label_num 42 --print_distribution 1
```

```bash
python .\src\tacred\main+cls.py --template_dir Bidirectionaltemp2.txt --data_dir ./data/tacred --cls_ratio 1.0 --label_num 42 --print_distribution 2
```

```bash
python .\src\tacred\stacking.py
```

On the RTX 4090 Graphics Card, the result is 76.23.

### RETACRED

Do the following commands in sequence.

```bash
python .\src\retacred\main+cls.py --template_dir Bidirectionaltemp2.txt --data_dir ./data/retacred --cls_ratio 0 --label_num 40 --print_distribution 1
```

```bash
python .\src\retacred\main+cls.py --template_dir Bidirectionaltemp2.txt --data_dir ./data/retacred --cls_ratio 1.0 --label_num 40 --print_distribution 2
```

```bash
python .\src\retacred\stacking.py
```

On the RTX 4090 Graphics Card, the result is 91.89.

### TACREV

Do the following commands in sequence.

```bash
python .\src\tacrev\main+cls.py --template_dir Bidirectionaltemp2.txt --data_dir ./data/tacrev --cls_ratio 0 --label_num 42 --print_distribution 1
```

```bash
python .\src\tacrev\main+cls.py --template_dir Bidirectionaltemp2.txt --data_dir ./data/tacrev --cls_ratio 1.0 --label_num 42 --print_distribution 2
```

```bash
python .\src\tacrev\stacking.py
```

On the RTX 4090 Graphics Card, the result is 85.44.

### Semeval

Do the following commands in sequence.

```bash
python .\src\semeval_src\main+cls.py --template_dir Bidirectionaltemp2.txt --data_dir ./data/semeval --cls_ratio 0 --label_num 19 --print_distribution 1 
```

```bash
python .\src\semeval_src\main+cls.py --template_dir Bidirectionaltemp2.txt --data_dir ./data/semeval --cls_ratio 1.0 --label_num 19 --print_distribution 2
```

```bash
python .\src\semeval_src\stacking.py 
```

On the RTX 4090 Graphics Card, the result is 91.24.