/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.shiftreduce;

import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.parser.common.ParserConstraint;
import edu.stanford.nlp.parser.shiftreduce.BinaryTransition;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeCoreAnnotations;
import edu.stanford.nlp.util.ErasureUtils;

class ShiftReduceUtils {
    ShiftReduceUtils() {
    }

    static BinaryTransition.Side getBinarySide(Tree tree) {
        if (tree.children().length != 2) {
            throw new AssertionError();
        }
        CoreLabel label = (CoreLabel)ErasureUtils.uncheckedCast(tree.label());
        CoreLabel childLabel = (CoreLabel)ErasureUtils.uncheckedCast(tree.children()[0].label());
        if (label.get(TreeCoreAnnotations.HeadWordAnnotation.class) == childLabel.get(TreeCoreAnnotations.HeadWordAnnotation.class)) {
            return BinaryTransition.Side.LEFT;
        }
        return BinaryTransition.Side.RIGHT;
    }

    static boolean isTemporary(Tree tree) {
        String label = tree.value();
        return label.startsWith("@");
    }

    static boolean isEquivalentCategory(String l1, String l2) {
        if (l1.startsWith("@")) {
            l1 = l1.substring(1);
        }
        if (l2.startsWith("@")) {
            l2 = l2.substring(1);
        }
        return l1.equals(l2);
    }

    static int headIndex(Tree tree) {
        CoreLabel label = (CoreLabel)ErasureUtils.uncheckedCast(tree.label());
        Tree head = (Tree)label.get(TreeCoreAnnotations.HeadWordAnnotation.class);
        CoreLabel headLabel = (CoreLabel)ErasureUtils.uncheckedCast(head.label());
        return headLabel.index() - 1;
    }

    static int leftIndex(Tree tree) {
        if (tree.isLeaf()) {
            CoreLabel label = (CoreLabel)ErasureUtils.uncheckedCast(tree.label());
            return label.index() - 1;
        }
        return ShiftReduceUtils.leftIndex(tree.children()[0]);
    }

    static int rightIndex(Tree tree) {
        if (tree.isLeaf()) {
            CoreLabel label = (CoreLabel)ErasureUtils.uncheckedCast(tree.label());
            return label.index() - 1;
        }
        return ShiftReduceUtils.rightIndex(tree.children()[tree.children().length - 1]);
    }

    static boolean constraintMatchesTreeTop(Tree top, ParserConstraint constraint) {
        while (true) {
            if (constraint.state.matcher(top.value()).matches()) {
                return true;
            }
            if (top.children().length != 1) break;
            top = top.children()[0];
        }
        return false;
    }
}

