import numpy as np
import argparse
import json
from Single_Document import exact_presence
import os

def compute_str_em_nq(qa_pairs):
    loc_acc = []
    for qa_pair in qa_pairs:
        loc_acc.append(exact_presence(qa_pair['answers'], qa_pair['prediction']))
    str_em = np.mean(loc_acc)

    return str_em

def main():
    parser = argparse.ArgumentParser()
    parser.add_argument("--f", type=str, default = None, help="the file to be evaluated")
    parser.add_argument("--d", type=str, default = None)

    args = parser.parse_args()

    if args.f is not None:
        with open(args.f) as f:
            datas = json.load(f)

        samples = datas.values()

        result = {}
        result['str_em'] = compute_str_em_nq(samples)

        print(result)
        json.dump(result, open(args.f + ".score.json", "w"), indent=4)

    if args.d is not None:
        for filename in os.listdir(args.d):
            if "json" in filename and "nq" in filename and "score" not in filename:
                with open(os.path.join(args.d, filename)) as f:
                    datas = json.load(f)

                samples = datas.values()

                result = {}
                result['str_em'] = compute_str_em_nq(samples)

                print(filename, result)
                json.dump(result, open(os.path.join(args.d, filename + '.score.json'), "w"), indent=4)


if __name__ == "__main__":
    main()