from modelscope.pipelines import pipeline
from modelscope.utils.constant import Tasks
from modelscope.outputs import OutputKeys
from modelscope.preprocessors.multi_modal import OfaPreprocessor

def load_ofa():
  model = 'damo/ofa_visual-question-answering_pretrain_large_en'
  preprocessor = OfaPreprocessor(model_dir=model)
  ofa_pipe = pipeline(
      Tasks.visual_question_answering,
      model=model,
      model_revision='v1.0.1',
      preprocessor=preprocessor)
  return ofa_pipe

def ofa(ofa_pipe, img, prompt):
  input = {'image': img, 'text': prompt}

  answer = ofa_pipe(input)
  answer = answer['text'][0]

  return answer