#!/usr/bin/env bash

# bash xgiga_generate_zero_w_text.sh mspm4_xgiga en zh zh_CN finetune_pretrainedMspm4_freezeDecoder None /opt/tiger/sumtest/tmpdata/test.y.zh.first5

# bash xgiga_generate_zero_w_text.sh mspm4_xgiga en zh zh_CN finetune_pretrainedMspm4_freezeEncDec_freezeEncLayerNorm_adapterV3_2layer_fusedDocGated_rougeEval_eval_zh_retrain None /opt/tiger/sumtest/input.txt;

DATAVER="$1"
TRAIN_LG="$2"
TEST_LG="$3"
TEST_LG_TAG="$4"
NAME="$5"
EXTEND_DICT="$6"
INPATH="$7"

argslist=""
for (( i = 8; i <= $# ; i++ ))
  do
    j=${!i}
    argslist="${argslist} $j "
  done
echo $argslist >&2

tokenize(){   
    base_dir=$(pwd)

    INPUT=$1
    OUTPUT=$2
    DICT=$3

    echo "tokenize ${INPUT} to ${OUTPUT} using mbart's spm..."
    # setup MBART
    MBART=/home/tiger/mbart.cc25
    if [ ! -d $MBART ]; then
        hadoop fs -copyToLocal hdfs://haruna/home/byte_arnold_hl_mlnlc/user/wuxianze.0/Workspace/Multilingual/pretrained/mbart.CC25.tar.gz /home/tiger
        tar -xvzf /home/tiger/mbart.CC25.tar.gz -C /home/tiger
    fi
    MODEL=$MBART/sentence.bpe.model
    python3 ${base_dir}/fairseq/scripts/spm_encode.py --model=$MODEL < $INPUT > $OUTPUT

    echo "first line of ${OUTPUT}"
    head -n 1 $OUTPUT
}

cd "$(dirname $0)" || return
echo "Install fairseq" >&2

sudo mkdir -p /usr/lib/python3.7/site-packages/
sudo pip3 install -e fairseq
pip3 install -r requirements.txt -i http://pypi.byted.org/simple/ --trusted-host=pypi.byted.org

export PYROUGE_HOME_DIR=$(pwd)/RELEASE-1.5.5
export PYROUGE_TEMP_PATH=/opt/tiger

pyrouge_set_rouge_path $PYROUGE_HOME_DIR
chmod +x $PYROUGE_HOME_DIR/ROUGE-1.5.5.pl

wxz_prefix=hdfs://haruna/home/byte_arnold_hl_mlnlc/user/wuxianze.0

dataset_path=${wxz_prefix}/Datasets/multilingual/data-bin/${DATAVER}/${TEST_LG}
tensorboard_logdir=${wxz_prefix}/Workspace/Multilingual/${TEST_LG}/logs/${NAME}_${TRAIN_LG}
old_checkpoint_path=${wxz_prefix}/Workspace/Multilingual/${TRAIN_LG}/checkpoints/${NAME}
new_checkpoint_path=${wxz_prefix}/Workspace/Multilingual/xgiga/${TRAIN_LG}/checkpoints/${NAME}
pretrained_path=${wxz_prefix}/Workspace/Multilingual/pretrained

# change checkpoint path
hdfs dfs -mkdir -p $tensorboard_logdir

local_root=~/zeroshot_xgiga_${NAME}_${TEST_LG}
resource_root=${local_root}/resource
output_path=${local_root}/output
model_path=${local_root}/model
mkdir -p ${resource_root}
mkdir -p ${output_path}
mkdir -p ${model_path}

# # data setup
local_dataset_path=${resource_root}/dataset
mkdir -p ${local_dataset_path}
hadoop fs -copyToLocal ${dataset_path}/test.* ${local_dataset_path}
hadoop fs -copyToLocal ${dataset_path}/dict.* ${local_dataset_path}
echo "Download resource from ${dataset_path} to ${local_dataset_path}" >&2

# tensorboard setup
local_tensorboard_path=${output_path}/tensorboard_logdir
mkdir -p ${local_tensorboard_path}

# # model setup
local_checkpoint_path=${output_path}/checkpoint_path
mkdir -p ${local_checkpoint_path}
hadoop fs -copyToLocal ${old_checkpoint_path}/checkpoint_best.pt ${local_checkpoint_path}
if [ -e ${local_checkpoint_path}/checkpoint_best.pt ]; then
  echo "Load checkpoints from ${old_checkpoint_path}/checkpoint_best.pt to ${local_checkpoint_path}" >&2
else
  hadoop fs -copyToLocal ${new_checkpoint_path}/checkpoint_best.pt ${local_checkpoint_path}
  echo "Load checkpoints from ${new_checkpoint_path}/checkpoint_best.pt to ${local_checkpoint_path}" >&2
fi

echo "remove ${local_dataset_path}/dict.*.txt"
rm ${local_dataset_path}/dict.*.txt
hdfs dfs -get ${pretrained_path}/dict_extend.txt ${local_dataset_path}
echo "treat ${local_dataset_path}/dict_extend.txt as ${local_dataset_path}/dict.*.txt"
cp ${local_dataset_path}/dict_extend.txt ${local_dataset_path}/dict.doc.txt
cp ${local_dataset_path}/dict_extend.txt ${local_dataset_path}/dict.sum.txt

if [ ! "${EXTEND_DICT}" == "None" ]; then
    echo "Load extend dictionary from ${pretrained_path}/${EXTEND_DICT}.txt to ${local_dataset_path}" >&2
    hdfs dfs -get ${pretrained_path}/${EXTEND_DICT}.txt ${local_dataset_path}
    echo "write the extended dictionary into ${local_dataset_path}/dict.*.txt"
    cat ${local_dataset_path}/${EXTEND_DICT}.txt >> ${local_dataset_path}/dict.doc.txt
    cat ${local_dataset_path}/${EXTEND_DICT}.txt >> ${local_dataset_path}/dict.sum.txt
    if [ ! -e ${local_dataset_path}/${EXTEND_DICT}.txt ]; then
        echo "[ERROR] Load extend dictionary ${EXTEND_DICT}.txt failed!" >&2
    fi
fi

# # tokenize raw text
tokenize $INPATH $INPATH.spm ${local_dataset_path}/dict.doc.txt

echo "Finish download files" >&2

langs=ar_AR,cs_CZ,de_DE,en_XX,es_XX,et_EE,fi_FI,fr_XX,gu_IN,hi_IN,it_IT,ja_XX,kk_KZ,ko_KR,lt_LT,lv_LV,my_MM,ne_NP,nl_XX,ro_RO,ru_RU,si_LK,tr_TR,vi_VN,zh_CN
echo "Generating..."
suffix=$(echo "$argslist" | sed -e "s/-//g"  -e "s/  */_/g")

cat $INPATH.spm | sed -e "s/^/<s> /" > $INPATH.spm.special 

python3 fairseq/interactive.py ${resource_root}/dataset \
    --path ${local_checkpoint_path}/checkpoint_best.pt \
    --task multi_task_from_pretrained_mbart_mspm4 \
    --source-lang doc --target-lang sum \
    --langs $langs \
    --remove-bpe 'sentencepiece'  \
    --max-len-a 0.78 --max-len-b 2 --min-len 2 \
    --lenpen 0.6 \
    --no-repeat-ngram-size 3 \
    --truncate-source \
    --prefix-tokens ${TEST_LG_TAG} --doc-lang ${TEST_LG_TAG} \
    --user-dir examples/summarization \
    --batch-size 1 $argslist \
    < $INPATH.spm.special
    # > ${local_tensorboard_path}/"output$suffix"

exit 0

cat ${local_tensorboard_path}/"output$suffix" | grep -P "^H" | \
  sort -V |cut -f 3- | sed -e "s/\[[a-z]\{2\}_[A-Z]\{2\}\]//g" | sed -e "s/\[[a-z]\{,10\}\] //g" > ${local_tensorboard_path}/"test$suffix.hypo"

echo "Load ground truth file from ${wxz_prefix}/Datasets/multilingual/xgiga/raw/test.y.${TEST_LG}"
hadoop fs -get ${wxz_prefix}/Datasets/multilingual/xgiga/raw/test.y.${TEST_LG} ${local_dataset_path}

python3 utils/calRouge.py \
-c ${local_tensorboard_path}/"test$suffix.hypo" \
-r ${local_dataset_path}/test.y.${TEST_LG} \
-l ${TEST_LG} -d "<q>"


echo "Put ${local_tensorboard_path} to ${tensorboard_logdir}" >&2
hadoop fs -put -f ${local_tensorboard_path}/* ${tensorboard_logdir}/
sleep 600
