

class TransitionSystem:

    def __init__(self, state: State, action_set: List[Action]):
        self.state = state
        self.action_list = action_list

    def static_oracle(self, instance):
        self.state.initialize(instance)


class InitAction(Action):

    def __init__(self):
        self.priority = -1

    def do(self, state, instance):
        state['stack'].clear()
        state['buffer'].clear()
        state['history'].clear()
        state['tree'] = instace


class TerminalAction(Action):

    def __init__(self):
        self.priority = -1

    def can_do(self, state):
        return len(state['buffer'])==0 and len(state['stack'])==1 and state['stack'].first()==0


class ShiftAction(Action):

    def __init__(self, priority):
        self.priority = priority

    def can_do(self, state):
        return not state['buffer'].is_empty()

    def do(self, state):
        state['stack'].push(state['buffer'].pop())


class LeftArcAction(Action):

    def __init__(self, priority):
        self.priority = priority

    def can_do(self, state):
        return not state['stack'].is_empty() and state['stack'].first()!=0 and state['is_comp'][state['stack'].first()] == True

    def do(self, state):
        state['stack'].pop()


class RightArcAction(Action):

    def __init__(self, priority):
        self.priority = priority

    def can_do(self, state):
        return len(state['stack']) >= 2 and state['is_comp'][state['stack'].first()] == True

    def do(self, state):
        state['stack'].pop()


class ArcHybrid:

    def __init__(self):

        self.init_a = InitAction()
        self.terminal_a = TerminalAction()
        self.state = State()
