/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.parex;

import edu.cmu.parex.Paraphrase;
import edu.cmu.parex.PhraseTable;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ParaphraseExtractor {
    public static final double MIN_TRANS_PROB = 0.001;
    public static final double MIN_REL_FREQ = 0.001;
    public static final double MIN_FINAL_PROB = 0.01;
    public static final String SYMBOLS = "~`!@#$%^&*()-_=+[{]}\\|;:'\",<.>/?";

    private static boolean isClean(String string, HashSet<Character> hashSet) {
        for (int i = 0; i < string.length(); ++i) {
            if (!hashSet.contains(Character.valueOf(string.charAt(i)))) continue;
            return false;
        }
        return true;
    }

    private static boolean isUsable(int[] nArray, HashSet<Integer> hashSet) {
        for (int n : nArray) {
            if (hashSet.contains(n)) continue;
            return true;
        }
        return false;
    }

    private static boolean eqWords(int[] nArray, int[] nArray2) {
        if (nArray.length != nArray2.length) {
            return false;
        }
        for (int i = 0; i < nArray.length; ++i) {
            if (nArray[i] == nArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static void extractParaphrases(String string, String string2, String string3, String string4, String string5, double d, String string6) throws IOException {
        int[] nArray;
        Object object2;
        HashSet<Integer> hashSet;
        Object object3;
        Object object4;
        String string7;
        String[] stringArray;
        Object object5;
        int n;
        Serializable serializable;
        Object object6;
        String string8;
        PhraseTable phraseTable = new PhraseTable();
        Hashtable hashtable = new Hashtable();
        HashSet<Character> hashSet2 = new HashSet<Character>();
        for (int i = 0; i < string6.length(); ++i) {
            hashSet2.add(Character.valueOf(string6.charAt(i)));
        }
        System.err.println("Loading corpus");
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        while ((string8 = bufferedReader.readLine()) != null) {
            object6 = phraseTable.mapPhrase(string8);
            for (int i = 0; i < ((int[])object6).length; ++i) {
                serializable = hashtable;
                for (n = i; n < ((int[])object6).length; ++n) {
                    if (!((Hashtable)serializable).containsKey(object6[n])) {
                        ((Hashtable)serializable).put(object6[n], new Hashtable());
                    }
                    serializable = (Hashtable)((Hashtable)serializable).get(object6[n]);
                }
            }
        }
        object6 = new HashSet();
        HashSet<Integer> hashSet3 = new HashSet<Integer>();
        System.err.println("Loading common words (foreign)");
        bufferedReader = new BufferedReader(new FileReader(string3));
        while ((string8 = bufferedReader.readLine()) != null) {
            ((HashSet)object6).add(phraseTable.mapWord(string8));
        }
        System.err.println("Loading common words (english)");
        bufferedReader = new BufferedReader(new FileReader(string4));
        while ((string8 = bufferedReader.readLine()) != null) {
            hashSet3.add(phraseTable.mapWord(string8));
        }
        serializable = new File(string2).toURI().toURL();
        bufferedReader = new BufferedReader(new InputStreamReader(new GZIPInputStream(((URL)serializable).openStream())));
        n = 0;
        int n2 = 0;
        System.err.println("Loading phrases");
        while ((string8 = bufferedReader.readLine()) != null) {
            try {
                if (++n % 10000000 == 0) {
                    System.err.println(n + " (" + n2 + ")");
                }
                object5 = string8.split("\\|\\|\\|");
                stringArray = object5[0].trim();
                string7 = object5[1].trim();
                object4 = new StringTokenizer(object5[2]);
                double d2 = Double.parseDouble(((StringTokenizer)object4).nextToken());
                ((StringTokenizer)object4).nextToken();
                double d3 = Double.parseDouble(((StringTokenizer)object4).nextToken());
                String string9 = string7;
                object3 = stringArray;
                double d4 = d2;
                HashSet<Integer> hashSet4 = hashSet3;
                hashSet = object6;
                if (d4 < d || !ParaphraseExtractor.isClean(string9, hashSet2) || !ParaphraseExtractor.isClean((String)object3, hashSet2)) continue;
                object2 = phraseTable.mapPhrase(string9);
                nArray = phraseTable.mapPhrase((String)object3);
                if (!ParaphraseExtractor.isUsable(object2, hashSet4) || !ParaphraseExtractor.isUsable(nArray, hashSet)) continue;
                boolean bl = true;
                Object object = hashtable;
                for (int n3 : object2) {
                    if (!((Hashtable)object).containsKey(n3)) {
                        bl = false;
                        break;
                    }
                    object = (Hashtable)((Hashtable)object).get(n3);
                }
                if (!bl) continue;
                phraseTable.addPhrasePair(nArray, (int[])object2, d4);
                ++n2;
            }
            catch (Exception exception) {
                System.err.println("Skipping problematic line: " + string8);
            }
        }
        bufferedReader.close();
        object5 = new PrintWriter(new GZIPOutputStream(new FileOutputStream(new File(string5))));
        bufferedReader = new BufferedReader(new InputStreamReader(new GZIPInputStream(((URL)serializable).openStream())));
        n = 0;
        n2 = 0;
        System.err.println("Finding paraphrases");
        while ((string8 = bufferedReader.readLine()) != null) {
            try {
                if (++n % 10000000 == 0) {
                    System.err.println(n + " (" + n2 + ")");
                }
                stringArray = string8.split("\\|\\|\\|");
                string7 = stringArray[0].trim();
                object4 = stringArray[1].trim();
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray[2]);
                double d2 = Double.parseDouble(stringTokenizer.nextToken());
                stringTokenizer.nextToken();
                double d3 = Double.parseDouble(stringTokenizer.nextToken());
                object3 = object4;
                String string10 = string7;
                double d4 = d3;
                hashSet = hashSet3;
                object2 = object6;
                if (d4 < d || !ParaphraseExtractor.isClean((String)object3, hashSet2) || !ParaphraseExtractor.isClean(string10, hashSet2)) continue;
                nArray = phraseTable.mapPhrase((String)object3);
                int[] nArray2 = phraseTable.mapPhrase(string10);
                if (!ParaphraseExtractor.isUsable(nArray, hashSet) || !ParaphraseExtractor.isUsable(nArray2, (HashSet<Integer>)object2)) continue;
                for (PhraseTable.Phrase phrase : phraseTable.getPhrases(nArray2)) {
                    double d5;
                    if (ParaphraseExtractor.eqWords(phrase.words, nArray) || (d5 = phrase.prob * d4) < d) continue;
                    ((PrintWriter)object5).println(phrase.phrase + " ||| " + (String)object3 + " ||| " + string10 + " ||| " + d5);
                    ++n2;
                }
            }
            catch (Exception exception) {
                System.err.println("Skipping problematic line: " + string8);
            }
        }
        bufferedReader.close();
        ((PrintWriter)object5).close();
    }

    public static void findCommonWords(String string, String string2, double d) throws IOException {
        Object object;
        Object object2;
        Object object3;
        String string3;
        Hashtable<Object, Integer> hashtable = new Hashtable<Object, Integer>();
        int n = 0;
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        while ((string3 = bufferedReader.readLine()) != null) {
            object3 = new StringTokenizer(string3);
            while (((StringTokenizer)object3).hasMoreTokens()) {
                object2 = ((StringTokenizer)object3).nextToken();
                object = (Integer)hashtable.get(object2);
                if (object == null) {
                    object = 0;
                }
                hashtable.put(object2, (Integer)object + 1);
                ++n;
            }
        }
        bufferedReader.close();
        object3 = new PrintWriter(string2);
        object2 = hashtable.keys();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            double d2 = (double)((Integer)hashtable.get(object)).intValue() / (double)n;
            if (!(d2 > d)) continue;
            ((PrintWriter)object3).println((String)object);
        }
        ((PrintWriter)object3).close();
    }

    public static void groupParaphrases(String string, String string2) throws IOException {
        Object object;
        String string3;
        URL uRL = new File(string).toURI().toURL();
        File file = new File(string2);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new GZIPInputStream(uRL.openStream())));
        final PhraseTable phraseTable = new PhraseTable();
        ArrayList<Paraphrase> arrayList = new ArrayList<Paraphrase>();
        int n = 0;
        while ((string3 = bufferedReader.readLine()) != null) {
            if (++n % 1000000 == 0) {
                System.err.println(n);
            }
            object = string3.split("\\|\\|\\|");
            String string4 = object[0].trim();
            String object2 = object[1].trim();
            double d = Double.parseDouble(object[3].trim());
            arrayList.add(new Paraphrase(phraseTable.mapPhrase(string4), phraseTable.mapPhrase(object2), d));
        }
        bufferedReader.close();
        Collections.sort(arrayList, new Comparator<Paraphrase>(){

            @Override
            public int compare(Paraphrase paraphrase, Paraphrase paraphrase2) {
                int n = phraseTable.unmapPhrase(paraphrase.ref).compareTo(phraseTable.unmapPhrase(paraphrase2.ref));
                if (n != 0) {
                    return n;
                }
                return phraseTable.unmapPhrase(paraphrase.par).compareTo(phraseTable.unmapPhrase(paraphrase2.par));
            }
        });
        object = new PrintWriter(new GZIPOutputStream(new FileOutputStream(file)));
        for (Paraphrase paraphrase : arrayList) {
            ((PrintWriter)object).println(phraseTable.unmapPhrase(paraphrase.ref) + " ||| " + phraseTable.unmapPhrase(paraphrase.par) + " ||| " + paraphrase.prob);
        }
        ((PrintWriter)object).close();
    }

    public static void combineParaphrases(String string, String string2, double d) throws IOException {
        String string3;
        URL uRL = new File(string).toURI().toURL();
        File file = new File(string2);
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(new GZIPInputStream(uRL.openStream())));
        PrintWriter printWriter = new PrintWriter(new GZIPOutputStream(new FileOutputStream(file)));
        String string4 = "";
        String string5 = "";
        double d2 = 0.0;
        while ((string3 = bufferedReader.readLine()) != null) {
            String[] stringArray = string3.split("\\|\\|\\|");
            String string6 = stringArray[0].trim();
            String string7 = stringArray[1].trim();
            double d3 = Double.parseDouble(stringArray[2].trim());
            if (!string6.equals(string4) || !string7.equals(string5)) {
                if (!string4.equals("") && d2 >= d && !ParaphraseExtractor.subphrase(string4, string5)) {
                    printWriter.println(string4 + " ||| " + string5 + " ||| " + d2);
                }
                string4 = string6;
                string5 = string7;
                d2 = 0.0;
            }
            d2 += d3;
        }
        if (!string4.equals("") && d2 >= d && !ParaphraseExtractor.subphrase(string4, string5)) {
            printWriter.println(string4 + " ||| " + string5 + " ||| " + d2);
        }
        bufferedReader.close();
        printWriter.close();
    }

    public static boolean subphrase(String string, String string2) {
        String string3;
        String string4 = " " + string + " ";
        return string4.contains(string3 = " " + string2 + " ") || string3.contains(string4);
    }
}

