# -*- coding: utf-8 -*-

from framework.common.utils import MethodFactory

from .full_search import FullSearchEvaluator
from .multi_threads import MultiThreadsEvaluator
from .single_thread import SingleThreadEvaluator

EVALUATORS = MethodFactory()
EVALUATORS.register('multithreads', fn=MultiThreadsEvaluator)
EVALUATORS.register('single', fn=SingleThreadEvaluator)
EVALUATORS.register('full', fn=FullSearchEvaluator)
