import json
import glob



def get_protected_authors(files):
    authors = []
    for file in files:
        with open(file, 'r') as f:
            transfer_pairs = json.load(f)
        for pair in transfer_pairs:
            authors.append(pair['source_user_id'])
            authors.append(pair['target_user_id'])
    return sorted(set(authors))


if __name__ == '__main__':
    authors = get_protected_authors(sorted(glob.glob('gpt3/*.json')))
    with open('protected_authors.txt', 'w') as f:
        for author in authors:
            f.write(author + '\n')
