/*
 * Decompiled with CFR 0.152.
 */
package edu.cmu.meteor.aligner;

import edu.cmu.meteor.aligner.Match;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.StringTokenizer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Alignment {
    public ArrayList<String> words1;
    public ArrayList<String> words2;
    public HashSet<Integer> line1FunctionWords;
    public HashSet<Integer> line2FunctionWords;
    public Match[] matches;
    public int line1Matches;
    public int line2Matches;
    public ArrayList<Integer> moduleContentMatches1;
    public ArrayList<Integer> moduleContentMatches2;
    public ArrayList<Integer> moduleFunctionMatches1;
    public ArrayList<Integer> moduleFunctionMatches2;
    public int numChunks;
    public double avgChunkLength;

    public Alignment(String string, String string2) {
        this.words1 = this.tokenize(string);
        this.words2 = this.tokenize(string2);
        this.initData(this.words2.size());
    }

    public Alignment(ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        this.words1 = new ArrayList<String>(arrayList);
        this.words2 = new ArrayList<String>(arrayList2);
        this.initData(this.words2.size());
    }

    private void initData(int n) {
        this.line1FunctionWords = new HashSet();
        this.line2FunctionWords = new HashSet();
        this.matches = new Match[n];
        this.line1Matches = 0;
        this.line2Matches = 0;
        this.moduleContentMatches1 = new ArrayList();
        this.moduleContentMatches2 = new ArrayList();
        this.moduleFunctionMatches1 = new ArrayList();
        this.moduleFunctionMatches2 = new ArrayList();
        this.numChunks = 0;
        this.avgChunkLength = 0.0;
    }

    private ArrayList<String> tokenize(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string);
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    public void printMatchedPhrases() {
        System.out.println(this.words1);
        System.out.println(this.words2);
        for (Match match : this.matches) {
            int n;
            if (match == null) continue;
            String string = match.module + " : ";
            for (n = match.start; n < match.start + match.length; ++n) {
                string = string + this.words2.get(n) + " ";
            }
            string = string + "== ";
            for (n = match.matchStart; n < match.matchStart + match.matchLength; ++n) {
                string = string + this.words1.get(n) + " ";
            }
            System.out.println(string.trim());
        }
    }

    public String toString() {
        return this.toString("Alignment");
    }

    /*
     * WARNING - void declaration
     */
    public String toString(String string) {
        void var5_8;
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string + "\n");
        StringBuilder stringBuilder2 = new StringBuilder();
        for (String object : this.words1) {
            stringBuilder2.append(object + " ");
        }
        stringBuilder.append(stringBuilder2.toString().trim() + "\n");
        StringBuilder stringBuilder3 = new StringBuilder();
        for (String string2 : this.words2) {
            stringBuilder3.append(string2 + " ");
        }
        stringBuilder.append(stringBuilder3.toString().trim() + "\n");
        stringBuilder.append("Line2Start:Length\tLine1Start:Length\tModule\t\tScore\n");
        boolean bl = false;
        while (var5_8 < this.matches.length) {
            Match match = this.matches[var5_8];
            if (match != null) {
                stringBuilder.append(match.start + ":" + match.length + "\t\t\t");
                stringBuilder.append(match.matchStart + ":" + match.matchLength + "\t\t\t");
                stringBuilder.append(match.module + "\t\t");
                stringBuilder.append(match.prob + "\n");
            }
            ++var5_8;
        }
        return stringBuilder.toString();
    }
}

