/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.CoindexationGenerator;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import java.util.List;
import java.util.Map;

class PruneNode
extends TsurgeonPattern {
    public PruneNode(TsurgeonPattern[] children) {
        super("prune", children);
    }

    public PruneNode(List<TsurgeonPattern> children) {
        this(children.toArray(new TsurgeonPattern[children.size()]));
    }

    @Override
    public TsurgeonMatcher matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
        return new Matcher(newNodeNames, coindexer);
    }

    private static Tree pruneHelper(Tree root, Tree nodeToPrune) {
        if (nodeToPrune == root) {
            return null;
        }
        Tree parent = nodeToPrune.parent(root);
        parent.removeChild(Trees.objectEqualityIndexOf(parent, nodeToPrune));
        if (parent.children().length == 0) {
            return PruneNode.pruneHelper(root, parent);
        }
        return root;
    }

    private class Matcher
    extends TsurgeonMatcher {
        public Matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
            super(PruneNode.this, newNodeNames, coindexer);
        }

        @Override
        public Tree evaluate(Tree tree, TregexMatcher tregex) {
            boolean prunedWholeTree = false;
            for (TsurgeonMatcher child : this.childMatcher) {
                Tree nodeToPrune = child.evaluate(tree, tregex);
                if (PruneNode.pruneHelper(tree, nodeToPrune) != null) continue;
                prunedWholeTree = true;
            }
            return prunedWholeTree ? null : tree;
        }
    }
}

