/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees.tregex.tsurgeon;

import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.Trees;
import edu.stanford.nlp.trees.tregex.TregexMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.CoindexationGenerator;
import edu.stanford.nlp.trees.tregex.tsurgeon.Tsurgeon;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonMatcher;
import edu.stanford.nlp.trees.tregex.tsurgeon.TsurgeonPattern;
import java.util.Map;

class ExciseNode
extends TsurgeonPattern {
    public ExciseNode(TsurgeonPattern top, TsurgeonPattern bottom) {
        super("excise", new TsurgeonPattern[]{top, bottom});
    }

    public ExciseNode(TsurgeonPattern node) {
        super("excise", new TsurgeonPattern[]{node, node});
    }

    @Override
    public TsurgeonMatcher matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
        return new Matcher(newNodeNames, coindexer);
    }

    private class Matcher
    extends TsurgeonMatcher {
        public Matcher(Map<String, Tree> newNodeNames, CoindexationGenerator coindexer) {
            super(ExciseNode.this, newNodeNames, coindexer);
        }

        @Override
        public Tree evaluate(Tree tree, TregexMatcher tregex) {
            Tree topNode = this.childMatcher[0].evaluate(tree, tregex);
            Tree bottomNode = this.childMatcher[1].evaluate(tree, tregex);
            if (Tsurgeon.verbose) {
                System.err.println("Excising...original tree:");
                tree.pennPrint(System.err);
                System.err.println("top: " + topNode + "\nbottom:" + bottomNode);
            }
            if (topNode == tree) {
                if (bottomNode.children().length == 1) {
                    return bottomNode.children()[0];
                }
                return null;
            }
            Tree parent = topNode.parent(tree);
            if (Tsurgeon.verbose) {
                System.err.println("Parent: " + parent);
            }
            int i = Trees.objectEqualityIndexOf(parent, topNode);
            parent.removeChild(i);
            for (Tree child : bottomNode.children()) {
                parent.addChild(i, child);
                ++i;
            }
            if (Tsurgeon.verbose) {
                tree.pennPrint(System.err);
            }
            return tree;
        }
    }
}

