/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.parser.lexparser;

import edu.stanford.nlp.ling.CategoryWordTag;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.trees.TreeTransformer;
import java.io.PrintWriter;
import java.io.Serializable;
import java.util.Set;

public class TrainOptions
implements Serializable {
    public String trainTreeFile = null;
    public int trainLengthLimit = 100000;
    public boolean cheatPCFG = false;
    public boolean markovFactor = false;
    public int markovOrder = 1;
    public boolean hSelSplit = false;
    public int HSEL_CUT = 10;
    public boolean markFinalStates = true;
    public int openClassTypesThreshold = 50;
    public double fractionBeforeUnseenCounting = 0.5;
    public boolean PA = true;
    public boolean gPA = false;
    public boolean postPA = false;
    public boolean postGPA = false;
    public boolean selectiveSplit = false;
    public double selectiveSplitCutOff = 0.0;
    public boolean selectivePostSplit = false;
    public double selectivePostSplitCutOff = 0.0;
    public boolean postSplitWithBaseCategory = false;
    public boolean sisterAnnotate = false;
    public Set<String> sisterSplitters;
    public int markUnary = 0;
    public boolean markUnaryTags = false;
    public boolean splitPrePreT = false;
    public boolean tagPA = false;
    public boolean tagSelectiveSplit = false;
    public double tagSelectiveSplitCutOff = 0.0;
    public boolean tagSelectivePostSplit = false;
    public double tagSelectivePostSplitCutOff = 0.0;
    public boolean rightRec = false;
    public boolean leftRec = false;
    public boolean collinsPunc = false;
    public Set<String> splitters;
    public Set postSplitters;
    public Set<String> deleteSplitters;
    public int printTreeTransformations = 0;
    public PrintWriter printAnnotatedPW;
    public PrintWriter printBinarizedPW;
    public boolean printStates = false;
    public int compactGrammar = 3;
    public boolean leftToRight = false;
    public boolean noTagSplit = false;
    public boolean ruleSmoothing = false;
    public double ruleSmoothingAlpha = 0.0;
    public boolean smoothing = false;
    public double ruleDiscount = 0.0;
    public boolean printAnnotatedRuleCounts = false;
    public boolean printAnnotatedStateCounts = false;
    public boolean basicCategoryTagsInDependencyGrammar = false;
    public TreeTransformer preTransformer = null;
    public String taggedFiles = null;
    public boolean predictSplits = false;
    public int splitCount = 1;
    public double splitRecombineRate = 0.0;
    public boolean simpleBinarizedLabels = false;
    public boolean noRebinarization = false;
    public int trainingThreads = 1;
    public static final int DEFAULT_K_BEST = 100;
    public int dvKBest = 100;
    public static final int DEFAULT_TRAINING_ITERATIONS = 40;
    public int trainingIterations = 40;
    public static final int DEFAULT_BATCH_SIZE = 25;
    public int batchSize = 25;
    public static final double DEFAULT_REGCOST = 1.0E-4;
    public double regCost = 1.0E-4;
    public static final int DEFAULT_QN_ITERATIONS_PER_BATCH = 1;
    public int qnIterationsPerBatch = 1;
    public int qnEstimates = 15;
    public double qnTolerance = 15.0;
    public int debugOutputFrequency = 0;
    public long randomSeed = 0L;
    public static final double DEFAULT_LEARNING_RATE = 0.1;
    public double learningRate = 0.1;
    public static final double DEFAULT_DELTA_MARGIN = 0.1;
    public double deltaMargin = 0.1;
    public boolean unknownNumberVector = true;
    public boolean unknownDashedWordVectors = true;
    public boolean unknownCapsVector = true;
    public boolean dvSimplifiedModel = false;
    public boolean unknownChineseYearVector = true;
    public boolean unknownChineseNumberVector = true;
    public boolean unknownChinesePercentVector = true;
    public static final double DEFAULT_SCALING_FOR_INIT = 0.5;
    public double scalingForInit = 0.5;
    public int maxTrainTimeSeconds = 0;
    public static final String DEFAULT_UNK_WORD = "*UNK*";
    public String unkWord = "*UNK*";
    public boolean lowercaseWordVectors = false;
    public TransformMatrixType transformMatrixType = TransformMatrixType.DIAGONAL;
    public boolean useContextWords = false;
    public boolean trainWordVectors = true;
    public static final int DEFAULT_STALLED_ITERATION_LIMIT = 12;
    public int stalledIterationLimit = 12;
    public boolean markStrahler;
    private static final long serialVersionUID = 72571349843538L;

    public boolean outsideFactor() {
        return !this.markovFactor;
    }

    public int compactGrammar() {
        if (this.markovFactor) {
            return this.compactGrammar;
        }
        return 0;
    }

    public void display() {
        System.err.println(this.toString());
    }

    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append("Train parameters:\n");
        result.append(" smooth=" + this.smoothing + "\n");
        result.append(" PA=" + this.PA + "\n");
        result.append(" GPA=" + this.gPA + "\n");
        result.append(" selSplit=" + this.selectiveSplit + "\n");
        result.append(" (" + this.selectiveSplitCutOff + (this.deleteSplitters != null ? "; deleting " + this.deleteSplitters : "") + ")" + "\n");
        result.append(" mUnary=" + this.markUnary + "\n");
        result.append(" mUnaryTags=" + this.markUnaryTags + "\n");
        result.append(" sPPT=" + this.splitPrePreT + "\n");
        result.append(" tagPA=" + this.tagPA + "\n");
        result.append(" tagSelSplit=" + this.tagSelectiveSplit + " (" + this.tagSelectiveSplitCutOff + ")" + "\n");
        result.append(" rightRec=" + this.rightRec + "\n");
        result.append(" leftRec=" + this.leftRec + "\n");
        result.append(" collinsPunc=" + this.collinsPunc + "\n");
        result.append(" markov=" + this.markovFactor + "\n");
        result.append(" mOrd=" + this.markovOrder + "\n");
        result.append(" hSelSplit=" + this.hSelSplit + " (" + this.HSEL_CUT + ")" + "\n");
        result.append(" compactGrammar=" + this.compactGrammar() + "\n");
        result.append(" postPA=" + this.postPA + "\n");
        result.append(" postGPA=" + this.postGPA + "\n");
        result.append(" selPSplit=" + this.selectivePostSplit + " (" + this.selectivePostSplitCutOff + ")" + "\n");
        result.append(" tagSelPSplit=" + this.tagSelectivePostSplit + " (" + this.tagSelectivePostSplitCutOff + ")" + "\n");
        result.append(" postSplitWithBase=" + this.postSplitWithBaseCategory + "\n");
        result.append(" fractionBeforeUnseenCounting=" + this.fractionBeforeUnseenCounting + "\n");
        result.append(" openClassTypesThreshold=" + this.openClassTypesThreshold + "\n");
        result.append(" preTransformer=" + this.preTransformer + "\n");
        result.append(" taggedFiles=" + this.taggedFiles + "\n");
        result.append(" predictSplits=" + this.predictSplits + "\n");
        result.append(" splitCount=" + this.splitCount + "\n");
        result.append(" splitRecombineRate=" + this.splitRecombineRate + "\n");
        result.append(" simpleBinarizedLabels=" + this.simpleBinarizedLabels + "\n");
        result.append(" noRebinarization=" + this.noRebinarization + "\n");
        result.append(" trainingThreads=" + this.trainingThreads + "\n");
        result.append(" dvKBest=" + this.dvKBest + "\n");
        result.append(" trainingIterations=" + this.trainingIterations + "\n");
        result.append(" batchSize=" + this.batchSize + "\n");
        result.append(" regCost=" + this.regCost + "\n");
        result.append(" qnIterationsPerBatch=" + this.qnIterationsPerBatch + "\n");
        result.append(" qnEstimates=" + this.qnEstimates + "\n");
        result.append(" qnTolerance=" + this.qnTolerance + "\n");
        result.append(" debugOutputFrequency=" + this.debugOutputFrequency + "\n");
        result.append(" randomSeed=" + this.randomSeed + "\n");
        result.append(" learningRate=" + this.learningRate + "\n");
        result.append(" deltaMargin=" + this.deltaMargin + "\n");
        result.append(" unknownNumberVector=" + this.unknownNumberVector + "\n");
        result.append(" unknownDashedWordVectors=" + this.unknownDashedWordVectors + "\n");
        result.append(" unknownCapsVector=" + this.unknownCapsVector + "\n");
        result.append(" unknownChineseYearVector=" + this.unknownChineseYearVector + "\n");
        result.append(" unknownChineseNumberVector=" + this.unknownChineseNumberVector + "\n");
        result.append(" unknownChinesePercentVector=" + this.unknownChinesePercentVector + "\n");
        result.append(" dvSimplifiedModel=" + this.dvSimplifiedModel + "\n");
        result.append(" scalingForInit=" + this.scalingForInit + "\n");
        result.append(" maxTrainTimeSeconds=" + this.maxTrainTimeSeconds + "\n");
        result.append(" unkWord=" + this.unkWord + "\n");
        result.append(" lowercaseWordVectors=" + this.lowercaseWordVectors + "\n");
        result.append(" transformMatrixType=" + (Object)((Object)this.transformMatrixType) + "\n");
        result.append(" useContextWords=" + this.useContextWords + "\n");
        result.append(" trainWordVectors=" + this.trainWordVectors + "\n");
        result.append(" stalledIterationLimit=" + this.stalledIterationLimit + "\n");
        result.append(" markStrahler=" + this.markStrahler + "\n");
        return result.toString();
    }

    public static void printTrainTree(PrintWriter pw, String message, Tree t) {
        PrintWriter myPW = pw == null ? new PrintWriter(System.out, true) : pw;
        if (message != null && pw == null) {
            myPW.println(message);
        }
        boolean previousState = CategoryWordTag.printWordTag;
        CategoryWordTag.printWordTag = false;
        t.pennPrint(myPW);
        CategoryWordTag.printWordTag = previousState;
    }

    public static enum TransformMatrixType {
        DIAGONAL,
        RANDOM,
        OFF_DIAGONAL,
        RANDOM_ZEROS;

    }
}

