
from datasets.spot_the_bot import load_annotated

from binary.roc import metric_aurocs


def main():
    annotated = load_annotated()

    for domain, data in annotated.items():
        human = data['human']
        metrics = data['metric']

        scores = metric_aurocs(
            human_annotations=human,
            metrics=metrics,
        )

        print(f"=={domain}==")
        print("metric\tauroc")
        for metric, score in scores:
            print(f"{metric}\t{score:.4f}")


if __name__ == '__main__':
    main()
