root=./
#export PYTHONPATH=$root:$PYTHONPATH
if [ ! $1 ]; then
    $1=''
fi

SUFFIX=$1
model_signature=${SUFFIX}
export CUDA_VISIBLE_DEVICES=0,1,2,3
python ${root}/fairseq_cli/my_train.py \
    ${root}/data-bin/wmt14_en_de \
    --task my_translation \
    --mode at \
    --source-lang en --target-lang de \
    --arch my_at_nat_transformer --share-all-embeddings \
    --optimizer adam --adam-betas '(0.9, 0.98)' --clip-norm 0.0 \
    --save-dir ${root}/checkpoints/wmt14_en_de/${model_signature} \
    --ddp-backend=no_c10d \
    --max-update 300000 --save-interval-updates 5000 \
    --keep-interval-updates 40 \
    --lr 7e-4 --lr-scheduler inverse_sqrt --warmup-updates 4000 \
    --weight-decay 0.0 \
    --criterion my_criterion --label-smoothing 0.1 \
    --encoder-normalize-before --at-decoder-normalize-before --nat-decoder-normalize-before \
    --max-tokens 8192 \
    --eval-bleu \
    --eval-bleu-args '{"beam": 4, "max_len_a": 1.2, "max_len_b": 10}' \
    --eval-bleu-detok moses \
    --eval-bleu-remove-bpe \
    --eval-bleu-print-samples \
    --best-checkpoint-metric bleu --maximize-best-checkpoint-metric \
    --encoder-layers 6 \
    --at-decoder-layers 6 \
    --nat-decoder-layers 6 \
    --apply-bert-init \
    --noise random_mask
