LANGUAGE=$1
MODEL_TYPE=$2
DATA_TYPE=$3
CHECKPOINT=$4
DEVICE=$5

MODEL=../models/mbart.cc25.v2/sentence.bpe.model
SRC=input
TGT=target
langs=ar_AR,cs_CZ,de_DE,en_XX,es_XX,et_EE,fi_FI,fr_XX,gu_IN,hi_IN,it_IT,ja_XX,kk_KZ,ko_KR,lt_LT,lv_LV,my_MM,ne_NP,nl_XX,ro_RO,ru_RU,si_LK,tr_TR,vi_VN,zh_CN
BIN_DIR=../models/${LANGUAGE}/${MODEL_TYPE}/test-bin   
OUT_FILE=../models/${LANGUAGE}/${MODEL_TYPE}/${DATA_TYPE}-data/test.predicted
if [[ "$MODEL_TYPE" == gen2oie_s2 ]]; then 
    BIN_DIR=../models/${LANGUAGE}/${MODEL_TYPE}/${DATA_TYPE}-bin
    OUT_FILE=../models/${LANGUAGE}/${MODEL_TYPE}/${DATA_TYPE}-data/test.pre_predicted
fi
# only runs on V100 GPU. If not available, add --cpu for running on CPU
CUDA_VISIBLE_DEVICES=${DEVICE} fairseq-generate ${BIN_DIR} --path ../models/${LANGUAGE}/${MODEL_TYPE}/${DATA_TYPE}-checkpoints/${CHECKPOINT}  --task translation_from_pretrained_bart --gen-subset test -t target -s input --sacrebleu --remove-bpe 'sentencepiece' --langs $langs --max-sentences 32 --max-source-positions 512 > ../models/${LANGUAGE}/${MODEL_TYPE}/${DATA_TYPE}-data/test_output
cat ../models/${LANGUAGE}/${MODEL_TYPE}/${DATA_TYPE}-data/test_output  | grep -P "^H" |sort -V |cut -f 3- > ${OUT_FILE}