#!/bin/bash

source "batch_jobs/_experiment_configuration.sh"

# Actual time:   ["bert-base-uncased"]="??:??:??" ["albert-base-v2"]="??:??:??" ["roberta-base"]="??:??:??" ["gpt2"]="??:??:??"
declare -A time=(["bert-base-uncased"]="02:00:00" ["albert-base-v2"]="02:00:00" ["roberta-base"]="02:00:00" ["gpt2"]="02:00:00")


for model in ${masked_lm_models[@]}; do
    for score_type in ${stereoset_score_types[@]}; do
        for split in ${stereoset_splits[@]}; do
            experiment_id="stereoset_intra-${model}_c-${model_to_model_name_or_path[${model}]}_s-${score_type}_d-${split}"
            if [ ! -f "${persistent_dir}/results/stereoset/${experiment_id}.json" ]; then
                echo ${experiment_id}
                sbatch \
                    --time ${time[${model_to_model_name_or_path[${model}]}]} \
                    -J ${experiment_id} \
                    -o $HOME/scratch/debias-eval/logs/%x.%j.out \
                    -e $HOME/scratch/debias-eval/logs/%x.%j.err \
                    python_job.sh experiments/stereoset.py \
                        --intrasentence_model ${model} \
                        --model_name_or_path ${model_to_model_name_or_path[${model}]} \
                        --score_type ${score_type} \
                        --split ${split}
            fi
        done
    done
done


for model in ${causal_lm_models[@]}; do
    for split in ${stereoset_splits[@]}; do
        experiment_id="stereoset_intra-${model}_c-${model_to_model_name_or_path[${model}]}_s-likelihood_d-${split}"
        if [ ! -f "${persistent_dir}/results/stereoset/${experiment_id}.json" ]; then
            echo ${experiment_id}
            sbatch \
                --time ${time[${model_to_model_name_or_path[${model}]}]} \
                -J ${experiment_id} \
                -o $HOME/scratch/debias-eval/logs/%x.%j.out \
                -e $HOME/scratch/debias-eval/logs/%x.%j.err \
                python_job.sh experiments/stereoset.py \
                    --intrasentence_model ${model} \
                    --model_name_or_path ${model_to_model_name_or_path[${model}]} \
                    --score_type "likelihood" \
                    --split ${split}
        fi
    done
done
