/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.trees;

import edu.stanford.nlp.trees.EnglishGrammaticalStructure;
import edu.stanford.nlp.trees.GrammaticalStructureFactory;
import edu.stanford.nlp.trees.HeadFinder;
import edu.stanford.nlp.trees.Tree;
import edu.stanford.nlp.util.Filter;

public class EnglishGrammaticalStructureFactory
implements GrammaticalStructureFactory {
    private final Filter<String> puncFilter;
    private final HeadFinder hf;

    public EnglishGrammaticalStructureFactory() {
        this(null, null);
    }

    public EnglishGrammaticalStructureFactory(Filter<String> puncFilter) {
        this(puncFilter, null);
    }

    public EnglishGrammaticalStructureFactory(Filter<String> puncFilter, HeadFinder hf) {
        this.puncFilter = puncFilter;
        this.hf = hf;
    }

    @Override
    public EnglishGrammaticalStructure newGrammaticalStructure(Tree t) {
        if (this.puncFilter == null && this.hf == null) {
            return new EnglishGrammaticalStructure(t);
        }
        if (this.hf == null) {
            return new EnglishGrammaticalStructure(t, this.puncFilter);
        }
        return new EnglishGrammaticalStructure(t, this.puncFilter, this.hf);
    }
}

