/*
 * Decompiled with CFR 0.152.
 */
package org.fusesource.lmdbjni;

import org.fusesource.lmdbjni.ByteUnit;
import org.fusesource.lmdbjni.Constants;
import org.fusesource.lmdbjni.Database;
import org.fusesource.lmdbjni.EnvInfo;
import org.fusesource.lmdbjni.JNI;
import org.fusesource.lmdbjni.LMDBException;
import org.fusesource.lmdbjni.NativeBuffer;
import org.fusesource.lmdbjni.NativeObject;
import org.fusesource.lmdbjni.Stat;
import org.fusesource.lmdbjni.Transaction;
import org.fusesource.lmdbjni.Util;

public class Env
extends NativeObject
implements AutoCloseable {
    private boolean open = false;

    public static String version() {
        return Util.string(JNI.MDB_VERSION_STRING);
    }

    public Env(String path) {
        super(Env.create());
        this.setMaxDbs(1L);
        this.open(path);
    }

    public Env() {
        super(Env.create());
        this.setMaxDbs(1L);
    }

    private static long create() {
        long[] env_ptr = new long[1];
        Util.checkErrorCode(JNI.mdb_env_create(env_ptr));
        return env_ptr[0];
    }

    public void open(String path) {
        this.open(path, 0);
    }

    public void open(String path, int flags) {
        this.open(path, flags, 420);
    }

    public void open(String path, int flags, int mode) {
        int rc = JNI.mdb_env_open(this.pointer(), path, flags, mode);
        if (rc != 0) {
            this.close();
        }
        Util.checkErrorCode(rc);
        this.open = true;
    }

    @Override
    public void close() {
        if (this.self != 0L) {
            JNI.mdb_env_close(this.self);
            this.self = 0L;
        }
    }

    public void copy(String path) {
        Util.checkArgNotNull(path, "path");
        Util.checkErrorCode(JNI.mdb_env_copy(this.pointer(), path));
    }

    public void copyCompact(String path) {
        Util.checkArgNotNull(path, "path");
        Util.checkErrorCode(JNI.mdb_env_copy2(this.pointer(), path, 1));
    }

    public void sync(boolean force) {
        Util.checkErrorCode(JNI.mdb_env_sync(this.pointer(), force ? 1 : 0));
    }

    public void setMapSize(long size) {
        Util.checkErrorCode(JNI.mdb_env_set_mapsize(this.pointer(), size));
    }

    public void setMapSize(long size, ByteUnit unit) {
        Util.checkErrorCode(JNI.mdb_env_set_mapsize(this.pointer(), unit.toBytes(size)));
    }

    public void setMaxDbs(long size) {
        Util.checkErrorCode(JNI.mdb_env_set_maxdbs(this.pointer(), size));
    }

    public long getMaxReaders() {
        long[] rc = new long[1];
        Util.checkErrorCode(JNI.mdb_env_get_maxreaders(this.pointer(), rc));
        return rc[0];
    }

    public void setMaxReaders(long size) {
        Util.checkErrorCode(JNI.mdb_env_set_maxreaders(this.pointer(), size));
    }

    public int getFlags() {
        long[] flags = new long[1];
        Util.checkErrorCode(JNI.mdb_env_get_flags(this.pointer(), flags));
        return (int)flags[0];
    }

    public void addFlags(int flags) {
        Util.checkErrorCode(JNI.mdb_env_set_flags(this.pointer(), flags, 1));
    }

    public void removeFlags(int flags) {
        Util.checkErrorCode(JNI.mdb_env_set_flags(this.pointer(), flags, 0));
    }

    public EnvInfo info() {
        JNI.MDB_envinfo rc = new JNI.MDB_envinfo();
        JNI.mdb_env_info(this.pointer(), rc);
        return new EnvInfo(rc);
    }

    public Stat stat() {
        JNI.MDB_stat rc = new JNI.MDB_stat();
        JNI.mdb_env_stat(this.pointer(), rc);
        return new Stat(rc);
    }

    @Deprecated
    public Transaction createTransaction() {
        return this.createTransaction(null, false);
    }

    @Deprecated
    public Transaction createTransaction(boolean readOnly) {
        return this.createTransaction(null, readOnly);
    }

    public Transaction createReadTransaction() {
        return this.createTransaction(null, true);
    }

    public Transaction createWriteTransaction() {
        return this.createTransaction(null, false);
    }

    public Transaction createTransaction(Transaction parent) {
        return this.createTransaction(parent, false);
    }

    public Transaction createTransaction(Transaction parent, boolean readOnly) {
        this.checkOpen();
        long[] txpointer = new long[1];
        Util.checkErrorCode(JNI.mdb_txn_begin(this.pointer(), parent == null ? 0L : parent.pointer(), readOnly ? (long)JNI.MDB_RDONLY : 0L, txpointer));
        return new Transaction(txpointer[0], readOnly);
    }

    public Database openDatabase(Transaction tx, String name, int flags) {
        this.checkOpen();
        Util.checkArgNotNull(tx, "tx");
        long[] dbi = new long[1];
        Util.checkErrorCode(JNI.mdb_dbi_open(tx.pointer(), name, flags, dbi));
        return new Database(this, dbi[0]);
    }

    public Database openDatabase() {
        return this.openDatabase(null, Constants.CREATE);
    }

    public Database openDatabase(String name) {
        return this.openDatabase(name, Constants.CREATE);
    }

    public Database openDatabase(String name, int flags) {
        try (Transaction tx = this.createWriteTransaction();){
            Database db = this.openDatabase(tx, name, flags);
            tx.commit();
            Database database = db;
            return database;
        }
    }

    public static void pushMemoryPool(int size) {
        NativeBuffer.pushMemoryPool(size);
    }

    public static void popMemoryPool() {
        NativeBuffer.popMemoryPool();
    }

    public long getMaxKeySize() {
        return JNI.mdb_env_get_maxkeysize(this.pointer());
    }

    public int readerCheck() {
        int[] staleSlots = new int[1];
        Util.checkErrorCode(JNI.mdb_reader_check(this.pointer(), staleSlots));
        return staleSlots[0];
    }

    private void checkOpen() {
        if (!this.open) {
            throw new LMDBException("Environment not open yet.");
        }
    }
}

