# PPT: Pre-trained Prompt Tuning for Few-Shot Learning

## 1 Installation
```[bash]
pip3 install -r requirements
```

## 2 Prepare Datasets
We provide the preprocessed datasets in https://drive.google.com/drive/folders/1Q6lMm48LcGZILQGI-0RaRJpLLQ_WX0gm .

## 3 Download Checkpoints
We use the PyTorch checkpoints from https://huggingface.co/transformers/. We implement a training framework to save the GPU memory and accelerate optimization steps. Therefore, you should firstly convert the `pytorch_model.bin` file to our checkpoint format by the script `scripts/convert_ckpt.sh`.

```[base]
bash scripts/convert_ckpt.sh ${PATH_TO_BIN_MODEL} ${DIR_TO_SAVE_NEW_MODEL}
```

## 4 Run the Code
We take BoolQ dataset as an example. First, set the `${WORKING_DIR}` to the path of this directory. Then, set the `${CKPT_PATH}` to the directory that store the converted checkpoint and set the `${DATA_PATH}` to the directory that stores the datasets.

### Full Model Fine-tuning
```[bash]
bash scripts/full_model_xxl/boolq/finetune_t5_boolq_few_shot.sh
```

### Vanilla PT
```[bash]
bash scripts/prompt/boolq/finetune_t5_boolq_few_shot.sh
```

### Pre-trained PT
```[bash]
bash scripts/prompt/boolq/finetune_t5_boolq_few_shot_from_pretrain.sh
```

### Unified Pre-traned PT
```[bash]
bash scripts/prompt/boolq/finetune_t5_boolq_few_shot_from_pretrain_uni.sh
```
