/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.morph;

import java.util.ArrayList;
import java.util.List;
import simplenlg.features.Case;
import simplenlg.features.Gender;
import simplenlg.features.NumberAgr;
import simplenlg.features.WordMorph;
import simplenlg.lexicon.lexicalitems.Word;
import simplenlg.lexicon.morph.InflectionPattern;

public class InflectionPattern<T extends Word> {
    String[] suffixMasc = new String[]{"", "", "", ""};
    String[] suffixFem = new String[]{"", "", "", ""};
    String[] suffixNeut = new String[]{"", "", "", ""};
    String[] suffixPlur = new String[]{"", "", "", ""};
    List<WordMorph> features = new ArrayList<WordMorph>();

    public InflectionPattern() {
    }

    public InflectionPattern(String[] suffixMasc, String[] suffixFem, String[] suffixNeut, String[] suffixPlur) {
        this();
        this.suffixMasc = suffixMasc;
        this.suffixFem = suffixFem;
        this.suffixNeut = suffixNeut;
        this.suffixPlur = suffixPlur;
    }

    public InflectionPattern(String[] suffixMasc, String[] suffixFem, String[] suffixNeut, String[] suffixPlur, WordMorph ... feats) {
        this(suffixMasc, suffixFem, suffixNeut, suffixPlur);
        for (WordMorph f : feats) {
            this.features.add(f);
        }
    }

    public InflectionPattern(String[] suffixSg, String[] suffixPl, WordMorph ... feats) {
        this(suffixSg, suffixSg, suffixSg, suffixPl, feats);
    }

    public InflectionPattern(String[] suffixList, WordMorph ... feats) {
        this(suffixList, suffixList, suffixList, suffixList, feats);
    }

    public String apply(String stem, Case c, NumberAgr n, Gender g) {
        String suffix = this.getSuffix(c, n, g);
        if (this.features.contains(WordMorph.FULL_FORMS)) {
            return suffix;
        }
        if (this.features.contains(WordMorph.STEM_E_ELISION) && !suffix.equals("")) {
            stem = InflectionPattern.elideFinalE(stem);
        }
        return stem + suffix;
    }

    private String getSuffix(Case c, NumberAgr n, Gender g) {
        String[] suffixList;
        if (c == null) {
            c = Case.NOMINATIVE;
        }
        if (n == null) {
            n = NumberAgr.SINGULAR;
        }
        if (g == null) {
            g = Gender.MASCULINE;
        }
        if (n == NumberAgr.PLURAL) {
            suffixList = this.suffixPlur;
        } else {
            switch (1.$SwitchMap$simplenlg$features$Gender[g.ordinal()]) {
                case 1: {
                    suffixList = this.suffixMasc;
                    break;
                }
                case 2: {
                    suffixList = this.suffixFem;
                    break;
                }
                default: {
                    suffixList = this.suffixNeut;
                }
            }
        }
        switch (1.$SwitchMap$simplenlg$features$Case[c.ordinal()]) {
            default: {
                return suffixList[0];
            }
            case 2: {
                return suffixList[1];
            }
            case 3: {
                return suffixList[2];
            }
            case 4: 
        }
        return suffixList[3];
    }

    private static final String elideFinalE(String base) {
        int i = base.lastIndexOf("e");
        if (i == -1) {
            return base;
        }
        return base.substring(0, i) + base.substring(i + 1);
    }
}

