/*
 * Decompiled with CFR 0.152.
 */
package simplenlg.lexicon.lexicalitems;

import simplenlg.exception.LexiconException;
import simplenlg.features.Agreement;
import simplenlg.features.Case;
import simplenlg.features.Category;
import simplenlg.features.Gender;
import simplenlg.features.NumberAgr;
import simplenlg.lexicon.lexicalitems.Adjective;
import simplenlg.lexicon.lexicalitems.Constants;
import simplenlg.lexicon.lexicalitems.ContentWord;
import simplenlg.lexicon.lexicalitems.Noun;

public class Noun
extends ContentWord {
    Gender gender;
    NumberAgr number;
    Case cs;
    String accSg;
    String genSg;
    String datSg;
    String nomPl;
    String accPl;
    String genPl;
    String datPl;
    boolean adjectiveInflection;
    Adjective baseAdjective;
    String pluralForm;
    Agreement agreement;
    Boolean regularInflection;

    public Noun(String baseform) {
        super(baseform);
        this.category = Category.NOUN;
        this.gender = Gender.NEUTER;
        this.number = NumberAgr.SINGULAR;
        this.cs = Case.NOMINATIVE;
        this.agreement = null;
        this.regularInflection = true;
        this.adjectiveInflection = false;
        this.baseAdjective = null;
        this.generateSingularSuffixes("s");
        this.generatePluralSuffixes("");
    }

    public Noun(String baseform, Gender g) {
        this(baseform);
        this.gender = g;
        this.generateSingularSuffixes("s");
    }

    public Noun(String baseform, Gender g, String genSg, String nomPl) {
        this(baseform, g);
        this.generateSingularSuffixes(genSg);
        this.generatePluralSuffixes(nomPl);
    }

    public Noun(String baseform, String gender, String genSg, String nomPl) {
        this(baseform, Gender.NEUTER, genSg, nomPl);
        if (gender.equals("die")) {
            this.gender = Gender.FEMININE;
            this.generateSingularSuffixes(genSg);
        } else if (gender.equals("der")) {
            this.gender = Gender.MASCULINE;
            this.generateSingularSuffixes(genSg);
        }
    }

    public Noun(String baseform, Gender g, String accSg, String genSg, String datSg, String nondatPl, String datPl) {
        this(baseform, g);
        this.accSg = accSg;
        this.genSg = genSg;
        this.datSg = datSg;
        this.nomPl = nondatPl;
        this.accPl = nondatPl;
        this.genPl = nondatPl;
        this.datPl = datPl;
        this.regularInflection = false;
    }

    public Noun(String baseform, String gender, String accSg, String genSg, String datSg, String nondatPl, String datPl) {
        this(baseform, Gender.NEUTER, accSg, genSg, datSg, nondatPl, datPl);
        this.gender = Constants.detGender(gender);
    }

    public Noun(String id, String baseform) {
        this(baseform);
        this.setID(id);
    }

    public Noun(String id, String baseform, String citationform) {
        this(id, baseform);
        this.setCitationForm(citationform);
    }

    public String getSuffix(Case cas, NumberAgr num) {
        boolean plural = num == NumberAgr.PLURAL;
        switch (1.$SwitchMap$simplenlg$features$Case[cas.ordinal()]) {
            case 1: {
                return plural ? this.accPl : this.accSg;
            }
            case 2: {
                return plural ? this.genPl : this.genSg;
            }
            case 3: {
                return plural ? this.datPl : this.datSg;
            }
        }
        return plural ? this.nomPl : this.baseForm;
    }

    public String getForm(Case cas, NumberAgr num) {
        return this.createFromBaseForm(this.getSuffix(cas, num));
    }

    public NumberAgr getNumber() {
        return this.number;
    }

    public void setNumber(NumberAgr number) {
        this.number = number;
    }

    public Case getCase() {
        return this.cs;
    }

    public void setCase(Case cs) {
        this.cs = cs;
    }

    public Gender getGender() {
        return this.gender;
    }

    public void setGender(Gender gen) {
        this.gender = gen;
    }

    public Agreement getAgreement() {
        return this.agreement;
    }

    public void setAgreement(Agreement agr) {
        if (!agr.appliesTo(this.category)) {
            throw new LexiconException(agr + " cannot be applied to category NOUN");
        }
        this.agreement = agr;
    }

    public boolean isAdjectiveInflection() {
        return this.adjectiveInflection;
    }

    public void setAdjectiveInflection(boolean adjectiveInflection) {
        this.adjectiveInflection = adjectiveInflection;
        this.baseAdjective = adjectiveInflection ? new Adjective(this.baseForm) : null;
    }

    public Adjective getBaseAdjective() {
        return this.baseAdjective;
    }

    public void setBaseAdjective(Adjective baseAdjective) {
        this.adjectiveInflection = baseAdjective != null;
        this.baseAdjective = baseAdjective;
    }

    public boolean isCountNoun() {
        return this.agreement == Agreement.COUNT;
    }

    public boolean isMassNoun() {
        return this.agreement == Agreement.MASS;
    }

    public boolean isGroupNoun() {
        return this.agreement == Agreement.GROUP;
    }

    public boolean isFixedPluralNoun() {
        return this.agreement == Agreement.FIXED_PLUR;
    }

    public boolean isFixedSingularNoun() {
        return this.agreement == Agreement.FIXED_SING;
    }

    @Override
    public boolean isRegular() {
        return this.regularInflection;
    }

    private void generateSingularSuffixes(String genSg) {
        this.genSg = genSg;
        this.accSg = this.gender.equals(Gender.MASCULINE) && genSg.matches(".*n") ? this.genSg : "";
        this.datSg = genSg.endsWith("n") ? this.genSg : (genSg.endsWith("ns") ? this.genSg.substring(0, genSg.length() - 1) : "");
    }

    private void generatePluralSuffixes(String nomPl) {
        this.nomPl = nomPl;
        this.accPl = nomPl;
        this.genPl = nomPl;
        this.datPl = this.makeDativePluralSuffix(nomPl);
    }

    private String createFromBaseForm(String suffix) {
        if (suffix.isEmpty()) {
            return this.baseForm;
        }
        if (Character.isUpperCase(suffix.charAt(0))) {
            return suffix;
        }
        return this.baseForm + suffix;
    }

    private String makeDativePluralSuffix(String plural) {
        if (plural.isEmpty() && this.baseForm.matches(".*[ainsxz]$")) {
            return plural;
        }
        if (plural.matches(".*[ainsxz]$")) {
            return plural;
        }
        return plural + "n";
    }
}

