-- This module will transliterate Bulgarian language text per WT:BG TR.
-- Language code: bul
local export = {}
 
local tt = {
	["А"]='A', ["а"]='a', ["Б"]='B', ["б"]='b', ["В"]='V', ["в"]='v', ["Г"]='G', ["г"]='g', ["Д"]='D', ["д"]='d', 
	["Е"]='E', ["е"]='e', ["Ж"]='J', ["ж"]='j', ["З"]='Z', ["з"]='z', ["И"]='I', ["и"]='i', ["Й"]='I', ["й"]='i', 
	["К"]='K', ["к"]='k', ["Л"]='L', ["л"]='l', ["М"]='M', ["м"]='m', ["Н"]='N', ["н"]='n', ["О"]='O', ["о"]='o', 
	["П"]='P', ["п"]='p', ["Р"]='R', ["р"]='r', ["С"]='S', ["с"]='s', ["Т"]='T', ["т"]='t', ["У"]='U', ["у"]='u', 
	["Ф"]='F', ["ф"]='f', ["Х"]='H', ["х"]='h', ["Ц"]='C', ["ц"]='c', ["Ч"]='Č', ["ч"]='č', ["Ш"]='Š', ["ш"]='š', 
	["Щ"]='Št', ["щ"]='št', ["Ъ"]='Ǎ', ["ъ"]='ǎ', ["Ю"]='Ju', ["ю"]='ju', ["Я"]='Ja', ["я"]='ja',
	["ѝ"]='ì',

	-- Pre-reform
	["Ѫ"]='Ǫ', ["ѫ"]='ǫ', ["Ѣ"]='Ě', ["ѣ"]='ě', ["Ь"]='ʹ', ["ь"]='ʹ',
};

function export.tr(text, lang, sc)
	text = mw.ustring.gsub(text, '(%w)[Ъъ]$', '%1')
	text = mw.ustring.gsub(text, '(%w)[Ъъ]%f[%c%p%s]', '%1')
	text = mw.ustring.gsub(text, '[Ьь]%f[Оо]', { ["Ь"]='J', ["ь"]='j' })
	text = mw.ustring.gsub(text, '.', tt)
	return text
end

return export