#ifndef BASELINE_RUN_H
#define BASELINE_RUN_H

#include "common/transducer/run_base.h"

namespace baseline {

class Run : public RunBase {
public:
    void train(const std::string& input_file,
               const std::string& rules_file,
               const std::string& feature_input,
               const std::string& feature_output) const override;

    void transduce(const std::string& input_file,
                   const std::string& output_file,
                   const std::string& rules_file,
                   const std::string& feature_file,
                   bool with_detail) const override;

    void goldTest(const std::string& input_file,
                  const std::string& rules_file,
                  const std::string& feature_input) const override;

    void initialize() const override;
};
}

#endif /* BASELINE_RUN_H */

// Local Variables:
// mode: c++
// End:
