#include "model.ih"

void Model::test(istream *in, ostream *out, size_t skip, size_t numTest)
{
    d_config->recall = vector<size_t>(1500, 0);
    if (!d_config->goldTreebank.empty())
        d_treebank.open(d_config->goldTreebank);

    for (size_t beg = 0; beg != skip; ++beg)
        ((d_config->parse) ? readRaw(in): readGold(in));

    d_forest = 0;
    vector<string> emptyVec;
    d_forest = new ForestProbability;
    d_forest->initCpp("gold", MEM_DOUBLE, d_config->header, // depvar, memMode, inputFile
            0, d_config->featsPath, 500, //mtry, outprefix, numTrees
            &cerr, d_config->seed, d_config->numThreads, // verboseOut, seed, nthreads, 
            d_config->regrPath, DEFAULT_IMPORTANCE_MODE, //forestPath, importance measure
            0, "", emptyVec, //targetpartitionsize?, splitweightsfile, alwayssplitvars
            "", true, emptyVec, // statusvarname, replace, catvars
            false, DEFAULT_SPLITRULE, "", //savemem, splitrule, caseweights
            false, 1, DEFAULT_ALPHA, DEFAULT_MINPROP, //predall, fraction, minprob
            false, DEFAULT_PREDICTIONTYPE); // holdout, predictiontype

    size_t sents  = 0;
    for (;(numTest == 0 || sents != numTest) && 
            ((d_config->parse)? readRaw(in) : readGold(in)); ++sents)
    {
        d_cands.clear();
        d_featVals.clear();
        d_results.clear();
        for (d_wordIdx = 0; d_wordIdx < d_origs.size(); ++d_wordIdx)
            gen();
        rank();
        eval();
    }
    cerr << "Tested on " << sents << " sents \n";
    if (d_config->parse)
        d_evalb.printF1(out);
    else
        writeEval(out);
    d_parser.closeParser();
}

