#ifndef _PPL_H
#define _PPL_H
#include <unordered_map>
#include <unordered_set>
#include "include/ngram.h"

class Pos_Pos_Label {
protected:
	std::unordered_set<TriGram<int> > m_pplset;

public:

	void init() { m_pplset.clear(); }

	bool find(TriGram<int> Token)
	{
		if (m_pplset.find(Token) != m_pplset.end() )
			return true;
		else return false;
	}

	void insert(TriGram<int> Token)
	{
		m_pplset.insert(Token);
	}

	std::unordered_set<TriGram<int> > getmap() {
		return m_pplset;
	}

	friend std::istream & operator>>(std::istream & is, Pos_Pos_Label & token) {
		int count;
		is >> count;
		TriGram<int> t;
		while (count--) {
			is >> t;
			token.insert(t);
		}
		return is;
	}

	friend std::ostream & operator<<(std::ostream & os, Pos_Pos_Label & token) {
		os << token.getmap().size() << std::endl;
		for (auto t : token.getmap()) {
			os << t << std::endl;
		}
		return os;
	}
};

#endif
