#include "graphcjj1L_state.h"

namespace graphcjj1L {
	StateItem::StateItem() = default;
	StateItem::~StateItem() = default;

	void StateItem::init(const int & l, const int & r) {
		type = 0;
		left = l;
		right = r;
		l2r_label.reset();
		l2r_nolabel.reset();
	}

	void StateItem::print() {
		std::cout << "[" << left << "," << right << "]" << std::endl;
		std::cout << "type is: ";
		switch (type) {
		case L2R_LABEL:
			std::cout << "L2R_COMP" << std::endl;
			std::cout << "split: " << l2r_label.getSplit() << " score: " << l2r_label.getScore() << std::endl;
			break;
		case L2R_NOLABEL:
			std::cout << "R2L_COMP" << std::endl;
			std::cout << "split: " << l2r_nolabel.getSplit() << " score: " << l2r_nolabel.getScore() << std::endl;
			break;
		default:
			std::cout << "ZERO" << std::endl;
			std::cout << "L2R_LABEL" << std::endl;
			std::cout << "split: " << l2r_label.getSplit() << " score: " << l2r_label.getScore() << std::endl;
			std::cout << "L2R_NOLABEL" << std::endl;
			std::cout << "split: " << l2r_nolabel.getSplit() << " score: " << l2r_nolabel.getScore() << std::endl;
	
			break;
		}
	}
}