/*
 * Decompiled with CFR 0.152.
 */
package fig.servlet;

import fig.basic.IOUtils;
import fig.basic.StrUtils;
import fig.basic.Utils;
import fig.servlet.ExecViewDB;
import fig.servlet.FieldListMap;
import fig.servlet.FieldSpecView;
import fig.servlet.Item;
import fig.servlet.MyException;
import fig.servlet.MyExceptions;
import fig.servlet.UpdateQueue;
import fig.servlet.UpdateSpec;
import fig.servlet.WebState;
import java.io.File;

public class DomainItem
extends Item {
    public FieldSpecView fieldSpecView;
    public ExecViewDB execViewDB;
    private String domainDir;

    public DomainItem(Item parent, String name, String sourcePath) {
        super(parent, name, sourcePath);
        IOUtils.createNewFileIfNotExistsEasy(sourcePath);
    }

    @Override
    protected boolean isHidden() {
        return Boolean.parseBoolean((String)this.metadataMap.get("isHidden"));
    }

    @Override
    public FieldListMap getItemsFields() {
        return countDescriptionFields;
    }

    @Override
    protected void loadFromDisk() throws MyException {
        super.loadFromDisk();
        String newDomainDir = (String)this.metadataMap.get("domainDir");
        if (!Utils.equals(newDomainDir, this.domainDir) && newDomainDir != null && new File(newDomainDir).isDirectory()) {
            this.domainDir = newDomainDir;
            WebState.logs("New domainDir: " + this.domainDir);
            this.fieldSpecView = null;
            this.execViewDB = null;
        }
        if (!StrUtils.isEmpty(this.domainDir)) {
            if (this.fieldSpecView == null) {
                this.fieldSpecView = new FieldSpecView(this, "fieldSpecs", new File(this.domainDir, "fieldSpecs").toString());
            }
            if (this.execViewDB == null) {
                this.execViewDB = new ExecViewDB(this, "execs", new File(this.domainDir, "execs").toString(), new File(this.domainDir, "views").toString());
            }
        }
        if (this.fieldSpecView != null) {
            this.addItem(this.fieldSpecView);
        }
        if (this.execViewDB != null) {
            this.addItem(this.execViewDB);
        }
    }

    @Override
    public FieldListMap getMetadataFields() {
        FieldListMap fields = new FieldListMap();
        fields.add(mutableDescriptionField);
        fields.add((String)"domainDir", (String)"Domain directory").mutable = true;
        return fields;
    }

    @Override
    public void update(UpdateSpec spec, UpdateQueue.Priority priority) throws MyException {
        super.update(spec, priority);
        if (this.fieldSpecView != null) {
            spec.queue.enqueue(this.fieldSpecView, priority);
        }
        this.updateChildren(spec, priority.next());
    }

    @Override
    protected Item handleToItem(String handle) throws MyException {
        return null;
    }

    @Override
    protected String itemToHandle(Item item) throws MyException {
        return null;
    }

    @Override
    protected boolean isView() {
        return true;
    }

    @Override
    protected Item newItem(String name) throws MyException {
        throw MyExceptions.unsupported;
    }
}

