/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.io;

import edu.pku.coli.io.FileRecursor;
import java.io.File;
import java.io.FileFilter;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class TreebankRecursor
extends FileRecursor {
    public int index(String filename) {
        return ((TreebankFileter)this._filter).index(filename);
    }

    public TreebankRecursor(String filename, String type, String extension) {
        super(filename, new TreebankFileter(type, extension));
    }

    public TreebankRecursor(String filename) {
        this(filename, null, null);
    }

    public static void main(String[] args) {
        TreebankRecursor cursor = new TreebankRecursor("E:/data/ccg_ch/test", "chtb", null);
        for (File f : cursor) {
            System.out.println(f);
        }
    }

    static class TreebankFileter
    implements FileFilter {
        String _type = "wsj";
        String _extension = "";

        public TreebankFileter(String type, String extension) {
            if (type != null) {
                this._type = type;
            }
            if (extension != null) {
                this._extension = extension;
            }
        }

        @Override
        public boolean accept(File arg0) {
            StringBuffer sb = new StringBuffer(this._type);
            sb.append("_([0-9]{4})\\.");
            sb.append(this._extension);
            Pattern px = Pattern.compile(sb.toString());
            Matcher mx = px.matcher(arg0.toString());
            return mx.find();
        }

        public int index(String filename) {
            Pattern px = Pattern.compile("wsj_([0-9]{4})\\.");
            Matcher mx = px.matcher(filename);
            if (mx.find()) {
                return Integer.parseInt(mx.group(1));
            }
            return -1;
        }
    }
}

