/*
 * Decompiled with CFR 0.152.
 */
package edu.pku.coli.io;

import edu.pku.coli.io.CoNLLReader;
import fig.basic.IOUtils;
import fig.basic.LogInfo;
import java.io.File;
import java.io.PrintWriter;
import java.util.ArrayList;

public class CCGPARGReader
extends CoNLLReader {
    public CCGPARGReader() {
    }

    public CCGPARGReader(String file) {
        super(file);
    }

    public CCGPARGReader(File file) {
        super(file);
    }

    @Override
    public String[][] readNext() throws Exception {
        int numOfToken;
        ArrayList<String[]> sent;
        block6: {
            sent = new ArrayList<String[]>();
            ++this.lineNumber;
            String line = this.readXMLStartTag();
            if (line != null) {
                sent.add(line.trim().split("[ \t]+"));
            }
            while ((line = this.inputReader.readLine()) != null) {
                ++this.lineNumber;
                if (this.isXMLEndTag(line = line.trim())) break;
                String[] toks = line.split("[ \t]+");
                sent.add(toks);
            }
            numOfToken = sent.size();
            if (numOfToken != 0) break block6;
            this.inputReader.close();
            return null;
        }
        try {
            String[][] rslt = new String[numOfToken][];
            int col = 0;
            while (col < numOfToken) {
                rslt[col] = (String[])sent.get(col);
                ++col;
            }
            return rslt;
        }
        catch (Exception e) {
            LogInfo.logs("\n!!! Error in input file at line : %d %s", this.lineNumber, e);
            e.printStackTrace();
            throw new Exception();
        }
    }

    public String[] readStanfordNext() throws Exception {
        try {
            String line;
            ArrayList<String> sent = new ArrayList<String>();
            while ((line = this.inputReader.readLine()) != null) {
                ++this.lineNumber;
                if ((line = line.trim()).isEmpty()) break;
                sent.add(line);
            }
            if (!sent.isEmpty()) {
                return sent.toArray(new String[0]);
            }
            return null;
        }
        catch (Exception e) {
            LogInfo.logs("\n!!! Error in input file at line : %d %s", this.lineNumber, e);
            e.printStackTrace();
            throw new Exception();
        }
    }

    public String[][] readSDPNext() throws Exception {
        try {
            String line;
            ArrayList<String[]> sent = new ArrayList<String[]>();
            while ((line = this.inputReader.readLine()) != null) {
                ++this.lineNumber;
                if ((line = line.trim()).isEmpty()) break;
                if (line.equals("#SDP 2015")) continue;
                sent.add(line.split("\\s+"));
            }
            if (!sent.isEmpty()) {
                return (String[][])sent.toArray((T[])new String[0][]);
            }
            return null;
        }
        catch (Exception e) {
            LogInfo.logs("\n!!! Error in input file at line : %d %s", this.lineNumber, e);
            e.printStackTrace();
            throw new Exception();
        }
    }

    private String readXMLStartTag() throws Exception {
        String line = this.inputReader.readLine();
        if (line != null && !line.startsWith("<s")) {
            throw new Exception("XML start-tag missing.");
        }
        return line;
    }

    private boolean isXMLEndTag(String line) {
        return "<\\s>".equals(line);
    }

    public static void main(String[] args) {
        File chPARGdir = new File(args[0]);
        CCGPARGReader.processRecurion(chPARGdir);
    }

    private static void processRecurion(File dir) {
        if (dir.isFile()) {
            String filePath = dir.getPath();
            String newFilePath = filePath.replace("PARG", "PARG_index_fixed");
            System.out.println(newFilePath);
            CCGPARGReader reader = new CCGPARGReader(filePath);
            PrintWriter pw = IOUtils.openOutEasy(newFilePath);
            try {
                String[][] parg = reader.readNext();
                while (parg != null) {
                    int sentLen = Integer.parseInt(parg[0][parg[0].length - 1]);
                    parg[0][parg[0].length - 1] = "" + --sentLen;
                    String[][] stringArray = parg;
                    int n = parg.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String[] line = stringArray[n2];
                        int i = 0;
                        while (i < line.length - 1) {
                            pw.print(String.valueOf(line[i]) + " ");
                            ++i;
                        }
                        pw.println(line[line.length - 1]);
                        ++n2;
                    }
                    pw.println("<\\s>");
                    parg = reader.readNext();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            pw.close();
        } else {
            File[] files;
            String filePath = dir.getPath();
            String newFilePath = filePath.replace("PARG", "PARG_sent_len_fixed");
            File newDir = new File(newFilePath);
            newDir.mkdir();
            File[] fileArray = files = dir.listFiles();
            int n = files.length;
            int n3 = 0;
            while (n3 < n) {
                File f = fileArray[n3];
                CCGPARGReader.processRecurion(f);
                ++n3;
            }
        }
    }
}

