/*
 * Decompiled with CFR 0.152.
 */
package LinguaView;

import LinguaView.UIutils.ButtonPanel;
import LinguaView.UIutils.FileLocPanel;
import LinguaView.UIutils.TextComponentLayout;
import LinguaView.syntax.CCGNode;
import LinguaView.syntax.CCGTerminalNode;
import LinguaView.syntax.CCGTreePanel;
import LinguaView.syntax.ConstTree;
import LinguaView.syntax.ConstTreePanel;
import LinguaView.syntax.DepTree;
import LinguaView.syntax.DepTreePanel;
import LinguaView.syntax.LFGStructPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontFormatException;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.undo.UndoManager;
import javax.swing.undo.UndoableEdit;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import net.sf.epsgraphics.ColorMode;
import net.sf.epsgraphics.EpsGraphics;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;
import org.xml.sax.InputSource;

class TabbedPaneFrame
extends JFrame {
    private JTabbedPane tabbedPane = new JTabbedPane();
    private String filename;
    ConstTreePanel constcomponent = new ConstTreePanel();
    DepTreePanel depcomponent = new DepTreePanel();
    DepTreePanel deepdepcomponent = new DepTreePanel();
    CCGTreePanel CCGcomponent = new CCGTreePanel();
    LFGStructPanel LFGcomponent = new LFGStructPanel();
    JTextPane Textcomponent = new JTextPane();
    UndoManager undoManager = new UndoManager();
    JPanel TextNoWrapPanel = new JPanel();
    final JScrollPane constScrollPane = new JScrollPane(this.constcomponent);
    final JScrollPane depScrollPane = new JScrollPane(this.depcomponent);
    final JScrollPane deepdepScrollPane = new JScrollPane(this.deepdepcomponent);
    final JScrollPane CCGScrollPane = new JScrollPane(this.CCGcomponent);
    final JScrollPane LFGScrollPane = new JScrollPane(this.LFGcomponent);
    final JScrollPane TextScrollPane = new JScrollPane(this.TextNoWrapPanel);
    ConstTree defaultConstTreebank;
    DepTree defaultDepTreebank;
    DepTree defaultDeepdepTreebank;
    CCGNode defaultCCGTreebank;
    Element defaultLFGStructbank;
    JMenuBar menuBar = new JMenuBar();
    JPopupMenu popupMenu = new JPopupMenu();
    JToolBar bar = new JToolBar();
    JButton newButton = new JButton();
    JButton importButton = new JButton();
    JButton exportButton = new JButton();
    JButton zoomInButton = new JButton();
    JButton zoomOutButton = new JButton();
    JButton prevButton = new JButton();
    JButton nextButton = new JButton();
    JButton jumpButton = new JButton();
    JButton saveTextButton = new JButton();
    StatusBar statusBar = new StatusBar();

    public TabbedPaneFrame() {
        this.setTitle("LinguaView");
        Toolkit kit = Toolkit.getDefaultToolkit();
        Dimension screenSize = kit.getScreenSize();
        int screenHeight = screenSize.height;
        int screenWidth = screenSize.width;
        this.setSize(screenWidth / 2, screenHeight / 2);
        this.setMinimumSize(new Dimension(screenWidth / 2, screenHeight / 2));
        this.setLayout(new BorderLayout());
        try {
            GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
            Font Lucida = Font.createFont(0, TabbedPaneFrame.class.getResourceAsStream("UIsrc" + File.separator + "LUCON.ttf"));
            Font Ubuntu = Font.createFont(0, TabbedPaneFrame.class.getResourceAsStream("UIsrc" + File.separator + "Ubuntu-R.ttf"));
            ge.registerFont(Lucida);
            ge.registerFont(Ubuntu);
            Font font = new Font(Ubuntu.getFontName(), 0, 14);
            Font codeFont = new Font(Lucida.getFontName(), 0, 14);
            UIManager.put("TabbedPane.font", font);
            UIManager.put("Menu.font", font);
            UIManager.put("MenuItem.font", font);
            UIManager.put("CheckBoxMenuItem.font", font);
            UIManager.put("Label.font", font);
            SwingUtilities.updateComponentTreeUI(this.tabbedPane);
            SwingUtilities.updateComponentTreeUI(this.menuBar);
            SwingUtilities.updateComponentTreeUI(this.statusBar);
            this.Textcomponent.setFont(codeFont);
        }
        catch (FontFormatException e1) {
            e1.printStackTrace();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        this.TextNoWrapPanel.setLayout(new BorderLayout());
        this.TextNoWrapPanel.setBackground(Color.white);
        this.TextNoWrapPanel.add(this.Textcomponent);
        this.setJMenuBar(this.menuBar);
        JMenu FileMenu = new JMenu("File");
        JMenuItem newItem = new JMenuItem("New XML File...");
        FileMenu.add(newItem);
        FileMenu.addSeparator();
        JMenuItem importItem = new JMenuItem("Import From File...");
        FileMenu.add(importItem);
        JMenuItem exportItem = new JMenuItem("Export To File...");
        FileMenu.add(exportItem);
        FileMenu.addSeparator();
        JMenuItem saveItem = new JMenuItem("Save XML File");
        FileMenu.add(saveItem);
        JMenuItem saveAsItem = new JMenuItem("Save XML File As...");
        FileMenu.add(saveAsItem);
        FileMenu.addSeparator();
        JMenuItem exitItem = new JMenuItem("Exit");
        FileMenu.add(exitItem);
        this.menuBar.add(FileMenu);
        JMenu EditMenu = new JMenu("Edit");
        JMenuItem cutItem = new JMenuItem("Cut");
        EditMenu.add(cutItem);
        JMenuItem copyItem = new JMenuItem("Copy");
        EditMenu.add(copyItem);
        JMenuItem pasteItem = new JMenuItem("Paste");
        EditMenu.add(pasteItem);
        EditMenu.addSeparator();
        JMenuItem selectAllItem = new JMenuItem("Select All");
        EditMenu.add(selectAllItem);
        EditMenu.addSeparator();
        JMenuItem undoItem = new JMenuItem("Undo");
        EditMenu.add(undoItem);
        JMenuItem redoItem = new JMenuItem("Redo");
        EditMenu.add(redoItem);
        this.menuBar.add(EditMenu);
        JMenu ToolMenu = new JMenu("Tools");
        JCheckBoxMenuItem NewFileToolItem = new JCheckBoxMenuItem("New File Button", true);
        ToolMenu.add(NewFileToolItem);
        JCheckBoxMenuItem FileToolkitItem = new JCheckBoxMenuItem("Import/Export Button", true);
        ToolMenu.add(FileToolkitItem);
        JCheckBoxMenuItem ZoomToolkitItem = new JCheckBoxMenuItem("Zoom in/Zoom Out Button", true);
        ToolMenu.add(ZoomToolkitItem);
        JCheckBoxMenuItem SentToolkitItem = new JCheckBoxMenuItem("Prev/Next Button", true);
        ToolMenu.add(SentToolkitItem);
        JCheckBoxMenuItem JumpToolItem = new JCheckBoxMenuItem("Jump Button", true);
        ToolMenu.add(JumpToolItem);
        JCheckBoxMenuItem SaveTextToolItem = new JCheckBoxMenuItem("Save XML Button", true);
        ToolMenu.add(SaveTextToolItem);
        ToolMenu.addSeparator();
        JMenuItem ToolbarItem = new JMenuItem("Show/Hide Toolbar");
        ToolMenu.add(ToolbarItem);
        this.menuBar.add(ToolMenu);
        JMenu LayoutMenu = new JMenu("Layout");
        JMenuItem zoomInItem = new JMenuItem("Zoom In");
        LayoutMenu.add(zoomInItem);
        JMenuItem zoomOutItem = new JMenuItem("Zoom Out");
        LayoutMenu.add(zoomOutItem);
        LayoutMenu.addSeparator();
        JMenuItem prevSentItem = new JMenuItem("Previous Sentence");
        LayoutMenu.add(prevSentItem);
        JMenuItem nextSentItem = new JMenuItem("Next Sentence");
        LayoutMenu.add(nextSentItem);
        JMenuItem jumpSentItem = new JMenuItem("Jump To Sentence...");
        LayoutMenu.add(jumpSentItem);
        LayoutMenu.addSeparator();
        JMenuItem prevTabItem = new JMenuItem("Previous Tab");
        LayoutMenu.add(prevTabItem);
        JMenuItem nextTabItem = new JMenuItem("Next Tab");
        LayoutMenu.add(nextTabItem);
        LayoutMenu.addSeparator();
        JMenuItem skewItem = new JMenuItem("Straight/Skew Constituent Lines");
        LayoutMenu.add(skewItem);
        JMenuItem laItem = new JMenuItem("Show/Hide latent annotations");
        LayoutMenu.add(laItem);
        JMenuItem colorItem = new JMenuItem("Color/BW LFG Correspondence Lines");
        LayoutMenu.add(colorItem);
        JMenuItem showItem = new JMenuItem("Show/Hide LFG Correspondence Lines");
        LayoutMenu.add(showItem);
        this.menuBar.add(LayoutMenu);
        JMenu HelpMenu = new JMenu("Help");
        JMenuItem formatItem = new JMenuItem("Input Format");
        HelpMenu.add(formatItem);
        JMenuItem aboutItem = new JMenuItem("About");
        HelpMenu.add(aboutItem);
        this.menuBar.add(HelpMenu);
        JMenuItem PopupCutItem = new JMenuItem("Cut");
        this.popupMenu.add(PopupCutItem);
        JMenuItem PopupCopyItem = new JMenuItem("Copy");
        this.popupMenu.add(PopupCopyItem);
        JMenuItem PopupPasteItem = new JMenuItem("Paste");
        this.popupMenu.add(PopupPasteItem);
        JMenuItem PopupSelAllItem = new JMenuItem("Select All");
        this.popupMenu.add(PopupSelAllItem);
        this.Textcomponent.setComponentPopupMenu(this.popupMenu);
        newItem.addActionListener(new ImportItemListener());
        importItem.addActionListener(new ImportItemListener());
        exportItem.addActionListener(new ExportItemListener());
        saveItem.addActionListener(new SaveTextListener());
        saveAsItem.addActionListener(new SaveTextAsListener());
        newItem.setAccelerator(KeyStroke.getKeyStroke(78, 2));
        importItem.setAccelerator(KeyStroke.getKeyStroke(79, 2));
        exportItem.setAccelerator(KeyStroke.getKeyStroke(80, 2));
        saveItem.setAccelerator(KeyStroke.getKeyStroke(83, 2));
        saveAsItem.setAccelerator(KeyStroke.getKeyStroke(83, 3));
        exitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                System.exit(0);
            }
        });
        cutItem.addActionListener(new CutItemListener());
        copyItem.addActionListener(new CopyItemListener());
        pasteItem.addActionListener(new PasteItemListener());
        selectAllItem.addActionListener(new SelAllItemListener());
        undoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (TabbedPaneFrame.this.undoManager.canUndo()) {
                    TabbedPaneFrame.this.undoManager.undo();
                }
            }
        });
        redoItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (TabbedPaneFrame.this.undoManager.canRedo()) {
                    TabbedPaneFrame.this.undoManager.redo();
                }
            }
        });
        cutItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        copyItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        pasteItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        selectAllItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        undoItem.setAccelerator(KeyStroke.getKeyStroke(90, 2));
        redoItem.setAccelerator(KeyStroke.getKeyStroke(90, 3));
        NewFileToolItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TabbedPaneFrame.this.newButton.setVisible(!TabbedPaneFrame.this.newButton.isVisible());
            }
        });
        FileToolkitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TabbedPaneFrame.this.importButton.setVisible(!TabbedPaneFrame.this.importButton.isVisible());
                TabbedPaneFrame.this.exportButton.setVisible(!TabbedPaneFrame.this.exportButton.isVisible());
            }
        });
        ZoomToolkitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TabbedPaneFrame.this.zoomInButton.setVisible(!TabbedPaneFrame.this.zoomInButton.isVisible());
                TabbedPaneFrame.this.zoomOutButton.setVisible(!TabbedPaneFrame.this.zoomOutButton.isVisible());
            }
        });
        SentToolkitItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TabbedPaneFrame.this.prevButton.setVisible(!TabbedPaneFrame.this.prevButton.isVisible());
                TabbedPaneFrame.this.nextButton.setVisible(!TabbedPaneFrame.this.nextButton.isVisible());
            }
        });
        JumpToolItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TabbedPaneFrame.this.jumpButton.setVisible(!TabbedPaneFrame.this.jumpButton.isVisible());
            }
        });
        SaveTextToolItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TabbedPaneFrame.this.saveTextButton.setVisible(!TabbedPaneFrame.this.saveTextButton.isVisible());
            }
        });
        ToolbarItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TabbedPaneFrame.this.bar.setVisible(!TabbedPaneFrame.this.bar.isVisible());
            }
        });
        zoomInItem.addActionListener(new ZoomInListener());
        zoomOutItem.addActionListener(new ZoomOutListener());
        prevSentItem.addActionListener(new PrevSentListener());
        nextSentItem.addActionListener(new NextSentListener());
        jumpSentItem.addActionListener(new JumpSentListener());
        prevTabItem.addActionListener(new PrevTabListener());
        nextTabItem.addActionListener(new NextTabListener());
        skewItem.addActionListener(new SkewLineListener());
        laItem.addActionListener(new laListener());
        colorItem.addActionListener(new ColorLineListener());
        showItem.addActionListener(new ShowLineListener());
        zoomInItem.setAccelerator(KeyStroke.getKeyStroke(61, 2));
        zoomOutItem.setAccelerator(KeyStroke.getKeyStroke(45, 2));
        prevSentItem.setAccelerator(KeyStroke.getKeyStroke(37, 2));
        nextSentItem.setAccelerator(KeyStroke.getKeyStroke(39, 2));
        jumpSentItem.setAccelerator(KeyStroke.getKeyStroke(74, 2));
        prevTabItem.setAccelerator(KeyStroke.getKeyStroke(37, 3));
        nextTabItem.setAccelerator(KeyStroke.getKeyStroke(39, 3));
        formatItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                try {
                    String url = "https://github.com/shuoyangd/LinguaView/blob/master/Input_Format_1_x.md";
                    Desktop.getDesktop().browse(URI.create(url));
                }
                catch (IOException e) {
                    System.out.println(e.getMessage());
                }
            }
        });
        aboutItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                JOptionPane.showConfirmDialog(TabbedPaneFrame.this, "LinguaView 1.0.1 by Shuoyang Ding\nLanguage Computing & Web Mining Group, Peking University\n2013.11\ndsy100@gmail.com\n\nLinguaView is an light-weight graphical tool aiming to\naid manual construction of linguistically-deep corpuses.\nTo help make this tool better, if you find any problems or bugs,\ndo not hesitate to email me.\n\nSpecial acknowledgement to Federico Sangati,\nthe original author of the constituent viewer part.\nAnd also to Weiwei Sun and Chen Wang,\nauthors of the data structures that constitute an implementation of CCG.", "About", -1, -1);
            }
        });
        PopupCutItem.addActionListener(new CutItemListener());
        PopupCopyItem.addActionListener(new CopyItemListener());
        PopupPasteItem.addActionListener(new PasteItemListener());
        PopupSelAllItem.addActionListener(new SelAllItemListener());
        PopupCutItem.setAccelerator(KeyStroke.getKeyStroke(88, 2));
        PopupCopyItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        PopupPasteItem.setAccelerator(KeyStroke.getKeyStroke(86, 2));
        PopupSelAllItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        ImageIcon newIcon = new ImageIcon(TabbedPaneFrame.class.getResource("UIsrc" + File.separator + "new.png"));
        ImageIcon importIcon = new ImageIcon(TabbedPaneFrame.class.getResource("UIsrc" + File.separator + "import.png"));
        ImageIcon exportIcon = new ImageIcon(TabbedPaneFrame.class.getResource("UIsrc" + File.separator + "export.png"));
        ImageIcon zoomInIcon = new ImageIcon(TabbedPaneFrame.class.getResource("UIsrc" + File.separator + "zoomin.png"));
        ImageIcon zoomOutIcon = new ImageIcon(TabbedPaneFrame.class.getResource("UIsrc" + File.separator + "zoomout.png"));
        ImageIcon prevIcon = new ImageIcon(TabbedPaneFrame.class.getResource("UIsrc" + File.separator + "prev.png"));
        ImageIcon nextIcon = new ImageIcon(TabbedPaneFrame.class.getResource("UIsrc" + File.separator + "next.png"));
        ImageIcon jumpIcon = new ImageIcon(TabbedPaneFrame.class.getResource("UIsrc" + File.separator + "jump.png"));
        ImageIcon saveTextIcon = new ImageIcon(TabbedPaneFrame.class.getResource("UIsrc" + File.separator + "ok.png"));
        this.newButton.setIcon(newIcon);
        this.importButton.setIcon(importIcon);
        this.exportButton.setIcon(exportIcon);
        this.zoomInButton.setIcon(zoomInIcon);
        this.zoomOutButton.setIcon(zoomOutIcon);
        this.prevButton.setIcon(prevIcon);
        this.nextButton.setIcon(nextIcon);
        this.jumpButton.setIcon(jumpIcon);
        this.saveTextButton.setIcon(saveTextIcon);
        this.newButton.addActionListener(new ImportItemListener());
        this.importButton.addActionListener(new ImportItemListener());
        this.exportButton.addActionListener(new ExportItemListener());
        this.zoomInButton.addActionListener(new ZoomInListener());
        this.zoomOutButton.addActionListener(new ZoomOutListener());
        this.prevButton.addActionListener(new PrevSentListener());
        this.nextButton.addActionListener(new NextSentListener());
        this.jumpButton.addActionListener(new JumpSentListener());
        this.saveTextButton.addActionListener(new SaveTextListener());
        this.bar.add(this.newButton);
        this.bar.add(this.importButton);
        this.bar.add(this.exportButton);
        this.bar.add(this.zoomInButton);
        this.bar.add(this.zoomOutButton);
        this.bar.add(this.prevButton);
        this.bar.add(this.nextButton);
        this.bar.add(this.jumpButton);
        this.bar.add(this.saveTextButton);
        this.bar.setOrientation(1);
        this.add((Component)this.bar, "West");
        this.tabbedPane.addTab("Constituent Tree", null, null);
        this.tabbedPane.addTab("Dependency Tree", null, null);
        this.tabbedPane.addTab("Deep Dependency Graph", null, null);
        this.tabbedPane.addTab("Combinatorial Categorial Tree", null, null);
        this.tabbedPane.addTab("Lexical Functional Structure", null, null);
        this.tabbedPane.addTab("Text Editor", null, null);
        ArrayList<ConstTree> constTreebank = new ArrayList<ConstTree>();
        String defaultConstStr = "( (S (NP-SBJ (NP (NNP Pierre) (NNP Vinken) ) (, ,) (ADJP (NP (CD 61) (NNS years) ) (JJ old) ) (, ,) ) (VP (MD will) (VP (VB join) (NP (DT the) (NN board) ) (PP-CLR (IN as) (NP (DT a) (JJ nonexecutive) (NN director) )) (NP-TMP (NNP Nov.) (CD 29) ))) (. .) ))";
        this.defaultConstTreebank = ConstTree.ConstTreeIO.ReadConstTree(defaultConstStr);
        constTreebank.add(this.defaultConstTreebank);
        this.constcomponent.loadTreebank(constTreebank);
        this.constcomponent.init();
        this.constcomponent.setBackground(Color.WHITE);
        ArrayList<DepTree> DepTreebank = new ArrayList<DepTree>();
        this.defaultDepTreebank = new DepTree();
        this.defaultDepTreebank.loadTokens("Pierre Vinken , 61 years old , will join the board as a nonexecutive director Nov. 29 .");
        this.defaultDepTreebank.loadEdges("(0, 1, _) (1, 7, _) (2, 1, _) (3, 4, _) (4, 5, _) (5, 1, _)(6, 1, _) (7, -1, _) (8, 7, _) (9, 10, _) (10, 8, _) (11, 8, _) (12, 14, _) (13, 14, _) (14, 11, _) (15, 8, _) (16, 15, _) (17, 7, _)");
        DepTreebank.add(this.defaultDepTreebank);
        this.depcomponent.loadTreebank(DepTreebank);
        this.depcomponent.init();
        this.depcomponent.setBackground(Color.WHITE);
        ArrayList<DepTree> DeepdepTreebank = new ArrayList<DepTree>();
        this.defaultDeepdepTreebank = new DepTree();
        this.defaultDeepdepTreebank.loadTokens("Pierre Vinken , 61 years old , will join the board as a nonexecutive director Nov. 29 .");
        this.defaultDeepdepTreebank.loadEdges("(0, 1, _) (1, 7, _) (2, 1, _) (3, 4, _) (4, 5, _) (5, 1, _)(6, 1, _) (7, -1, _) (8, 7, _) (9, 10, _) (10, 8, _) (11, 8, _) (12, 14, _) (13, 14, _) (14, 11, _) (15, 8, _) (16, 15, _) (17, 7, _)");
        DeepdepTreebank.add(this.defaultDeepdepTreebank);
        this.deepdepcomponent.loadTreebank(DeepdepTreebank);
        this.deepdepcomponent.init();
        this.deepdepcomponent.setBackground(Color.WHITE);
        ArrayList<CCGNode> CCGTreebank = new ArrayList<CCGNode>();
        String defaultCCGStr = "(<T S[dcl] 0 2> (<T S[dcl] 1 2> (<T NP 0 2> (<T NP 0 2> (<T NP 0 2> (<T NP 0 1> (<T N 1 2> (<L N/N NNP NNP Pierre N_73/N_73>) (<L N NNP NNP Vinken N>) ) ) (<L , , , , ,>) ) (<T NP\\NP 0 1> (<T S[adj]\\NP 1 2> (<T NP 0 1> (<T N 1 2> (<L N/N CD CD 61 N_93/N_93>) (<L N NNS NNS years N>) ) ) (<L (S[adj]\\NP)\\NP JJ JJ old (S[adj]\\NP_83)\\NP_84>) ) ) ) (<L , , , , ,>) ) (<T S[dcl]\\NP 0 2> (<L (S[dcl]\\NP)/(S[b]\\NP) MD MD will (S[dcl]\\NP_10)/(S[b]_11\\NP_10:B)_11>) (<T S[b]\\NP 0 2> (<T S[b]\\NP 0 2> (<T (S[b]\\NP)/PP 0 2> (<L ((S[b]\\NP)/PP)/NP VB VB join ((S[b]\\NP_20)/PP_21)/NP_22>) (<T NP 1 2> (<L NP[nb]/N DT DT the NP[nb]_29/N_29>) (<L N NN NN board N>) ) ) (<T PP 0 2> (<L PP/NP IN IN as PP/NP_34>) (<T NP 1 2> (<L NP[nb]/N DT DT a NP[nb]_48/N_48>) (<T N 1 2> (<L N/N JJ JJ nonexecutive N_43/N_43>) (<L N NN NN director N>) ) ) ) ) (<T (S\\NP)\\(S\\NP) 0 2> (<L ((S\\NP)\\(S\\NP))/N[num] NNP NNP Nov. ((S_61\\NP_56)_61\\(S_61\\NP_56)_61)/N[num]_62>) (<L N[num] CD CD 29 N[num]>) ) ) ) ) (<L . . . . .>) ) ";
        this.defaultCCGTreebank = CCGNode.getCCGNodeFromString(defaultCCGStr);
        CCGTreebank.add(this.defaultCCGTreebank);
        this.CCGcomponent.loadTreebank(CCGTreebank);
        this.CCGcomponent.init();
        this.CCGcomponent.setBackground(Color.WHITE);
        ArrayList<Element> LFGStructbank = new ArrayList<Element>();
        String defaultLFGStr = "<?xml version=\"1.0\" encoding=\"utf-8\" ?><lfg><cstruct>( (S#1 (NP#2 (NP#2 (NNP Pierre) (NNP Vinken) ) (, ,) (ADJP (NP (CD 61) (NNS years) ) (JJ old) ) (, ,) ) (VP (MD will) (VP#1 (VB join) (NP (DT the) (NN board) ) (PP (IN as) (NP (DT a) (JJ nonexecutive) (NN director) )) (NP-TMP (NNP Nov.) (CD 29) ))) (. .) ))</cstruct><fstruct id=\"1\"><attr name=\"PRED\" valtype=\"sem\"> 'join(SUBJ,OBJ,XCOMP)' </attr><attr name=\"SUBJ\" valtype=\"fstruct\"><fstruct id=\"2\"><attr name=\"PRED\" valtype=\"sem\"> 'vinken' </attr><attr name=\"NUM\" valtype=\"atomic\"> SG </attr><attr name=\"ADJ\" valtype=\"set\"><fstruct id=\"3\"><attr name=\"PRED\" valtype=\"sem\"> 'pierre' </attr></fstruct><fstruct id=\"4\"><attr name=\"PRED\" valtype=\"sem\"> 'old(SPEC)' </attr><attr name=\"SPEC\" valtype=\"fstruct\"><fstruct id=\"5\"><attr name=\"PRED\" valtype=\"sem\"> 'year(SPEC)' </attr><attr name=\"SPEC\" valtype=\"fstruct\"><fstruct id=\"6\"><attr name=\"PRED\" valtype=\"sem\"> '61' </attr></fstruct></attr></fstruct></attr></fstruct></attr></fstruct></attr><attr name=\"OBJ\" valtype=\"fstruct\"><fstruct id=\"7\"><attr name=\"PRED\" valtype=\"sem\"> 'broad' </attr><attr name=\"DEF\" valtype=\"atomic\"> + </attr><attr name=\"NUM\" valtype=\"atomic\"> SG </attr></fstruct></attr><attr name=\"XCOMP\" valtype=\"fstruct\"><fstruct id=\"8\"><attr name=\"PRED\" valtype=\"sem\"> 'as(OBJ)' </attr><attr name=\"OBJ\" valtype=\"fstruct\"><fstruct id=\"9\"><attr name=\"PRED\" valtype=\"sem\"> 'director' </attr><attr name=\"NUM\" valtype=\"atomic\"> SG </attr><attr name=\"ADJ\" valtype=\"set\"><fstruct id=\"10\"><attr name=\"PRED\" valtype=\"sem\"> 'nonexecutive' </attr></fstruct></attr><attr name=\"DEF\" valtype=\"atomic\"> + </attr></fstruct></attr></fstruct></attr><attr name=\"TENSE\" valtype=\"atomic\"> FUTURE </attr><attr name=\"ADJ\" valtype=\"set\"><fstruct id=\"11\"><attr name=\"PRED\" valtype=\"set\"><fstruct id=\"12\"><attr name=\"PRED\" valtype=\"sem\"> 'Nov.' </attr><attr name=\"TIME\" valtype=\"atomic\"> + </attr></fstruct><fstruct id=\"13\"><attr name=\"PRED\" valtype=\"sem\"> '29' </attr><attr name=\"TIME\" valtype=\"atomic\"> + </attr></fstruct></attr></fstruct></attr></fstruct></lfg>";
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(defaultLFGStr.getBytes("UTF-8"));
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document doc = builder.parse(stream);
            this.defaultLFGStructbank = doc.getDocumentElement();
            LFGStructbank.add(this.defaultLFGStructbank);
            this.LFGcomponent.loadTreebank(LFGStructbank);
            this.LFGcomponent.init();
            this.LFGcomponent.setBackground(Color.WHITE);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.Textcomponent.setText("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n<hint lang=\"English\">\n\tLoad a corpus\n</hint>\n<hint lang=\"Francais\">\n\tCharger un corpus\n</hint>\n<hint lang=\"Deutsch\">\n\tLaden ein Korpus\n</hint><hint lang=\"\u4e2d\u6587\">\n\t\u8bf7\u8f7d\u5165\u8bed\u6599\n</hint>");
        this.Textcomponent.setEditable(false);
        this.add((Component)this.tabbedPane, "Center");
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                if (TabbedPaneFrame.this.tabbedPane.getSelectedComponent() == null) {
                    int n = TabbedPaneFrame.this.tabbedPane.getSelectedIndex();
                    if (n == TabbedPaneFrame.this.tabbedPane.indexOfTab("Constituent Tree")) {
                        TabbedPaneFrame.this.tabbedPane.setComponentAt(n, TabbedPaneFrame.this.constScrollPane);
                    } else if (n == TabbedPaneFrame.this.tabbedPane.indexOfTab("Dependency Tree")) {
                        TabbedPaneFrame.this.tabbedPane.setComponentAt(n, TabbedPaneFrame.this.depScrollPane);
                    } else if (n == TabbedPaneFrame.this.tabbedPane.indexOfTab("Deep Dependency Graph")) {
                        TabbedPaneFrame.this.tabbedPane.setComponentAt(n, TabbedPaneFrame.this.deepdepScrollPane);
                    } else if (n == TabbedPaneFrame.this.tabbedPane.indexOfTab("Combinatorial Categorial Tree")) {
                        TabbedPaneFrame.this.tabbedPane.setComponentAt(n, TabbedPaneFrame.this.CCGScrollPane);
                    } else if (n == TabbedPaneFrame.this.tabbedPane.indexOfTab("Lexical Functional Structure")) {
                        TabbedPaneFrame.this.tabbedPane.setComponentAt(n, TabbedPaneFrame.this.LFGScrollPane);
                    } else if (n == TabbedPaneFrame.this.tabbedPane.indexOfTab("Text Editor")) {
                        TabbedPaneFrame.this.tabbedPane.setComponentAt(n, TabbedPaneFrame.this.TextScrollPane);
                    }
                }
            }
        });
        this.tabbedPane.setComponentAt(0, this.constScrollPane);
        this.tabbedPane.setTabLayoutPolicy(1);
        this.add((Component)this.statusBar, "South");
    }

    public void zoomIn() {
        this.constcomponent.fontSize = this.constcomponent.fontSize + 1;
        this.depcomponent.fontSize = this.depcomponent.fontSize + 1;
        this.deepdepcomponent.fontSize = this.deepdepcomponent.fontSize + 1;
        this.CCGcomponent.fontSize = this.CCGcomponent.fontSize + 1;
        this.LFGcomponent.fontSize = this.LFGcomponent.fontSize + 1;
        this.constcomponent.init();
        this.depcomponent.init();
        this.deepdepcomponent.init();
        this.CCGcomponent.init();
        this.LFGcomponent.init();
    }

    public void zoomOut() {
        if (this.constcomponent.fontSize > 0) {
            this.constcomponent.fontSize = this.constcomponent.fontSize - 1;
        }
        if (this.depcomponent.fontSize > 0) {
            this.depcomponent.fontSize = this.depcomponent.fontSize - 1;
        }
        if (this.deepdepcomponent.fontSize > 0) {
            this.deepdepcomponent.fontSize = this.deepdepcomponent.fontSize - 1;
        }
        if (this.CCGcomponent.fontSize > 0) {
            this.CCGcomponent.fontSize = this.CCGcomponent.fontSize - 1;
        }
        if (this.LFGcomponent.fontSize > 0) {
            this.LFGcomponent.fontSize = this.LFGcomponent.fontSize - 1;
        }
        this.constcomponent.init();
        this.depcomponent.init();
        this.deepdepcomponent.init();
        this.CCGcomponent.init();
        this.LFGcomponent.init();
    }

    /*
     * Unable to fully structure code
     */
    public void prevSent() {
        block21: {
            block20: {
                Success = true;
                if (this.constcomponent.sentenceNumber > 0) {
                    this.constcomponent.sentenceNumber = this.constcomponent.sentenceNumber - 1;
                    try {
                        this.constcomponent.init();
                    }
                    catch (Exception e) {
                        Success = false;
                        this.statusBar.setMessage("Please check for problems in constituent tree part.");
                        this.constcomponent.replaceCurrentSentence(this.defaultConstTreebank);
                        this.constcomponent.init();
                    }
                }
                if (this.depcomponent.sentenceNumber > 0) {
                    this.depcomponent.sentenceNumber = this.depcomponent.sentenceNumber - 1;
                    try {
                        this.depcomponent.init();
                        break block20;
                    }
                    catch (Exception e) {
                        Success = false;
                        this.statusBar.setMessage("Please check for problems in dependency tree part.");
                        var6_8 = e.getStackTrace();
                        var5_9 = var6_8.length;
                        var4_10 = 0;
                        ** while (var4_10 < var5_9)
                    }
lbl-1000:
                    // 1 sources

                    {
                        tr = var6_8[var4_10];
                        if (tr.getMethodName().contains("loadTokens")) {
                            this.statusBar.setMessage("Please check for problems in wordlist part.");
                        }
                        ++var4_10;
                        continue;
                    }
lbl29:
                    // 1 sources

                    this.depcomponent.replaceCurrentSentence(this.defaultDepTreebank);
                    this.depcomponent.init();
                }
            }
            if (this.deepdepcomponent.sentenceNumber > 0) {
                this.deepdepcomponent.sentenceNumber = this.deepdepcomponent.sentenceNumber - 1;
                try {
                    this.deepdepcomponent.init();
                    break block21;
                }
                catch (Exception e) {
                    Success = false;
                    this.statusBar.setMessage("Please check for problems in deep dependency tree part.");
                    var6_8 = e.getStackTrace();
                    var5_9 = var6_8.length;
                    var4_10 = 0;
                    ** while (var4_10 < var5_9)
                }
lbl-1000:
                // 1 sources

                {
                    tr = var6_8[var4_10];
                    if (tr.getMethodName().contains("loadTokens")) {
                        this.statusBar.setMessage("Please check for problems in wordlist part.");
                    }
                    ++var4_10;
                    continue;
                }
lbl49:
                // 1 sources

                this.deepdepcomponent.replaceCurrentSentence(this.defaultDeepdepTreebank);
                this.deepdepcomponent.init();
            }
        }
        if (this.CCGcomponent.sentenceNumber > 0) {
            this.CCGcomponent.sentenceNumber = this.CCGcomponent.sentenceNumber - 1;
            try {
                this.CCGcomponent.init();
            }
            catch (Exception e) {
                Success = false;
                this.statusBar.setMessage("Please check for problems in CCG part.");
                this.CCGcomponent.replaceCurrentSentence(this.defaultCCGTreebank);
                this.CCGcomponent.init();
            }
        }
        if (this.LFGcomponent.sentenceNumber > 0) {
            this.LFGcomponent.sentenceNumber = this.LFGcomponent.sentenceNumber - 1;
            try {
                this.LFGcomponent.init();
            }
            catch (Exception e) {
                Success = false;
                this.statusBar.setMessage("Please check for problems in LFG part.");
                this.LFGcomponent.replaceCurrentSentence(this.defaultLFGStructbank);
                this.LFGcomponent.init();
            }
        }
        if (Success) {
            this.statusBar.setMessage("You are at sentence " + Integer.toString(this.constcomponent.sentenceNumber + 1) + "/" + Integer.toString(this.constcomponent.lastIndex + 1));
        }
    }

    /*
     * Unable to fully structure code
     */
    public void nextSent() {
        block21: {
            block20: {
                Success = true;
                if (this.constcomponent.sentenceNumber < this.constcomponent.lastIndex) {
                    this.constcomponent.sentenceNumber = this.constcomponent.sentenceNumber + 1;
                    try {
                        this.constcomponent.init();
                    }
                    catch (Exception e) {
                        Success = false;
                        this.statusBar.setMessage("Please check for problems in constituent tree part.");
                        this.constcomponent.replaceCurrentSentence(this.defaultConstTreebank);
                        this.constcomponent.init();
                    }
                }
                if (this.depcomponent.sentenceNumber < this.depcomponent.lastIndex) {
                    this.depcomponent.sentenceNumber = this.depcomponent.sentenceNumber + 1;
                    try {
                        this.depcomponent.init();
                        break block20;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        Success = false;
                        this.statusBar.setMessage("Please check for problems in dependency tree part.");
                        var6_8 = e.getStackTrace();
                        var5_9 = var6_8.length;
                        var4_10 = 0;
                        ** while (var4_10 < var5_9)
                    }
lbl-1000:
                    // 1 sources

                    {
                        tr = var6_8[var4_10];
                        if (tr.getMethodName().contains("loadTokens")) {
                            this.statusBar.setMessage("Please check for problems in wordlist part.");
                        }
                        ++var4_10;
                        continue;
                    }
lbl30:
                    // 1 sources

                    this.depcomponent.replaceCurrentSentence(this.defaultDepTreebank);
                    this.depcomponent.init();
                }
            }
            if (this.deepdepcomponent.sentenceNumber < this.deepdepcomponent.lastIndex) {
                this.deepdepcomponent.sentenceNumber = this.deepdepcomponent.sentenceNumber + 1;
                try {
                    this.deepdepcomponent.init();
                    break block21;
                }
                catch (Exception e) {
                    Success = false;
                    this.statusBar.setMessage("Please check for problems in deep dependency tree part.");
                    var6_8 = e.getStackTrace();
                    var5_9 = var6_8.length;
                    var4_10 = 0;
                    ** while (var4_10 < var5_9)
                }
lbl-1000:
                // 1 sources

                {
                    tr = var6_8[var4_10];
                    if (tr.getMethodName().contains("loadTokens")) {
                        this.statusBar.setMessage("Please check for problems in wordlist part.");
                    }
                    ++var4_10;
                    continue;
                }
lbl50:
                // 1 sources

                this.deepdepcomponent.replaceCurrentSentence(this.defaultDeepdepTreebank);
                this.deepdepcomponent.init();
            }
        }
        if (this.CCGcomponent.sentenceNumber < this.CCGcomponent.lastIndex) {
            this.CCGcomponent.sentenceNumber = this.CCGcomponent.sentenceNumber + 1;
            try {
                this.CCGcomponent.init();
            }
            catch (Exception e) {
                Success = false;
                this.statusBar.setMessage("Please check for problems in CCG part.");
                this.CCGcomponent.replaceCurrentSentence(this.defaultCCGTreebank);
                this.CCGcomponent.init();
            }
        }
        if (this.LFGcomponent.sentenceNumber < this.LFGcomponent.lastIndex) {
            this.LFGcomponent.sentenceNumber = this.LFGcomponent.sentenceNumber + 1;
            try {
                this.LFGcomponent.init();
            }
            catch (Exception e) {
                Success = false;
                this.statusBar.setMessage("Please check for problems in LFG part.");
                this.LFGcomponent.replaceCurrentSentence(this.defaultLFGStructbank);
                this.LFGcomponent.init();
            }
        }
        if (Success) {
            this.statusBar.setMessage("You are at sentence " + Integer.toString(this.constcomponent.sentenceNumber + 1) + "/" + Integer.toString(this.constcomponent.lastIndex + 1));
        }
    }

    /*
     * Unable to fully structure code
     */
    public void jumpSent(int newSentenceNumber) {
        block21: {
            block20: {
                Success = true;
                if (--newSentenceNumber <= this.constcomponent.lastIndex && newSentenceNumber > 0) {
                    this.constcomponent.sentenceNumber = newSentenceNumber;
                    try {
                        this.constcomponent.init();
                    }
                    catch (Exception e) {
                        Success = false;
                        this.statusBar.setMessage("Please check for problems in constituent tree part.");
                    }
                }
                if (newSentenceNumber <= this.depcomponent.lastIndex && newSentenceNumber > 0) {
                    this.depcomponent.sentenceNumber = newSentenceNumber;
                    try {
                        this.depcomponent.init();
                        break block20;
                    }
                    catch (Exception e) {
                        Success = false;
                        this.statusBar.setMessage("Please check for problems in dependency tree part.");
                        var7_9 = e.getStackTrace();
                        var6_10 = var7_9.length;
                        var5_11 = 0;
                        ** while (var5_11 < var6_10)
                    }
lbl-1000:
                    // 1 sources

                    {
                        tr = var7_9[var5_11];
                        if (tr.getMethodName().contains("loadTokens")) {
                            this.statusBar.setMessage("Please check for problems in wordlist part.");
                        }
                        ++var5_11;
                        continue;
                    }
                }
            }
            if (newSentenceNumber <= this.deepdepcomponent.lastIndex && newSentenceNumber > 0) {
                this.deepdepcomponent.sentenceNumber = newSentenceNumber;
                try {
                    this.deepdepcomponent.init();
                    break block21;
                }
                catch (Exception e) {
                    Success = false;
                    this.statusBar.setMessage("Please check for problems in deep dependency tree part.");
                    var7_9 = e.getStackTrace();
                    var6_10 = var7_9.length;
                    var5_11 = 0;
                    ** while (var5_11 < var6_10)
                }
lbl-1000:
                // 1 sources

                {
                    tr = var7_9[var5_11];
                    if (tr.getMethodName().contains("loadTokens")) {
                        this.statusBar.setMessage("Please check for problems in wordlist part.");
                    }
                    ++var5_11;
                    continue;
                }
            }
        }
        if (newSentenceNumber <= this.CCGcomponent.lastIndex && newSentenceNumber > 0) {
            this.CCGcomponent.sentenceNumber = newSentenceNumber;
            try {
                this.CCGcomponent.init();
            }
            catch (Exception e) {
                Success = false;
                this.statusBar.setMessage("Please check for problems in CCG part.");
            }
        }
        if (newSentenceNumber <= this.LFGcomponent.lastIndex && newSentenceNumber > 0) {
            this.LFGcomponent.sentenceNumber = newSentenceNumber;
            try {
                this.LFGcomponent.init();
            }
            catch (Exception e) {
                Success = false;
                this.statusBar.setMessage("Please check for problems in LFG part.");
            }
        }
        if (Success) {
            this.statusBar.setMessage("You are at sentence " + Integer.toString(this.constcomponent.sentenceNumber + 1) + "/" + Integer.toString(this.constcomponent.lastIndex + 1));
        }
    }

    /*
     * Unable to fully structure code
     */
    public void importView(Document doc) {
        docRoot = doc.getDocumentElement();
        children = docRoot.getChildNodes();
        Sentences = new ArrayList<Element>();
        i = 0;
        while (i < children.getLength()) {
            child = children.item(i);
            if (child instanceof Element) {
                Sentences.add((Element)child);
            }
            ++i;
        }
        constTreebank = new ArrayList<ConstTree>();
        depTreebank = new ArrayList<DepTree>();
        deepdepTreebank = new ArrayList<DepTree>();
        CCGTreebank = new ArrayList<CCGNode>();
        LFGStructbank = new ArrayList<Element>();
        Success = true;
        sentNum = 0;
        sentNum = 0;
        while (sentNum < Sentences.size()) {
            sent = (Element)Sentences.get(sentNum);
            constTreeAdded = false;
            depTreeAdded = false;
            deepdepTreeAdded = false;
            CCGTreeAdded = false;
            LFGStructAdded = false;
            if (sent instanceof Element) {
                sentChildren = sent.getChildNodes();
                tokenls = null;
                j = 0;
                while (j < sentChildren.getLength()) {
                    block68: {
                        sentElement = sentChildren.item(j);
                        if (sentElement instanceof Element && sentElement.getNodeName() == "wordlist") {
                            tokenls = (Element)sentElement;
                        } else if (sentElement instanceof Element && sentElement.getNodeName() == "constree") {
                            try {
                                children = sentElement.getChildNodes();
                                constStr = new String();
                                k = 0;
                                while (k < children.getLength()) {
                                    constTextNode = children.item(k);
                                    if (constTextNode instanceof Text) {
                                        constStr = ((Text)constTextNode).getTextContent();
                                    }
                                    ++k;
                                }
                                if (!constStr.trim().isEmpty()) {
                                    constTree = ConstTree.ConstTreeIO.ReadConstTree(constStr);
                                    constTreebank.add(constTree);
                                } else {
                                    constTreebank.add(this.defaultConstTreebank);
                                }
                                constTreeAdded = true;
                            }
                            catch (Exception e) {
                                Success = false;
                                this.statusBar.setMessage("Please check for problems in constituent tree part.");
                            }
                        } else {
                            if (sentElement instanceof Element && sentElement.getNodeName() == "deptree") {
                                try {
                                    children = sentElement.getChildNodes();
                                    depStr = new String();
                                    k = 0;
                                    while (k < children.getLength()) {
                                        depTextNode = children.item(k);
                                        if (depTextNode instanceof Text) {
                                            depStr = ((Text)depTextNode).getTextContent();
                                        }
                                        ++k;
                                    }
                                    if (!depStr.trim().isEmpty()) {
                                        depTree = new DepTree();
                                        depTree.loadTokens(tokenls);
                                        depTree.loadEdges(depStr.trim());
                                        depTreebank.add(depTree);
                                    } else {
                                        depTreebank.add(this.defaultDepTreebank);
                                    }
                                    depTreeAdded = true;
                                    break block68;
                                }
                                catch (Exception e) {
                                    Success = false;
                                    this.statusBar.setMessage("Please check for problems in dependency tree part.");
                                    var26_52 = e.getStackTrace();
                                    var25_51 = var26_52.length;
                                    depTextNode = 0;
                                    ** while (depTextNode < var25_51)
                                }
lbl-1000:
                                // 1 sources

                                {
                                    tr = var26_52[depTextNode];
                                    if (tr.getMethodName().contains("loadTokens")) {
                                        this.statusBar.setMessage("Please check for problems in wordlist part.");
                                    }
                                    ++depTextNode;
                                    continue;
lbl94:
                                    // 1 sources

                                    break block68;
                                }
                            }
                            if (sentElement instanceof Element && sentElement.getNodeName() == "deepdep") {
                                try {
                                    children = sentElement.getChildNodes();
                                    depStr = new String();
                                    k = 0;
                                    while (k < children.getLength()) {
                                        depTextNode = children.item(k);
                                        if (depTextNode instanceof Text) {
                                            depStr = ((Text)depTextNode).getTextContent();
                                        }
                                        ++k;
                                    }
                                    if (!depStr.trim().isEmpty()) {
                                        depTree = new DepTree();
                                        depTree.loadTokens(tokenls);
                                        depTree.loadEdges(depStr.trim());
                                        deepdepTreebank.add(depTree);
                                    } else {
                                        deepdepTreebank.add(this.defaultDepTreebank);
                                    }
                                    deepdepTreeAdded = true;
                                    break block68;
                                }
                                catch (Exception e) {
                                    Success = false;
                                    this.statusBar.setMessage("Please check for problems in deep dependency tree part.");
                                    var26_52 = e.getStackTrace();
                                    var25_51 = var26_52.length;
                                    depTextNode = 0;
                                    ** while (depTextNode < var25_51)
                                }
lbl-1000:
                                // 1 sources

                                {
                                    tr = var26_52[depTextNode];
                                    if (tr.getMethodName().contains("loadTokens")) {
                                        this.statusBar.setMessage("Please check for problems in wordlist part.");
                                    }
                                    ++depTextNode;
                                    continue;
lbl129:
                                    // 1 sources

                                    break block68;
                                }
                            }
                            if (sentElement instanceof Element && sentElement.getNodeName() == "lfg") {
                                try {
                                    LFGStructbank.add((Element)sentElement);
                                    LFGStructAdded = true;
                                }
                                catch (Exception e) {
                                    Success = false;
                                    this.statusBar.setMessage("Please check for problems in LFG part.");
                                }
                            } else if (sentElement instanceof Element && sentElement.getNodeName() == "ccg") {
                                try {
                                    children = sentElement.getChildNodes();
                                    CCGStr = new String();
                                    k = 0;
                                    while (k < children.getLength()) {
                                        CCGTextNode = children.item(k);
                                        if (CCGTextNode instanceof Text) {
                                            CCGStr = ((Text)CCGTextNode).getTextContent();
                                        }
                                        ++k;
                                    }
                                    if (CCGStr.trim().matches("^\\( *\\)$")) {
                                        CCGTree = new CCGTerminalNode("<L _ _ _ _ _>", 0);
                                        CCGTreebank.add(CCGTree);
                                    } else if (!CCGStr.trim().isEmpty()) {
                                        CCGStr = CCGStr.replace('{', '<');
                                        CCGStr = CCGStr.replace('}', '>');
                                        CCGTree = CCGNode.getCCGNodeFromString(CCGStr.trim());
                                        CCGTreebank.add(CCGTree);
                                    } else {
                                        CCGTreebank.add(this.defaultCCGTreebank);
                                    }
                                    CCGTreeAdded = true;
                                }
                                catch (Exception e) {
                                    Success = false;
                                    this.statusBar.setMessage("Please check for problems in CCG part.");
                                    e.printStackTrace();
                                }
                            }
                        }
                    }
                    ++j;
                }
            }
            if (!constTreeAdded) {
                constTreebank.add(this.defaultConstTreebank);
            }
            if (!depTreeAdded) {
                depTreebank.add(this.defaultDepTreebank);
            }
            if (!deepdepTreeAdded) {
                deepdepTreebank.add(this.defaultDeepdepTreebank);
            }
            if (!CCGTreeAdded) {
                CCGTreebank.add(this.defaultCCGTreebank);
            }
            if (!LFGStructAdded) {
                LFGStructbank.add(this.defaultLFGStructbank);
            }
            ++sentNum;
        }
        this.constcomponent.sentenceNumber = 0;
        this.depcomponent.sentenceNumber = 0;
        this.deepdepcomponent.sentenceNumber = 0;
        this.CCGcomponent.sentenceNumber = 0;
        this.LFGcomponent.sentenceNumber = 0;
        if (!constTreebank.isEmpty()) {
            try {
                this.constcomponent.loadTreebank(constTreebank);
                this.constcomponent.init();
            }
            catch (Exception e) {
                Success = false;
                this.statusBar.setMessage("Please check for problems in constituent tree part.");
                this.constcomponent.replaceCurrentSentence(this.defaultConstTreebank);
                this.constcomponent.init();
            }
        }
        if (!depTreebank.isEmpty()) {
            try {
                this.depcomponent.loadTreebank(depTreebank);
                this.depcomponent.init();
            }
            catch (Exception e) {
                Success = false;
                this.statusBar.setMessage("Please check for problems in dependency tree part.");
                this.depcomponent.replaceCurrentSentence(this.defaultDepTreebank);
                this.depcomponent.init();
            }
        }
        if (!deepdepTreebank.isEmpty()) {
            try {
                this.deepdepcomponent.loadTreebank(deepdepTreebank);
                this.deepdepcomponent.init();
            }
            catch (Exception e) {
                Success = false;
                this.statusBar.setMessage("Please check for problems in deep dependency tree part.");
                this.deepdepcomponent.replaceCurrentSentence(this.defaultDeepdepTreebank);
                this.deepdepcomponent.init();
            }
        }
        if (!CCGTreebank.isEmpty()) {
            try {
                this.CCGcomponent.loadTreebank(CCGTreebank);
                this.CCGcomponent.init();
            }
            catch (Exception e) {
                Success = false;
                this.statusBar.setMessage("Please check for problems in CCG part.");
                this.CCGcomponent.replaceCurrentSentence(this.defaultCCGTreebank);
                this.CCGcomponent.init();
            }
        }
        if (!LFGStructbank.isEmpty()) {
            try {
                this.LFGcomponent.loadTreebank(LFGStructbank);
                this.LFGcomponent.init();
                if (!this.LFGcomponent.isAllRefValid()) {
                    Success = false;
                    this.statusBar.setMessage("Invalid c-structure & f-structure correspondence detected.");
                }
            }
            catch (Exception e) {
                Success = false;
                this.statusBar.setMessage("Please check for problems in LFG part.");
                this.LFGcomponent.replaceCurrentSentence(this.defaultLFGStructbank);
                this.LFGcomponent.init();
            }
        }
        if (Success) {
            this.statusBar.setMessage("You are at sentence " + Integer.toString(this.constcomponent.sentenceNumber + 1) + "/" + Integer.toString(this.constcomponent.lastIndex + 1));
        }
    }

    public void importFromFile(String filename) {
        try {
            int res = 0;
            if (new File(filename).length() > 1024000L) {
                res = JOptionPane.showConfirmDialog(this.tabbedPane, "This file may results in a long time wait due to its large size.\nWould you like to continue anyway?", "Warning", 0);
            }
            if (res == 0) {
                new TextComponentLayout(this.Textcomponent, filename);
                this.Textcomponent.getDocument().addUndoableEditListener(new XMLUndoableEditListener());
                this.undoManager.discardAllEdits();
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                DocumentBuilder builder = factory.newDocumentBuilder();
                Document doc = builder.parse(new InputSource(new FileReader(filename)));
                this.importView(doc);
            }
        }
        catch (Exception e) {
            this.statusBar.setMessage("Please check for problems in XML format.");
        }
    }

    public void importFromString(String ViewStr) {
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream stream = new ByteArrayInputStream(ViewStr.getBytes("UTF-8"));
            Document doc = builder.parse(stream);
            this.importView(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    class ColorLineListener
    implements ActionListener {
        ColorLineListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TabbedPaneFrame.this.LFGcomponent.isColor = !TabbedPaneFrame.this.LFGcomponent.isColor;
            TabbedPaneFrame.this.LFGcomponent.init();
        }
    }

    class CopyItemListener
    implements ActionListener {
        CopyItemListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TabbedPaneFrame.this.Textcomponent.copy();
        }
    }

    class CutItemListener
    implements ActionListener {
        CutItemListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TabbedPaneFrame.this.Textcomponent.cut();
        }
    }

    class ExportItemListener
    implements ActionListener {
        ExportItemListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ExportOptionPanel exp = new ExportOptionPanel();
            exp.showDialog(TabbedPaneFrame.this, "Export");
        }
    }

    class ExportOptionPanel
    extends JPanel {
        JDialog dialog;
        String FileLoc = new String();
        ButtonPanel tabChoicePanel = new ButtonPanel("Tab Choice", "Constituent", "Dependency", "Deep Dependency", "CCG", "LFG");
        FileLocPanel locPanel = new FileLocPanel();
        JButton ExportButton = new JButton("Export");

        public ExportOptionPanel() {
            this.ExportButton.addActionListener(new ExportActionListener());
            this.setLayout(new BorderLayout());
            Toolkit kit = Toolkit.getDefaultToolkit();
            Dimension screenSize = kit.getScreenSize();
            int screenHeight = screenSize.height;
            int screenWidth = screenSize.width;
            this.setSize(screenWidth / 3, screenHeight / 4);
            this.setBorder(new EmptyBorder(10, 10, 10, 10));
            Dimension origSize = this.tabChoicePanel.getPreferredSize();
            this.tabChoicePanel.setPreferredSize(new Dimension(screenWidth / 3, origSize.height));
            this.locPanel.setBorder(new EmptyBorder(5, 0, 5, 0));
            this.add((Component)this.tabChoicePanel, "North");
            this.add((Component)this.locPanel, "Center");
            JPanel ExportButtonWrapperPanel = new JPanel();
            ExportButtonWrapperPanel.add(this.ExportButton);
            ExportButtonWrapperPanel.setPreferredSize(new Dimension(100, 40));
            this.add((Component)ExportButtonWrapperPanel, "South");
        }

        public void showDialog(Component parent, String title) {
            Frame owner = null;
            owner = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
            if (this.dialog == null || this.dialog.getOwner() != owner) {
                this.dialog = new JDialog(owner, true);
                this.dialog.add(this);
                this.dialog.getRootPane().setDefaultButton(this.ExportButton);
                this.dialog.pack();
            }
            this.dialog.setTitle(title);
            this.dialog.setVisible(true);
        }

        class ExportActionListener
        implements ActionListener {
            ExportActionListener() {
            }

            @Override
            public void actionPerformed(ActionEvent event) {
                ExportOptionPanel.this.FileLoc = ExportOptionPanel.this.locPanel.getLoc();
                if (ExportOptionPanel.this.FileLoc != null && !ExportOptionPanel.this.FileLoc.isEmpty()) {
                    String sel = ExportOptionPanel.this.tabChoicePanel.getSelection();
                    try {
                        if (sel == "Constituent") {
                            Dimension dim = ((ExportOptionPanel)ExportOptionPanel.this).TabbedPaneFrame.this.constcomponent.getDimension();
                            EpsGraphics g = new EpsGraphics("Title", new FileOutputStream(ExportOptionPanel.this.FileLoc), 0, 0, (int)dim.getWidth() + 2, (int)dim.getHeight(), ColorMode.COLOR_RGB);
                            ((ExportOptionPanel)ExportOptionPanel.this).TabbedPaneFrame.this.constcomponent.paint(g);
                            g.flush();
                            g.close();
                        } else if (sel == "Dependency") {
                            Dimension dim = ((ExportOptionPanel)ExportOptionPanel.this).TabbedPaneFrame.this.depcomponent.getDimension();
                            EpsGraphics g = new EpsGraphics("Title", new FileOutputStream(ExportOptionPanel.this.FileLoc), 0, 0, (int)dim.getWidth() + 2, (int)dim.getHeight(), ColorMode.COLOR_RGB);
                            ((ExportOptionPanel)ExportOptionPanel.this).TabbedPaneFrame.this.depcomponent.paint(g);
                            g.flush();
                            g.close();
                        } else if (sel == "Deep Dependency") {
                            Dimension dim = ((ExportOptionPanel)ExportOptionPanel.this).TabbedPaneFrame.this.deepdepcomponent.getDimension();
                            EpsGraphics g = new EpsGraphics("Title", new FileOutputStream(ExportOptionPanel.this.FileLoc), 0, 0, (int)dim.getWidth() + 2, (int)dim.getHeight(), ColorMode.COLOR_RGB);
                            ((ExportOptionPanel)ExportOptionPanel.this).TabbedPaneFrame.this.deepdepcomponent.paint(g);
                            g.flush();
                            g.close();
                        } else if (sel == "LFG") {
                            Dimension dim = ((ExportOptionPanel)ExportOptionPanel.this).TabbedPaneFrame.this.LFGcomponent.getDimension();
                            EpsGraphics g = new EpsGraphics("Title", new FileOutputStream(ExportOptionPanel.this.FileLoc), 0, 0, (int)dim.getWidth() + 2, (int)dim.getHeight(), ColorMode.COLOR_RGB);
                            ((ExportOptionPanel)ExportOptionPanel.this).TabbedPaneFrame.this.LFGcomponent.paint(g);
                            g.flush();
                            g.close();
                        } else if (sel == "CCG") {
                            Dimension dim = ((ExportOptionPanel)ExportOptionPanel.this).TabbedPaneFrame.this.CCGcomponent.getDimension();
                            EpsGraphics g = new EpsGraphics("Title", new FileOutputStream(ExportOptionPanel.this.FileLoc), 0, 0, (int)dim.getWidth() + 2, (int)dim.getHeight(), ColorMode.COLOR_RGB);
                            ((ExportOptionPanel)ExportOptionPanel.this).TabbedPaneFrame.this.CCGcomponent.paint(g);
                            g.flush();
                            g.close();
                        }
                        JOptionPane.showMessageDialog((Component)event.getSource(), "Export successful!");
                    }
                    catch (FileNotFoundException e) {
                        JOptionPane.showMessageDialog((Component)event.getSource(), "Invalid file directory, or you are not authorized to access.");
                    }
                    catch (IOException e) {
                        JOptionPane.showMessageDialog((Component)event.getSource(), "An I/O exception occurred.");
                    }
                }
            }
        }
    }

    class ImportItemListener
    implements ActionListener {
        ImportItemListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            JFileChooser chooser = new JFileChooser();
            chooser.setCurrentDirectory(new File("."));
            int result = chooser.showOpenDialog(TabbedPaneFrame.this);
            if (chooser.getSelectedFile() != null && result == 0) {
                try {
                    if (!chooser.getSelectedFile().exists()) {
                        chooser.getSelectedFile().createNewFile();
                        BufferedWriter in = new BufferedWriter(new FileWriter(chooser.getSelectedFile()));
                        in.write("<?xml version=\"1.0\" encoding=\"utf-8\" ?>\n");
                        in.write("<viewer>\n");
                        in.write("\t<sentence id=\"1\">\n");
                        in.write("\t</sentence>\n");
                        in.write("</viewer>\n");
                        in.close();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                TabbedPaneFrame.this.filename = chooser.getSelectedFile().getAbsolutePath();
                TabbedPaneFrame.this.importFromFile(TabbedPaneFrame.this.filename);
            }
        }
    }

    class JumpSentListener
    implements ActionListener {
        JumpSentListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            String res = JOptionPane.showInputDialog(TabbedPaneFrame.this.tabbedPane, "To which sentence do you what to jump?", "Jump To Sentence...", -1);
            if (res != null && !res.trim().isEmpty()) {
                TabbedPaneFrame.this.jumpSent(Integer.parseInt(res));
            }
        }
    }

    class NextSentListener
    implements ActionListener {
        NextSentListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TabbedPaneFrame.this.nextSent();
        }
    }

    class NextTabListener
    implements ActionListener {
        NextTabListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int n = TabbedPaneFrame.this.tabbedPane.getSelectedIndex();
            if (n == TabbedPaneFrame.this.tabbedPane.indexOfTab("Constituent Tree")) {
                n = TabbedPaneFrame.this.tabbedPane.indexOfTab("Dependency Tree");
                TabbedPaneFrame.this.tabbedPane.setSelectedIndex(n);
                TabbedPaneFrame.this.tabbedPane.setComponentAt(n, TabbedPaneFrame.this.depScrollPane);
            } else if (n == TabbedPaneFrame.this.tabbedPane.indexOfTab("Dependency Tree")) {
                n = TabbedPaneFrame.this.tabbedPane.indexOfTab("Deep Dependency Graph");
                TabbedPaneFrame.this.tabbedPane.setSelectedIndex(n);
                TabbedPaneFrame.this.tabbedPane.setComponentAt(n, TabbedPaneFrame.this.deepdepScrollPane);
            } else if (n == TabbedPaneFrame.this.tabbedPane.indexOfTab("Deep Dependency Graph")) {
                n = TabbedPaneFrame.this.tabbedPane.indexOfTab("Combinatorial Categorial Tree");
                TabbedPaneFrame.this.tabbedPane.setSelectedIndex(n);
                TabbedPaneFrame.this.tabbedPane.setComponentAt(n, TabbedPaneFrame.this.CCGScrollPane);
            } else if (n == TabbedPaneFrame.this.tabbedPane.indexOfTab("Combinatorial Categorial Tree")) {
                n = TabbedPaneFrame.this.tabbedPane.indexOfTab("Lexical Functional Structure");
                TabbedPaneFrame.this.tabbedPane.setSelectedIndex(n);
                TabbedPaneFrame.this.tabbedPane.setComponentAt(n, TabbedPaneFrame.this.LFGScrollPane);
            } else if (n == TabbedPaneFrame.this.tabbedPane.indexOfTab("Lexical Functional Structure")) {
                n = TabbedPaneFrame.this.tabbedPane.indexOfTab("Text Editor");
                TabbedPaneFrame.this.tabbedPane.setSelectedIndex(n);
                TabbedPaneFrame.this.tabbedPane.setComponentAt(n, TabbedPaneFrame.this.TextScrollPane);
            }
        }
    }

    class PasteItemListener
    implements ActionListener {
        PasteItemListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TabbedPaneFrame.this.Textcomponent.paste();
        }
    }

    class PrevSentListener
    implements ActionListener {
        PrevSentListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TabbedPaneFrame.this.prevSent();
        }
    }

    class PrevTabListener
    implements ActionListener {
        PrevTabListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            int n = TabbedPaneFrame.this.tabbedPane.getSelectedIndex();
            if (n == TabbedPaneFrame.this.tabbedPane.indexOfTab("Dependency Tree")) {
                n = TabbedPaneFrame.this.tabbedPane.indexOfTab("Constituent Tree");
                TabbedPaneFrame.this.tabbedPane.setSelectedIndex(n);
                TabbedPaneFrame.this.tabbedPane.setComponentAt(n, TabbedPaneFrame.this.constScrollPane);
            } else if (n == TabbedPaneFrame.this.tabbedPane.indexOfTab("Deep Dependency Graph")) {
                n = TabbedPaneFrame.this.tabbedPane.indexOfTab("Dependency Tree");
                TabbedPaneFrame.this.tabbedPane.setSelectedIndex(n);
                TabbedPaneFrame.this.tabbedPane.setComponentAt(n, TabbedPaneFrame.this.depScrollPane);
            } else if (n == TabbedPaneFrame.this.tabbedPane.indexOfTab("Combinatorial Categorial Tree")) {
                n = TabbedPaneFrame.this.tabbedPane.indexOfTab("Deep Dependency Graph");
                TabbedPaneFrame.this.tabbedPane.setSelectedIndex(n);
                TabbedPaneFrame.this.tabbedPane.setComponentAt(n, TabbedPaneFrame.this.deepdepScrollPane);
            } else if (n == TabbedPaneFrame.this.tabbedPane.indexOfTab("Lexical Functional Structure")) {
                n = TabbedPaneFrame.this.tabbedPane.indexOfTab("Combinatorial Categorial Tree");
                TabbedPaneFrame.this.tabbedPane.setSelectedIndex(n);
                TabbedPaneFrame.this.tabbedPane.setComponentAt(n, TabbedPaneFrame.this.CCGScrollPane);
            } else if (n == TabbedPaneFrame.this.tabbedPane.indexOfTab("Text Editor")) {
                n = TabbedPaneFrame.this.tabbedPane.indexOfTab("Lexical Functional Structure");
                TabbedPaneFrame.this.tabbedPane.setSelectedIndex(n);
                TabbedPaneFrame.this.tabbedPane.setComponentAt(n, TabbedPaneFrame.this.LFGScrollPane);
            }
        }
    }

    class SaveTextAsListener
    implements ActionListener {
        SaveTextAsListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            if (TabbedPaneFrame.this.filename != null) {
                JFileChooser chooser = new JFileChooser();
                chooser.setCurrentDirectory(new File("."));
                int result = chooser.showSaveDialog(TabbedPaneFrame.this);
                TabbedPaneFrame.this.filename = chooser.getSelectedFile().getAbsolutePath();
                if (result == 0) {
                    try {
                        String File2 = TabbedPaneFrame.this.Textcomponent.getText();
                        if (TabbedPaneFrame.this.filename != null && !TabbedPaneFrame.this.filename.trim().isEmpty()) {
                            BufferedWriter in = new BufferedWriter(new FileWriter(TabbedPaneFrame.this.filename));
                            in.write(File2);
                            in.close();
                            TabbedPaneFrame.this.importFromFile(TabbedPaneFrame.this.filename);
                        }
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    class SaveTextListener
    implements ActionListener {
        SaveTextListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            try {
                String File2 = TabbedPaneFrame.this.Textcomponent.getText();
                if (TabbedPaneFrame.this.filename != null && !TabbedPaneFrame.this.filename.trim().isEmpty()) {
                    BufferedWriter in = new BufferedWriter(new FileWriter(TabbedPaneFrame.this.filename));
                    in.write(File2);
                    in.close();
                    TabbedPaneFrame.this.importFromFile(TabbedPaneFrame.this.filename);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class SelAllItemListener
    implements ActionListener {
        SelAllItemListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TabbedPaneFrame.this.Textcomponent.selectAll();
        }
    }

    class ShowLineListener
    implements ActionListener {
        ShowLineListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TabbedPaneFrame.this.LFGcomponent.isShown = !TabbedPaneFrame.this.LFGcomponent.isShown;
            TabbedPaneFrame.this.LFGcomponent.init();
        }
    }

    class SkewLineListener
    implements ActionListener {
        SkewLineListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TabbedPaneFrame.this.constcomponent.skewedLines = !TabbedPaneFrame.this.constcomponent.skewedLines;
            TabbedPaneFrame.this.constcomponent.init();
            TabbedPaneFrame.this.LFGcomponent.flipSkewedLines();
            TabbedPaneFrame.this.LFGcomponent.init();
        }
    }

    class StatusBar
    extends JLabel {
        public StatusBar() {
            super.setPreferredSize(new Dimension(500, 32));
            this.setMessage("Default treebank displaying, load a corpus to begin.");
        }

        public void setMessage(String message) {
            this.setText(String.valueOf(message) + " ");
            this.setHorizontalAlignment(11);
            this.setVerticalTextPosition(0);
        }
    }

    class XMLUndoableEditListener
    implements UndoableEditListener {
        XMLUndoableEditListener() {
        }

        @Override
        public void undoableEditHappened(UndoableEditEvent event) {
            if (!event.getEdit().getPresentationName().equals(UIManager.getString("AbstractDocument.styleChangeText"))) {
                UndoableEdit edit = event.getEdit();
                TabbedPaneFrame.this.undoManager.addEdit(edit);
            }
        }
    }

    class ZoomInListener
    implements ActionListener {
        ZoomInListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TabbedPaneFrame.this.zoomIn();
        }
    }

    class ZoomOutListener
    implements ActionListener {
        ZoomOutListener() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            TabbedPaneFrame.this.zoomOut();
        }
    }

    class laListener
    implements ActionListener {
        laListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            TabbedPaneFrame.this.constcomponent.displayLA = !TabbedPaneFrame.this.constcomponent.displayLA;
            TabbedPaneFrame.this.constcomponent.init();
            TabbedPaneFrame.this.LFGcomponent.flipDisplayLA();
            TabbedPaneFrame.this.LFGcomponent.init();
        }
    }
}

