# this program evaluates systems that extract temporal information from text 
# tlink -> temporal links

import tempeval_to_timegraph
import time 
import sys
import re 

debug = 0

def bar (index):
    #for arg in sys.argv:
    if debug >= 2: 
        print sys.argv[index]
    return sys.argv[index]

filename = bar(1)
config = 'code/config.txt' 
tempeval_to_timegraph.read_config(filename, config) 

# this module creates a timegraph given a file with tlinks 
def create_timegraph(tlink_file):
    filetext = tempeval_to_timegraph.read_tlinks(tlink_file) 
    dct_tid = tempeval_to_timegraph.getdct() 
    if tempeval_to_timegraph.timegraph_debug == 'true': 
        start_time = time.time()
    tg = tempeval_to_timegraph.Timegraph() 
    tg = tempeval_to_timegraph.tempeval_to_timegraph_func(filetext, dct_tid, tg) 
    if tempeval_to_timegraph.timegraph_debug == 'true': 
        end_time = time.time()
    if tempeval_to_timegraph.timegraph_debug == 'true': 
        print end_time-start_time, ',', tg.count_relation, ',', tg.count_node, ',', tg.next_chain+tg.count_cross_chain
    return tg 


# extract entities and relation from tlink line 
def get_x_y_rel(tlinks): 
    words = tlinks.split('\t')
    x = words[1]
    y = words[2]
    rel = words[3]
    return x, y, rel 

# find total relations find 
def total_relation_matched(system_tlinks_file, reference_tlinks_file, reference_tg): 
    system_tlinks = open(system_tlinks_file).read()
    reference_tlinks = open(reference_tlinks_file).read()
    count = 0 
    for tlink in system_tlinks.split('\n'):           
        if tlink.strip() == '': 
            continue 
        if debug >= 2: 
            print tlink

        if tempeval_to_timegraph.consider_direct_match=='true' and re.search(tlink, reference_tlinks): 
            count += 1 
            continue 
        x, y, rel = get_x_y_rel(tlink) 
        foo = tempeval_to_timegraph.interval_rel_X_Y(x, y, reference_tg, rel, 'evaluation')
        if foo[1] == 'true':
            count += 1 
        if tempeval_to_timegraph.debug_verification == 'true': 
            if foo[1] != 'true' or debug>=2:
                print x, y, rel, foo[1]
    return count, len(system_tlinks.split('\n'))-1

# function to do the temporal evaluation 
def temporal_evaluation(reference_tlinks, system_tlinks): 
    start_time = time.time()
    reference_tg = create_timegraph(reference_tlinks)
    if debug >= 2: 
        print reference_tg.count_relation, ',', reference_tg.count_node, ',', reference_tg.next_chain+reference_tg.count_cross_chain

    system_tg = create_timegraph(system_tlinks)
    if debug >= 2: 
        print system_tg.count_relation, ',', system_tg.count_node, ',', system_tg.next_chain+system_tg.count_cross_chain

    # calculate precision 
    # precision = (# of system temporal relations that can be verified from reference annotation temporal closure graph / # of temporal relations in system output) 
    foo = total_relation_matched(system_tlinks, reference_tlinks, reference_tg) 
    precision = foo[0]*1.0/foo[1]
    # calculate recall 
    # recall = (# of reference annotation temporal relations that can be verified from system output's temporal closure graph / # of temporal relations in reference annotation) 
    foo = total_relation_matched(reference_tlinks, system_tlinks, system_tg) 
    recall = foo[0]*1.0/foo[1]
    fscore = 2.0*precision*recall/(precision+recall)
    if debug >= 0: 
        print 'precision', precision, 'recall', recall
    print 'fscore', fscore 
    end_time = time.time()
    if debug >= 1: 
        print reference_tg.count_relation, ',', end_time-start_time

temporal_evaluation(tempeval_to_timegraph.all_tlinks, tempeval_to_timegraph.system_tlinks)
