from __future__ import print_function, division

import os
from string import Template

import argparse
parser = argparse.ArgumentParser()
parser.add_argument('-p', type=str, required=True, help='Training config function defined in configurations.py')
parser.add_argument('-q', type=str, help='queue name')
parser.add_argument('-i', help='CUDA number')
parser.add_argument('-w', help='working dir')
parser.add_argument('-n', help='name')
args = parser.parse_args()

proto = args.p
queue = args.q
gpu_num = args.i
working_dir = os.path.abspath(args.w)
name = args.n

is_ndnlp_queue = args.q in ['qa-titanx-011', 'qa-titanx-012', 'qa-xp-009', 'qa-xp-010', 'qa-1080ti-011', 'qa-1080ti-012', 'qa-1080ti-013', 'qa-1080ti-014']
if is_ndnlp_queue:
    queue += '\n#$ -l gpu_card=1'
if not is_ndnlp_queue:
    queue += '\n#$ -pe smp 6'

# should have made it more flexible...
template = Template("""#!/bin/csh

#$$ -M tnguye28@nd.edu
#$$ -m abe
#$$ -q gpu@$queue
#$$ -N $name         # Specify job name

module load tensorflow/1.1-python2

setenv CUDA_VISIBLE_DEVICES $gpu_num
cd $working_dir
fsync -d 30 nmt/DEBUG.log &
python -m nmt --proto $proto --fixed-var-list softmax.logit_layer.W
""")

job_script = template.substitute(dict(queue=queue, name=name, gpu_num=gpu_num, working_dir=working_dir, proto=proto))
job_script_path = os.path.join(working_dir, 'train.job')
open(job_script_path, 'w').close()
with open(job_script_path, 'w') as f:
    f.write(job_script)