#!/usr/bin/env perl

use strict;
use utf8;
$| = 1;
binmode STDIN, ":encoding(utf8)";
#binmode STDERR, ":encoding(utf8)";
binmode STDOUT, ":encoding(utf8)";

if ( @ARGV != 3 ) {
    print STDERR "$0 <new conjuction> <contraction rule> <mapping rule>\n";
    exit;
}
my %rule_;
my %contraction_rule_;
my %mapping_rule_;
&read_rule( $ARGV[0] );
&read_contraction_rule( $ARGV[1] );
&read_mappping_rule( $ARGV[2] );
&main();

sub main {

    while ( <STDIN> ) {
	chomp;
	my ( $surface_form_ref, $surface_pos_ref, $normal_form, $normal_reading, $normal_pos, $citation_form ) = &read_entry( $_ );

	my %hash;
	my @surface_forms = @{$surface_form_ref};
	my @surface_pos = @{$surface_pos_ref};
	for ( my$i = 0; $i < @surface_forms; ++$i ) {
	    $hash{"$surface_forms[$i]\t$surface_pos[$i]"} = 1;

	    my( $pos1, $pos2, $ctype, $cform ) = split( /,/, $surface_pos[$i] );
	    if ( defined $rule_{"$ctype,$cform"} ) {
		for ( my$j = 0; $j < @{$rule_{"$ctype,$cform"}}; ++$j ) {
		    my $old_suffix   = $rule_{"$ctype,$cform"}[$j]{"old_suffix"};
		    my @new_suffixes = @{$rule_{"$ctype,$cform"}[$j]{"new_suffix"}};
		    if ( $surface_forms[$i] =~ /(.*)$old_suffix$/ ) {
			my $stem = $1;
			for my$new_suffix ( @new_suffixes ) {
			    $hash{"$stem$new_suffix\t$surface_pos[$i]"} = 1;
			}
		    }
		}
	    }
	}

	for ( my$i = 0; $i < @surface_forms; ++$i ) {
	    my@chars = split( //, $surface_forms[$i] );
	    my( $pos1, $pos2, $ctype, $cform ) = split( /,/, $surface_pos[$i] );
	    if ( $ctype eq "*" && 1 < @chars && ( defined $contraction_rule_{$chars[-1]} || defined $contraction_rule_{$chars[-2].$chars[-1]} ) ) {
		my$new_surface_form = join( "", @chars[0..@chars-2] );
		$hash{"$new_surface_form\t$surface_pos[$i]"} = 1;
	    }
	}
	
	for ( my$i = 0; $i < @{$surface_form_ref}; ++$i ) {
	    my ( $surface_form, $surface_pos ) = ( $surface_form_ref->[$i], $surface_pos_ref->[$i] );
	    $hash{"$surface_form\t$surface_pos"} = 1;
	    for my$var ( grep { 0 < length($_) } &derive_ill_spelling( split( //, $surface_form ) ) ){
	    	$hash{"$var\t$surface_pos"} = 1;
	    }
	}
	
	for ( keys %hash ) {
	    print "$_\t$normal_form\t$normal_reading\t$normal_pos\t$citation_form\n";
	}
    }
}


sub read_rule {

    my ( $filename ) = @_;
    
    open( TEXT, $filename ) or die print STDERR "$filename\n";
    binmode( TEXT, ":encoding(utf8)" );
    while ( <TEXT> ) {
	chomp;
	next if ( /^\$/ || /^$/ );
	my @tmp = split( /\s/, $_ );
	my @surface_pos  = split( /\//, $tmp[0] );
	my $old_suffix   = $tmp[1];
	my @new_suffixes = split( /\//, $tmp[2] );
	for my$surface_pos ( @surface_pos ) {
	    push( @{$rule_{$surface_pos}}, { "old_suffix" => $old_suffix, "new_suffix" => [ @new_suffixes ] } );
	}
    }
    close( TEXT );
}


sub read_contraction_rule {

    my ( $filename ) = @_;
    
    open( TEXT, $filename ) or die print STDERR "$filename\n";
    binmode( TEXT, ":encoding(utf8)" );
    while ( <TEXT> ) {
	chomp;
	next if ( /^\$/ || /^$/ );
	$contraction_rule_{$_} = 1;
    }
    close( TEXT );
}


sub read_mappping_rule {

    my ( $filename ) = @_;

    open( TEXT, $filename ) or die print STDERR "$filename\n";
    binmode( TEXT, ":encoding(utf8)" );
    while ( <TEXT> ) {
	chomp;
	if ( /^\#/ || /^$/ ) {
	    next;
	}else {
	    my ( $lhs, $rhs ) = split( /\s+/, $_ );
	    if ( ! defined $rhs ) {
		$rhs = $lhs;
	    }
	    for my$source ( split( /,/, $lhs ) ) {
		for my$target ( split( /,/, $rhs ) ) {
		    if ( $target eq "*" ) {
			$target = "";
		    }
		    if ( $source ne $target ) {
			push( @{$mapping_rule_{$source}}, $target );
		    }
		}
	    }
	}
    }
    close( TEXT );
}


sub read_entry {

    my ( $line ) = @_;
    my ( @surface_forms, @surface_pos, $normal_form, $normal_reading, $normal_pos, $citation_form );
    my @data = split( /\t/, $line );

    $citation_form  = pop @data;
    $normal_pos     = pop @data;
    $normal_reading = pop @data;
    $normal_form    = pop @data;
    for ( my$i = 0; $i < @data; $i += 2 ) {
	push( @surface_forms, $data[$i] );
	push( @surface_pos, $data[$i+1] );
    }
    return ( [ @surface_forms ], [ @surface_pos ], $normal_form, $normal_reading, $normal_pos, $citation_form );
}


sub derive_ill_spelling {
    
    my ( @chars ) = @_;
    
    if ( @chars == 0 ) {
	return ( "" );
    }else {
	my @variants = map { $chars[0].$_; } &derive_ill_spelling( @chars[1..@chars-1] );
	
 	if ( defined $mapping_rule_{$chars[0]} ) {
	    for my$s1 ( @{$mapping_rule_{$chars[0]}} ) {
		for my$s2 ( &derive_ill_spelling( @chars[1..@chars-1] ) ) {
		    push( @variants, $s1.$s2 );
		}
	    }
	}
	
	if ( 1 < @chars && defined $mapping_rule_{$chars[0].$chars[1]} ) {
	    for my$s1 ( @{$mapping_rule_{$chars[0].$chars[1]}} ) {
		for my$s2 ( &derive_ill_spelling( @chars[2..@chars-1] ) ) {
		    push( @variants, $s1.$s2 );
		}
	    }
	}

	if ( 2 < @chars && defined $mapping_rule_{$chars[0].$chars[1]..$chars[2]} ) {
	    for my$s1 ( @{$mapping_rule_{$chars[0].$chars[1]..$chars[1]}} ) {
		for my$s2 ( &derive_ill_spelling( @chars[3..@chars-1] ) ) {
		    push( @variants, $s1.$s2 );
		}
	    }
	}
	return @variants;
    }
}
