/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.parser.algorithm.planar3T;

import org.maltparser.core.exception.MaltChainedException;
import org.maltparser.core.feature.function.AddressFunction;
import org.maltparser.core.feature.value.AddressValue;
import org.maltparser.parser.Algorithm;
import org.maltparser.parser.ParsingException;
import org.maltparser.parser.algorithm.planar3T.Planar3TConfig;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Planar3TAddressFunction
extends AddressFunction {
    protected String subFunctionName;
    protected Planar3TSubFunction subFunction;
    protected Algorithm parsingAlgorithm;
    protected int index;

    public Planar3TAddressFunction(String subFunctionName, Algorithm parsingAlgorithm) {
        this.setSubFunctionName(subFunctionName);
        this.setAlgorithm(parsingAlgorithm);
    }

    @Override
    public void initialize(Object[] arguments) throws MaltChainedException {
        if (arguments.length != 1) {
            throw new ParsingException("Could not initialize " + this.getClass().getName() + ": number of arguments are not correct. ");
        }
        if (!(arguments[0] instanceof Integer)) {
            throw new ParsingException("Could not initialize " + this.getClass().getName() + ": the first argument is not an integer. ");
        }
        this.setIndex((Integer)arguments[0]);
    }

    @Override
    public Class<?>[] getParameterTypes() {
        Class[] paramTypes = new Class[]{Integer.class};
        return paramTypes;
    }

    @Override
    public void update() throws MaltChainedException {
        this.update((Planar3TConfig)this.parsingAlgorithm.getCurrentParserConfiguration());
    }

    @Override
    public void update(Object[] arguments) throws MaltChainedException {
        if (arguments.length != 1 || !(arguments[0] instanceof Planar3TConfig)) {
            throw new ParsingException("Arguments to the planar address function is not correct. ");
        }
        this.update((Planar3TConfig)arguments[0]);
    }

    private void update(Planar3TConfig config) throws MaltChainedException {
        if (this.subFunction == Planar3TSubFunction.STACK) {
            this.address.setAddress(config.getStackNode(this.index));
        } else if (this.subFunction == Planar3TSubFunction.INPUT) {
            this.address.setAddress(config.getInputNode(this.index));
        } else {
            this.address.setAddress(null);
        }
    }

    public String getSubFunctionName() {
        return this.subFunctionName;
    }

    public void setSubFunctionName(String subFunctionName) {
        this.subFunctionName = subFunctionName;
        this.subFunction = Planar3TSubFunction.valueOf(subFunctionName.toUpperCase());
    }

    public Planar3TSubFunction getSubFunction() {
        return this.subFunction;
    }

    @Override
    public AddressValue getAddressValue() {
        return this.address;
    }

    public Algorithm getParsingAlgorithm() {
        return this.parsingAlgorithm;
    }

    public void setAlgorithm(Algorithm parsingAlgorithm) {
        this.parsingAlgorithm = parsingAlgorithm;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Planar3TAddressFunction other = (Planar3TAddressFunction)obj;
        if (this.index != other.index) {
            return false;
        }
        if (this.parsingAlgorithm == null ? other.parsingAlgorithm != null : !this.parsingAlgorithm.equals(other.parsingAlgorithm)) {
            return false;
        }
        return !(this.subFunction == null ? other.subFunction != null : !this.subFunction.equals((Object)other.subFunction));
    }

    @Override
    public String toString() {
        return this.subFunctionName + "[" + this.index + "]";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Planar3TSubFunction {
        STACK,
        INPUT;

    }
}

