/*
 	APS - Affinity Propagation for Segmentation, a linear text segmenter.
 
    Copyright (C) 2011, Anna Kazantseva

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
    */


package commandln;

import java.io.BufferedReader;
import java.io.FileReader;

public class CommandLineParser 
{
	private IParam mParams = null;
	public CommandLineParser(IParam params)
	{
		mParams = params;
	}
	
	public void Parse(String [] args) throws Exception
	{
		if (args.length == 2 && args[0].equals("-config"))
		{
			BufferedReader reader = new BufferedReader(new FileReader(args[1]));
			StringBuilder str = new StringBuilder();
			String line;
			while ((line = reader.readLine()) != null)
				str.append(line + " ");
			
			args = str.toString().split(" (?=([^\"]*\"[^\"]*\")*[^\"]*$)");
		}
		
		boolean valueRequired = false;
		for (String arg : args)
		{
			arg = arg.replace("\"", "");
			if (valueRequired)
			{
				mParams.ParseValue(arg);
				mParams.MarkAsFound();
				valueRequired = false;
			}
			else if (mParams.CompareName(arg))
			{
				if (mParams.ValueRequired())
					valueRequired = true;
				else
					mParams.MarkAsFound();
			}
		}
		
		if (!mParams.IsFound())
			throw new Exception("Not all mandatory params specified");
	}

	public String getStringValue(String paramName) throws Exception
	{
		if (mParams.CompareName(paramName))
			return mParams.getString();
		
		throw new Exception("Param not found");
	}
	
	public boolean getBoolValue(String paramName) throws Exception
	{
		if (mParams.CompareName(paramName))
			return mParams.getBool();
		
		throw new Exception("Param not found");
	}
	
	public int getIntValue(String paramName) throws Exception
	{
		if (mParams.CompareName(paramName))
			return mParams.getInt();
		
		throw new Exception("Param not found");
	}

	public double getDoubleValue(String paramName) throws Exception
	{
		if (mParams.CompareName(paramName))
			return mParams.getDouble();
		
		throw new Exception("Param not found");
	}

	public String [] getStringArrayValue(String paramName) throws Exception
	{
		if (mParams.CompareName(paramName))
			return mParams.getStringArray();
		
		throw new Exception("Param not found");
	}

	public int [] getIntArrayValue(String paramName) throws Exception
	{
		if (mParams.CompareName(paramName))
			return mParams.getIntArray();
		
		throw new Exception("Param not found");
	}

	public double [] getDoubleArrayValue(String paramName) throws Exception
	{
		if (mParams.CompareName(paramName))
			return mParams.getDoubleArray();
		
		throw new Exception("Param not found");
	}
}
