/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.stats;

import com.aliasi.stats.MultivariateDistribution;

public abstract class BernoulliDistribution
extends MultivariateDistribution {
    public static final String FAILURE_LABEL = "failure";
    public static final String SUCCESS_LABEL = "success";

    public long maxOutcome() {
        return 1L;
    }

    public int numDimensions() {
        return 2;
    }

    public double variance() {
        double successProb = this.successProbability();
        return successProb * (1.0 - successProb);
    }

    public double probability(long outcome) {
        if (outcome == 0L) {
            return 1.0 - this.successProbability();
        }
        if (outcome == 1L) {
            return this.successProbability();
        }
        return 0.0;
    }

    public String label(long outcome) {
        if (outcome == 0L) {
            return FAILURE_LABEL;
        }
        if (outcome == 1L) {
            return SUCCESS_LABEL;
        }
        String msg = "Only outcomes 0 and 1 have labels. Found outcome=" + outcome;
        throw new IllegalArgumentException(msg);
    }

    public abstract double successProbability();
}

