/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.matrix;

import com.aliasi.matrix.Matrix;
import com.aliasi.matrix.MatrixBackedVector;
import com.aliasi.matrix.Vector;

public abstract class AbstractMatrix
implements Matrix {
    protected AbstractMatrix() {
    }

    public abstract int numRows();

    public abstract int numColumns();

    public abstract double value(int var1, int var2);

    public void setValue(int row, int column, double value) {
        throw new UnsupportedOperationException();
    }

    public Vector rowVector(int row) {
        return new MatrixBackedVector.Row(this, row);
    }

    public Vector columnVector(int column) {
        return new MatrixBackedVector.Column(this, column);
    }

    public boolean equals(Object that) {
        if (!(that instanceof Matrix)) {
            return false;
        }
        Matrix thatMatrix = (Matrix)that;
        if (this.numRows() != thatMatrix.numRows()) {
            return false;
        }
        if (this.numColumns() != thatMatrix.numColumns()) {
            return false;
        }
        int i = this.numRows();
        while (--i >= 0) {
            if (((Object)this.rowVector(i)).equals(thatMatrix.rowVector(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int code = 1;
        int numRows = this.numRows();
        int numColumns = this.numColumns();
        for (int i = 0; i < numRows; ++i) {
            for (int j = 0; j < numColumns; ++j) {
                long v = Double.doubleToLongBits(this.value(i, j));
                int valHash = (int)(v ^ v >>> 32);
                code = 31 * code + valHash;
            }
        }
        return code;
    }
}

