/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.lm;

import com.aliasi.lm.AbstractNode;
import com.aliasi.lm.DtrMap;
import com.aliasi.lm.DtrMap0;
import com.aliasi.lm.DtrMap1;
import com.aliasi.lm.DtrMap2;
import com.aliasi.lm.IntNode;
import com.aliasi.symbol.SymbolTable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class DtrMapMap
extends TreeMap<Integer, IntNode>
implements DtrMap {
    static final long serialVersionUID = -840053413688713070L;

    DtrMapMap(int out1, int out2, int out3, IntNode dtr1, IntNode dtr2, IntNode dtr3) {
        this.add(out1, dtr1);
        this.add(out2, dtr2);
        this.add(out3, dtr3);
    }

    @Override
    public DtrMap prune(int minCount) {
        Iterator entryIt = this.entrySet().iterator();
        while (entryIt.hasNext()) {
            Map.Entry entry = entryIt.next();
            IntNode node = (IntNode)entry.getValue();
            if (node.count() < minCount) {
                entryIt.remove();
            }
            node.prune(minCount);
        }
        return this.reduce();
    }

    @Override
    public DtrMap rescale(double countMultiplier) {
        Iterator entryIt = this.entrySet().iterator();
        while (entryIt.hasNext()) {
            Map.Entry entry = entryIt.next();
            IntNode node = (IntNode)entry.getValue();
            node.rescale(countMultiplier);
            if (node.count() != 0) continue;
            entryIt.remove();
        }
        return this.reduce();
    }

    public DtrMap reduce() {
        if (this.size() == 0) {
            return DtrMap0.EMPTY_DTR_MAP;
        }
        if (this.size() == 1) {
            Iterator entryIt = this.entrySet().iterator();
            Map.Entry entry = entryIt.next();
            int token = (Integer)entry.getKey();
            IntNode node = (IntNode)entry.getValue();
            return new DtrMap1(token, node);
        }
        if (this.size() == 2) {
            Iterator entryIt = this.entrySet().iterator();
            Map.Entry entry1 = entryIt.next();
            int token1 = (Integer)entry1.getKey();
            IntNode node1 = (IntNode)entry1.getValue();
            Map.Entry entry2 = entryIt.next();
            int token2 = (Integer)entry2.getKey();
            IntNode node2 = (IntNode)entry2.getValue();
            return new DtrMap2(token1, token2, node1, node2);
        }
        return this;
    }

    @Override
    public int numExtensions() {
        return this.size();
    }

    private void add(int out, IntNode dtr) {
        this.put(out, dtr);
    }

    @Override
    public void toString(StringBuilder sb, int depth, SymbolTable st) {
        Iterator it = this.entrySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            if (i > 0) {
                AbstractNode.indent(sb, depth);
            }
            Map.Entry entry = it.next();
            Integer key = (Integer)entry.getKey();
            int tok = key;
            IntNode node = (IntNode)entry.getValue();
            if (st != null) {
                sb.append(IntNode.idToSymbol(tok, st));
            } else {
                sb.append(tok);
            }
            sb.append(": ");
            node.toString(sb, depth + 1, st);
            ++i;
        }
    }

    @Override
    public void addDtrs(List<IntNode> queue) {
        queue.addAll(this.values());
    }

    @Override
    public int dtrsTrieSize() {
        int size = 0;
        for (IntNode node : this.values()) {
            size += node.trieSize();
        }
        return size;
    }

    @Override
    public DtrMap incrementDtrs(int[] tokIndices, int start, int end) {
        if (start == end) {
            return this;
        }
        Integer tok = tokIndices[start];
        IntNode dtr = this.getNode(tok);
        if (dtr == null) {
            this.put(tok, new IntNode(tokIndices, start + 1, end));
        } else {
            dtr.increment(tokIndices, start + 1, end);
        }
        return this;
    }

    @Override
    public DtrMap incrementDtrs(int[] tokIndices, int start, int end, int count) {
        if (start == end) {
            return this;
        }
        Integer tok = tokIndices[start];
        IntNode dtr = this.getNode(tok);
        if (dtr == null) {
            this.put(tok, new IntNode(tokIndices, start + 1, end, count));
        } else {
            dtr.increment(tokIndices, start + 1, end, count);
        }
        return this;
    }

    @Override
    public DtrMap incrementSequence(int[] tokIndices, int start, int end, int count) {
        if (start == end) {
            return this;
        }
        Integer tok = tokIndices[start];
        IntNode dtr = this.getNode(tok);
        if (dtr == null) {
            this.put(tok, new IntNode(tokIndices, start + 1, end, count, false));
        } else {
            dtr.incrementSequence(tokIndices, start + 1, end, count);
        }
        return this;
    }

    @Override
    public IntNode getDtr(int tok) {
        return this.getNode(tok);
    }

    IntNode getNode(Integer tok) {
        return (IntNode)this.get(tok);
    }

    @Override
    public int[] integersFollowing() {
        int[] result = new int[this.keySet().size()];
        Iterator it = this.keySet().iterator();
        int i = 0;
        while (it.hasNext()) {
            result[i] = (Integer)it.next();
            ++i;
        }
        return result;
    }

    @Override
    public long extensionCount() {
        long extensionCount = 0L;
        for (IntNode node : this.values()) {
            extensionCount += (long)node.count();
        }
        return extensionCount;
    }
}

