/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.io;

import com.aliasi.util.Math;
import java.io.IOException;
import java.io.OutputStream;

public class BitOutput {
    private int mNextByte;
    private int mNextBitIndex;
    private final OutputStream mOut;
    private static final long ALL_ONES_LONG = -1L;
    private static final boolean[] FIB_BUF = new boolean[Math.FIBONACCI_SEQUENCE.length + 1];
    private static final byte ZERO_BYTE = 0;

    public BitOutput(OutputStream out) {
        this.mOut = out;
        this.reset();
    }

    public void writeUnary(int n) throws IOException {
        BitOutput.validatePositive(n);
        int numZeros = n - 1;
        if (numZeros <= this.mNextBitIndex) {
            this.mNextByte <<= numZeros;
            this.mNextBitIndex -= numZeros;
            this.writeTrue();
            return;
        }
        this.mOut.write(this.mNextByte << this.mNextBitIndex);
        numZeros -= this.mNextBitIndex + 1;
        this.reset();
        while (numZeros >= 8) {
            this.mOut.write(0);
            numZeros -= 8;
        }
        this.mNextBitIndex -= numZeros;
        this.writeTrue();
    }

    public void writeBinary(long n, int numBits) throws IOException {
        BitOutput.validateNonNegative(n);
        BitOutput.validateNumBits(numBits);
        int k = BitOutput.mostSignificantPowerOfTwo(n);
        if (k >= numBits) {
            String msg = "Number will not fit into number of bits. n=" + n + " numBits=" + numBits;
            throw new IllegalArgumentException(msg);
        }
        this.writeLowOrderBits(numBits, n);
    }

    public void writeRice(long n, int numFixedBits) throws IOException {
        BitOutput.validatePositive(n);
        BitOutput.validateNumBits(numFixedBits);
        long q = n - 1L >> numFixedBits;
        long prefixBits = q + 1L;
        if (prefixBits >= Integer.MAX_VALUE) {
            String msg = "Prefix too long to code. n=" + n + " numFixedBits=" + numFixedBits + " number of prefix bits=(n>>numFixBits)=" + prefixBits;
            throw new IllegalArgumentException(msg);
        }
        this.writeUnary((int)prefixBits);
        long remainder = n - (q << numFixedBits) - 1L;
        this.writeLowOrderBits(numFixedBits, remainder);
    }

    public void writeFibonacci(long n) throws IOException {
        int mostSigPlace;
        BitOutput.validatePositive(n);
        long[] fibs = Math.FIBONACCI_SEQUENCE;
        boolean[] buf = FIB_BUF;
        for (int place = mostSigPlace = BitOutput.mostSigFibonacci(fibs, n); place >= 0; --place) {
            if (n >= fibs[place]) {
                n -= fibs[place];
                buf[place] = true;
                continue;
            }
            buf[place] = false;
        }
        for (int i = 0; i <= mostSigPlace; ++i) {
            this.writeBit(buf[i]);
        }
        this.writeTrue();
    }

    public void writeGamma(long n) throws IOException {
        BitOutput.validatePositive(n);
        if (n == 1L) {
            this.writeTrue();
            return;
        }
        int k = BitOutput.mostSignificantPowerOfTwo(n);
        this.writeUnary(k + 1);
        this.writeLowOrderBits(k, n);
    }

    public void writeDelta(long n) throws IOException {
        BitOutput.validatePositive(n);
        int numBits = BitOutput.mostSignificantPowerOfTwo(n);
        if (numBits > 63) {
            throw new IOException("numBits too large=" + numBits);
        }
        this.writeGamma(numBits + 1);
        if (numBits > 0) {
            this.writeLowOrderBits(numBits, n);
        }
    }

    public void close() throws IOException {
        this.flush();
        this.mOut.close();
    }

    public void flush() throws IOException {
        if (this.mNextBitIndex < 7) {
            this.mOut.write(this.mNextByte << this.mNextBitIndex);
            this.reset();
        }
        this.mOut.flush();
    }

    public void writeBit(boolean bit) throws IOException {
        if (bit) {
            this.writeTrue();
        } else {
            this.writeFalse();
        }
    }

    public void writeTrue() throws IOException {
        if (this.mNextBitIndex == 0) {
            this.mOut.write(this.mNextByte | 1);
            this.reset();
        } else {
            this.mNextByte = (this.mNextByte | 1) << 1;
            --this.mNextBitIndex;
        }
    }

    public void writeFalse() throws IOException {
        if (this.mNextBitIndex == 0) {
            this.mOut.write(this.mNextByte);
            this.reset();
        } else {
            this.mNextByte <<= 1;
            --this.mNextBitIndex;
        }
    }

    private void writeLowOrderBits(int numBits, long n) throws IOException {
        if (this.mNextBitIndex >= numBits) {
            this.mNextByte = (this.mNextByte << numBits - 1 | (int)BitOutput.leastSignificantBits2(n, numBits)) << 1;
            this.mNextBitIndex -= numBits;
            return;
        }
        this.mOut.write(this.mNextByte << this.mNextBitIndex | (int)BitOutput.sliceBits2(n, numBits -= this.mNextBitIndex + 1, this.mNextBitIndex + 1));
        while (numBits >= 8) {
            this.mOut.write((int)BitOutput.sliceBits2(n, numBits -= 8, 8));
        }
        if (numBits == 0) {
            this.reset();
            return;
        }
        this.mNextByte = (int)BitOutput.leastSignificantBits2(n, numBits) << 1;
        this.mNextBitIndex = 7 - numBits;
    }

    private void reset() {
        this.mNextByte = 0;
        this.mNextBitIndex = 7;
    }

    public static long leastSignificantBits(long n, int numBits) {
        if (numBits < 1 || numBits > 64) {
            String msg = "Number of bits must be between 1 and 64 inclusive. Found numBits=" + numBits;
            throw new IllegalArgumentException(msg);
        }
        return BitOutput.leastSignificantBits2(n, numBits);
    }

    public static long sliceBits(long n, int leastSignificantBit, int numBits) {
        if (leastSignificantBit < 0 || leastSignificantBit > 63) {
            String msg = "Least significant bit must be between 0 and 63. Found leastSignificantBit=" + leastSignificantBit;
            throw new IllegalArgumentException(msg);
        }
        if (numBits < 1 || numBits > 64) {
            String msg = "Number of bits must be between 1 and 64 inclusive. Found numBits=" + numBits;
            throw new IllegalArgumentException(msg);
        }
        return BitOutput.sliceBits2(n, leastSignificantBit, numBits);
    }

    static long leastSignificantBits2(long n, int numBits) {
        return -1L >>> 64 - numBits & n;
    }

    static long sliceBits2(long n, int leastSignificantBit, int numBits) {
        return BitOutput.leastSignificantBits2(n >>> leastSignificantBit, numBits);
    }

    public static int mostSignificantPowerOfTwo(long n) {
        int sum;
        int n2 = sum = n >> 32 != 0L ? 32 : 0;
        if (n >> (sum | 0x10) != 0L) {
            sum |= 0x10;
        }
        if (n >> (sum | 8) != 0L) {
            sum |= 8;
        }
        if (n >> (sum | 4) != 0L) {
            sum |= 4;
        }
        if (n >> (sum | 2) != 0L) {
            sum |= 2;
        }
        return n >> (sum | 1) != 0L ? sum | 1 : sum;
    }

    static int mostSigFibonacci(long[] fibs, long n) {
        int low = 0;
        int high = fibs.length - 1;
        while (low <= high) {
            int mid = (low + high) / 2;
            if (fibs[mid] < n) {
                low = low == mid ? mid + 1 : mid;
                continue;
            }
            if (fibs[mid] > n) {
                high = high == mid ? mid - 1 : mid;
                continue;
            }
            return mid;
        }
        return low - 1;
    }

    static void validateNumBits(int numBits) {
        if (numBits > 0) {
            return;
        }
        String msg = "Number of bits must be positive. Found numBits=" + numBits;
        throw new IllegalArgumentException(msg);
    }

    static void validatePositive(long n) {
        if (n > 0L) {
            return;
        }
        String msg = "Require number greater than zero. Found n=" + n;
        throw new IllegalArgumentException(msg);
    }

    static void validateNonNegative(long n) {
        if (n >= 0L) {
            return;
        }
        String msg = "Require non-negative number. Found n=" + n;
        throw new IllegalArgumentException(msg);
    }
}

