/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.corpus;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.Chunking;
import com.aliasi.corpus.ChunkTagHandlerAdapter;
import com.aliasi.corpus.ObjectHandler;
import com.aliasi.corpus.TagHandler;
import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public class ChunkHandlerAdapter
implements ObjectHandler<Chunking> {
    private final TokenizerFactory mTokenizerFactory;
    private TagHandler mTagHandler;
    private boolean mValidateTokenizer;
    static final Chunk[] EMPTY_CHUNK_ARRAY = new Chunk[0];

    @Deprecated
    public ChunkHandlerAdapter(TagHandler tagHandler, TokenizerFactory tokenizerFactory, boolean validateTokenizer) {
        this(tokenizerFactory, validateTokenizer);
        this.mTagHandler = tagHandler;
    }

    public ChunkHandlerAdapter(TokenizerFactory tokenizerFactory, boolean validateTokenizer) {
        this.mTokenizerFactory = tokenizerFactory;
        this.mValidateTokenizer = validateTokenizer;
    }

    @Deprecated
    public void setTagHandler(TagHandler tagHandler) {
        this.mTagHandler = tagHandler;
    }

    public void setValidateTokenizer(boolean validateTokenizer) {
        this.mValidateTokenizer = validateTokenizer;
    }

    @Override
    public void handle(Chunking chunking) {
        CharSequence cSeq = chunking.charSequence();
        char[] cs = Strings.toCharArray(cSeq);
        Set<Chunk> chunkSet = chunking.chunkSet();
        Chunk[] chunks = chunkSet.toArray(EMPTY_CHUNK_ARRAY);
        Arrays.sort(chunks, Chunk.TEXT_ORDER_COMPARATOR);
        ArrayList<String> tokenList = new ArrayList<String>();
        ArrayList<String> whiteList = new ArrayList<String>();
        ArrayList<String> tagList = new ArrayList<String>();
        int pos = 0;
        for (Chunk nextChunk : chunks) {
            String type = nextChunk.type();
            int start = nextChunk.start();
            int end = nextChunk.end();
            ChunkHandlerAdapter.outTag(cs, pos, start, tokenList, whiteList, tagList, this.mTokenizerFactory);
            ChunkHandlerAdapter.chunkTag(cs, start, end, type, tokenList, whiteList, tagList, this.mTokenizerFactory);
            pos = end;
        }
        ChunkHandlerAdapter.outTag(cs, pos, cSeq.length(), tokenList, whiteList, tagList, this.mTokenizerFactory);
        String[] toks = tokenList.toArray(Strings.EMPTY_STRING_ARRAY);
        String[] whites = whiteList.toArray(Strings.EMPTY_STRING_ARRAY);
        String[] tags = tagList.toArray(Strings.EMPTY_STRING_ARRAY);
        if (this.mValidateTokenizer && !ChunkHandlerAdapter.consistentTokens(toks, whites, this.mTokenizerFactory)) {
            String msg = "Tokens not consistent with tokenizer factory. Tokens=" + Arrays.asList(toks) + " Tokenization=" + this.tokenization(toks, whites) + " Factory class=" + this.mTokenizerFactory.getClass();
            throw new IllegalArgumentException(msg);
        }
        this.mTagHandler.handle(toks, whites, tags);
    }

    public static String[] toTags(Chunking chunking, TokenizerFactory factory) {
        CharSequence cSeq = chunking.charSequence();
        char[] cs = Strings.toCharArray(cSeq);
        Set<Chunk> chunkSet = chunking.chunkSet();
        Chunk[] chunks = chunkSet.toArray(EMPTY_CHUNK_ARRAY);
        Arrays.sort(chunks, Chunk.TEXT_ORDER_COMPARATOR);
        ArrayList<String> tokenList = new ArrayList<String>();
        ArrayList<String> whiteList = new ArrayList<String>();
        ArrayList<String> tagList = new ArrayList<String>();
        int pos = 0;
        for (Chunk nextChunk : chunks) {
            String type = nextChunk.type();
            int start = nextChunk.start();
            int end = nextChunk.end();
            ChunkHandlerAdapter.outTag(cs, pos, start, tokenList, whiteList, tagList, factory);
            ChunkHandlerAdapter.chunkTag(cs, start, end, type, tokenList, whiteList, tagList, factory);
            pos = end;
        }
        ChunkHandlerAdapter.outTag(cs, pos, cSeq.length(), tokenList, whiteList, tagList, factory);
        return tagList.toArray(Strings.EMPTY_STRING_ARRAY);
    }

    public static boolean consistentTokens(String[] toks, String[] whitespaces, TokenizerFactory tokenizerFactory) {
        if (toks.length + 1 != whitespaces.length) {
            return false;
        }
        char[] cs = ChunkHandlerAdapter.getChars(toks, whitespaces);
        Tokenizer tokenizer = tokenizerFactory.tokenizer(cs, 0, cs.length);
        String nextWhitespace = tokenizer.nextWhitespace();
        if (!whitespaces[0].equals(nextWhitespace)) {
            return false;
        }
        for (int i = 0; i < toks.length; ++i) {
            String token = tokenizer.nextToken();
            if (token == null) {
                return false;
            }
            if (!toks[i].equals(token)) {
                return false;
            }
            nextWhitespace = tokenizer.nextWhitespace();
            if (whitespaces[i + 1].equals(nextWhitespace)) continue;
            return false;
        }
        return true;
    }

    @Deprecated
    static void outTag(char[] cs, int start, int end, List<String> tokenList, List<String> whiteList, List<String> tagList, TokenizerFactory factory) {
        String nextToken;
        Tokenizer tokenizer = factory.tokenizer(cs, start, end - start);
        whiteList.add(tokenizer.nextWhitespace());
        while ((nextToken = tokenizer.nextToken()) != null) {
            tokenList.add(nextToken);
            tagList.add(ChunkTagHandlerAdapter.OUT_TAG);
            whiteList.add(tokenizer.nextWhitespace());
        }
    }

    @Deprecated
    static void chunkTag(char[] cs, int start, int end, String type, List<String> tokenList, List<String> whiteList, List<String> tagList, TokenizerFactory factory) {
        Tokenizer tokenizer = factory.tokenizer(cs, start, end - start);
        String firstToken = tokenizer.nextToken();
        tokenList.add(firstToken);
        tagList.add(ChunkTagHandlerAdapter.BEGIN_TAG_PREFIX + type);
        while (true) {
            String nextWhitespace = tokenizer.nextWhitespace();
            String nextToken = tokenizer.nextToken();
            if (nextToken == null) break;
            tokenList.add(nextToken);
            whiteList.add(nextWhitespace);
            tagList.add(ChunkTagHandlerAdapter.IN_TAG_PREFIX + type);
        }
    }

    List<String> tokenization(String[] toks, String[] whitespaces) {
        ArrayList<String> tokList = new ArrayList<String>();
        ArrayList whiteList = new ArrayList();
        char[] cs = ChunkHandlerAdapter.getChars(toks, whitespaces);
        Tokenizer tokenizer = this.mTokenizerFactory.tokenizer(cs, 0, cs.length);
        tokenizer.tokenize(tokList, whiteList);
        return tokList;
    }

    static char[] getChars(String[] toks, String[] whitespaces) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < toks.length; ++i) {
            sb.append(whitespaces[i]);
            sb.append(toks[i]);
        }
        sb.append(whitespaces[whitespaces.length - 1]);
        return Strings.toCharArray(sb);
    }
}

