/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Scanner;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Pattern;
import tsg.TSNode;
import util.Binomials;
import util.FileUtil;
import util.NAirs;

public class Utility {
    public static NAirs Nair = new NAirs(10, false);
    public static NAirs NairAdj = new NAirs(10, true);
    public static Binomials Bino = new Binomials(10, false);
    public static Binomials BinoAdj = new Binomials(10, true);

    public static String fillTab(int n) {
        return Utility.fillChar(n, '\t');
    }

    public static String fsb(int n, String s) {
        return String.valueOf(Utility.fillChar(n - s.length(), ' ')) + s;
    }

    public static String fse(int n, String s) {
        return String.valueOf(s) + Utility.fillChar(n - s.length(), ' ');
    }

    public static String padZero(int n, int i) {
        String s = Integer.toString(i);
        return String.valueOf(Utility.fillChar(n - s.length(), '0')) + s;
    }

    public static String fca(int n, String s, char c) {
        int repBeginning = (n - s.length()) / 2;
        int repEnd = n - s.length() - repBeginning;
        return String.valueOf(Utility.fillChar(repBeginning, c)) + s + Utility.fillChar(repEnd, c);
    }

    public static String fillChar(int n, char c) {
        String result = "";
        int i = 0;
        while (i < n) {
            result = String.valueOf(result) + c;
            ++i;
        }
        return result;
    }

    public static <T> boolean increaseInTableInteger(Hashtable<T, Integer> table, T key, int toAdd) {
        Integer count = table.get(key);
        boolean newKey = count == null;
        count = newKey ? toAdd : count + toAdd;
        table.put(key, count);
        return newKey;
    }

    public static <T> void increaseInTableInt(Hashtable<T, int[]> table, T key) {
        int[] count = table.get(key);
        if (count == null) {
            count = new int[]{1};
            table.put(key, count);
        } else {
            count[0] = count[0] + 1;
        }
    }

    public static <T> void increaseInTableLong(Hashtable<T, long[]> table, T key) {
        long[] count = table.get(key);
        if (count == null) {
            count = new long[]{1L};
            table.put(key, count);
        } else {
            count[0] = count[0] + 1L;
        }
    }

    public static <T> void increaseInTableInt(Hashtable<T, int[]> table, T key, int toAdd) {
        int[] count = table.get(key);
        if (count == null) {
            count = new int[]{toAdd};
            table.put(key, count);
        } else {
            count[0] = count[0] + toAdd;
        }
    }

    public static <T> void increaseInTableDoubleArray(Hashtable<T, double[]> table, T key, double toAdd) {
        double[] count = table.get(key);
        if (count == null) {
            count = new double[]{toAdd};
            table.put(key, count);
        } else {
            count[0] = count[0] + toAdd;
        }
    }

    public static <T> void increaseInTableDoubleLogArray(Hashtable<T, double[]> table, T key, double toAdd) {
        double[] count = table.get(key);
        if (count == null) {
            count = new double[]{toAdd};
            table.put(key, count);
        } else {
            count[0] = Utility.logSum(count[0], toAdd);
        }
    }

    public static <T> void increaseInTableBigDecimalArray(Hashtable<T, BigDecimal[]> table, T key, BigDecimal toAdd) {
        BigDecimal[] count = table.get(key);
        if (count == null) {
            count = new BigDecimal[]{toAdd};
            table.put(key, count);
        } else {
            count[0] = count[0].add(toAdd);
        }
    }

    public static <T> boolean increaseInTableDouble(Hashtable<T, Double> table, T key, double toAdd) {
        Double count = table.get(key);
        boolean newKey = count == null;
        count = newKey ? toAdd : count + toAdd;
        table.put(key, count);
        return newKey;
    }

    public static <T> boolean increaseInTableLong(Hashtable<T, Long> table, T key, long toAdd) {
        Long count = table.get(key);
        boolean newKey = count == null;
        count = newKey ? toAdd : count + toAdd;
        table.put(key, count);
        return newKey;
    }

    public static <T> void removeInTable(Hashtable<T, Integer> table, int limit) {
        Iterator<Integer> i = table.values().iterator();
        while (i.hasNext()) {
            Integer freq = i.next();
            if (freq > limit) continue;
            i.remove();
        }
    }

    public static <T, S> void printHashTable(Hashtable<T, S> table) {
        for (T key : table.keySet()) {
            System.out.println(key + "\t" + table.get(key));
        }
    }

    public static <T> void printHashTableInt(Hashtable<T, int[]> table) {
        for (T key : table.keySet()) {
            System.out.println(key + "\t" + table.get(key)[0]);
        }
    }

    public static boolean increaseStringInteger(Hashtable table, String key, int toAdd) {
        Integer count = (Integer)table.get(key);
        boolean newKey = count == null;
        count = newKey ? Integer.valueOf(toAdd) : Integer.valueOf(count + toAdd);
        table.put(key, count);
        return newKey;
    }

    public static int countTotalTypesInTable(Hashtable<? extends Object, Integer> table) {
        return table.keySet().size();
    }

    public static int countTotalTokensInTable(Hashtable<? extends Object, Integer> table) {
        int totalTokens = 0;
        for (Object object : table.keySet()) {
            totalTokens += table.get(object).intValue();
        }
        return totalTokens;
    }

    public static IdentityHashMap<Integer, String> reverseStringIntegerTable(Hashtable<String, Integer> table) {
        IdentityHashMap<Integer, String> result = new IdentityHashMap<Integer, String>();
        for (Map.Entry<String, Integer> tuple : table.entrySet()) {
            result.put(new Integer(tuple.getValue()), tuple.getKey());
        }
        return result;
    }

    public static void increaseStringIntArray(Hashtable<String, int[]> table, int arraySize, String key, int index, int toAdd) {
        int[] stat = table.get(key);
        if (stat == null) {
            stat = new int[arraySize];
            table.put(key, stat);
        }
        int n = index;
        stat[n] = stat[n] + 1;
    }

    public static void increaseStringDoubleArray(Hashtable<String, double[]> table, String key, double toAdd) {
        double[] stat = table.get(key);
        if (stat == null) {
            stat = new double[]{toAdd};
            table.put(key, stat);
            return;
        }
        stat[0] = stat[0] + toAdd;
    }

    public static String getMaxKey(Hashtable<String, double[]> table) {
        double max = -1.7976931348623157E308;
        String maxKey = null;
        for (Map.Entry<String, double[]> e : table.entrySet()) {
            double stat = e.getValue()[0];
            if (!(stat > max)) continue;
            max = stat;
            maxKey = e.getKey();
        }
        return maxKey;
    }

    public static boolean increaseStringIntArray(Hashtable<String, int[]> table, String key) {
        int[] freq = table.get(key);
        if (freq == null) {
            freq = new int[]{1};
            table.put(key, freq);
            return true;
        }
        freq[0] = freq[0] + 1;
        return false;
    }

    public static void increaseStringIntArray(Hashtable<String, int[]> table, String key, int toAdd) {
        int[] freq = table.get(key);
        if (freq == null) {
            freq = new int[]{toAdd};
            table.put(key, freq);
        } else {
            freq[0] = freq[0] + toAdd;
        }
    }

    public static boolean increaseStringLong(Hashtable<String, Long> table, String key, long toAdd) {
        Long count = table.get(key);
        boolean newKey = count == null;
        count = newKey ? new Long(toAdd) : new Long(count + toAdd);
        table.put(key, count);
        return newKey;
    }

    public static boolean increaseStringDouble(Hashtable<String, Double> table, String key, double weight) {
        Double count = table.get(key);
        boolean newKey = count == null;
        count = newKey ? new Double(weight) : new Double(count + weight);
        table.put(key, count);
        return newKey;
    }

    public static boolean increaseIntegerListInteger(Hashtable<ArrayList<Integer>, Integer> table, ArrayList<Integer> key, int toAdd) {
        Integer count = table.get(key);
        boolean newKey = count == null;
        count = newKey ? new Integer(toAdd) : new Integer(count + toAdd);
        table.put(key, count);
        return newKey;
    }

    public static void decreaseStringInteger(Hashtable<String, Integer> table, String key, int weight) {
        int count = table.get(key);
        if ((count -= weight) <= 0) {
            table.remove(key);
        } else {
            table.put(key, count);
        }
    }

    public static void decreaseStringLong(Hashtable<String, Long> table, String key, long weight) {
        long count = table.get(key);
        if ((count -= weight) <= 0L) {
            table.remove(key);
        } else {
            table.put(key, count);
        }
    }

    public static void decreaseStringDouble(Hashtable<String, Double> table, String key, double weight) {
        double count = table.get(key);
        if ((count -= weight) <= 0.0) {
            table.remove(key);
        } else {
            table.put(key, new Double(count));
        }
    }

    public static void putTreeNodeMark(IdentityHashMap<TSNode, TreeSet<Integer>> markTable, TSNode TN, Integer mark) {
        TreeSet<Integer> markRecord = markTable.get(TN);
        if (markRecord == null) {
            markRecord = new TreeSet();
            markTable.put(TN, markRecord);
        }
        markRecord.add(mark);
    }

    public static void putStringDoubleFromToTable(String[] key, Hashtable<String, Double> originTable, Hashtable<String, Double> destinationTable) {
        int i = 0;
        while (i < key.length) {
            String tree = key[i];
            Double count = originTable.get(tree);
            if (count != null) {
                destinationTable.put(tree, count);
            }
            ++i;
        }
    }

    public static void putStringIntegerFromToTable(String[] key, Hashtable<String, Integer> originTable, Hashtable<String, Integer> destinationTable) {
        int i = 0;
        while (i < key.length) {
            String tree = key[i];
            Integer count = originTable.get(tree);
            if (count != null) {
                destinationTable.put(tree, count);
            }
            ++i;
        }
    }

    public static void arrayIntPlus(int[] source, int[] destination) {
        int i = 0;
        while (i < destination.length) {
            int n = i;
            destination[n] = destination[n] + source[i];
            ++i;
        }
    }

    public static int[] arrayListIntegerToArray(List<Integer> list) {
        int[] result = new int[list.size()];
        int i = 0;
        while (i < list.size()) {
            result[i] = list.get(i);
            ++i;
        }
        return result;
    }

    public static void addToAll(int[] array, int toAdd) {
        int i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = array[n] + toAdd;
        }
    }

    public static void increaseAllStringDoubleFromToTable(Hashtable<String, Double> originTable, Hashtable<String, Double> destinationTable) {
        Enumeration<String> e = originTable.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            Double toAdd = originTable.get(key);
            if (toAdd == null) continue;
            Double originalCount = destinationTable.get(key);
            originalCount = originalCount == null ? toAdd : new Double(originalCount + toAdd);
            destinationTable.put(key, originalCount);
        }
    }

    public static void decreaseAllStringDoubleFromToTable(Hashtable<String, Double> originTable, Hashtable<String, Double> destinationTable) {
        Enumeration<String> e = originTable.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            Double toAdd = originTable.get(key);
            Double originalCount = destinationTable.get(key);
            if ((originalCount = new Double(originalCount - toAdd)) == 0.0) {
                destinationTable.remove(key);
                continue;
            }
            destinationTable.put(key, originalCount);
        }
    }

    public static Hashtable<String, Double> keepInTable(Hashtable<String, Double> origin, Hashtable<String, Double> table1, Hashtable<String, Double> table2) {
        Double value;
        String key;
        Hashtable<String, Double> result = new Hashtable<String, Double>();
        Enumeration<String> e = table1.keys();
        while (e.hasMoreElements()) {
            key = e.nextElement();
            value = origin.get(key);
            if (value == null) {
                value = new Double(0.0);
            }
            result.put(key, value);
        }
        e = table2.keys();
        while (e.hasMoreElements()) {
            key = e.nextElement();
            value = origin.get(key);
            if (value == null) {
                value = new Double(0.0);
            }
            result.put(key, value);
        }
        return result;
    }

    public static void addAll(Hashtable<String, Integer> partialRules, Hashtable<String, Integer> Rules) {
        Enumeration<String> e = partialRules.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            Integer partialCount = partialRules.get(key);
            Integer count = Rules.get(key);
            if (count == null) {
                count = new Integer(0);
            }
            int newCount = count + partialCount;
            Rules.put(key, new Integer(newCount));
        }
    }

    public static void addAllDuets(Hashtable<String, Integer[]> partialRules, Hashtable<String, Integer[]> Rules, boolean removeUniqueIndex) {
        Enumeration<String> e = partialRules.keys();
        while (e.hasMoreElements()) {
            Integer[] count;
            String key = e.nextElement();
            Integer[] partialCount = partialRules.get(key);
            if (removeUniqueIndex) {
                key = key.replaceAll("@\\d+", "");
            }
            if ((count = Rules.get(key)) == null) {
                Rules.put(key, partialCount);
                continue;
            }
            count[0] = new Integer(count[0] + partialCount[0]);
            count[1] = new Integer(count[1] + partialCount[1]);
        }
    }

    public static void printTime() {
        Date now = new Date();
        System.out.println(now);
    }

    public static boolean stringMatches(String s, String[] match) {
        int i = 0;
        while (i < match.length) {
            if (s.equals(match[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int randomInteger(int max) {
        return (int)(Math.random() * (double)max);
    }

    public static float randomNoise(float value, float maxNoise) {
        return (float)(Math.random() * 2.0 * (double)maxNoise - (double)maxNoise + (double)value);
    }

    public static boolean randomBoolean() {
        return Math.random() > 0.5;
    }

    public static void increaseAllOne(int[] a) {
        int i = 0;
        while (i < a.length) {
            int n = i++;
            a[n] = a[n] + 1;
        }
    }

    public static int[][][][] multiCombinations(int[] list) {
        int length = list.length;
        int[][] sizeChoices = Utility.combinations(list);
        int sizeChoicesLength = sizeChoices.length;
        int[][][][] result = new int[sizeChoicesLength][][][];
        int i = 0;
        while (i < sizeChoicesLength) {
            int[] sizeChoice = sizeChoices[i];
            Utility.increaseOne(sizeChoice);
            int[] sizeBino = Utility.makeSizeBino(list, sizeChoice);
            int[][] partialResult = Utility.combinations(sizeBino);
            int partialResultLength = partialResult.length;
            result[i] = new int[partialResultLength][length][];
            int j = 0;
            while (j < partialResultLength) {
                int l = 0;
                while (l < length) {
                    int nairIndex = partialResult[j][l];
                    result[i][j][l] = Nair.get(list[l], sizeChoice[l])[nairIndex];
                    ++l;
                }
                ++j;
            }
            ++i;
        }
        return result;
    }

    public static int[] makeSizeBino(int[] list, int[] sizeChoices) {
        int[] result = new int[list.length];
        int i = 0;
        while (i < list.length) {
            result[i] = Bino.get(list[i], sizeChoices[i]);
            ++i;
        }
        return result;
    }

    public static void increaseOne(int[] list) {
        int i = 0;
        while (i < list.length) {
            int n = i++;
            list[n] = list[n] + 1;
        }
    }

    public static int[][] combinations(int[] list) {
        int combinations = Utility.product(list);
        int[][] result = new int[combinations][list.length];
        if (list.length == 1) {
            int row = 0;
            int i = 0;
            while (i < list[0]) {
                result[row][0] = i++;
                ++row;
            }
            return result;
        }
        if (list.length == 2) {
            int row = 0;
            int i = 0;
            while (i < list[0]) {
                int j = 0;
                while (j < list[1]) {
                    result[row][0] = i;
                    result[row][1] = j++;
                    ++row;
                }
                ++i;
            }
            return result;
        }
        int[] newList = new int[list.length - 1];
        int i = 0;
        while (i < list.length - 1) {
            newList[i] = list[i];
            ++i;
        }
        int[][] partialResult = Utility.combinations(newList);
        int row = 0;
        int i2 = 0;
        while (i2 < partialResult.length) {
            int k = 0;
            while (k < list[list.length - 1]) {
                int j = 0;
                while (j < list.length - 1) {
                    result[row][j] = partialResult[i2][j];
                    ++j;
                }
                result[row][list.length - 1] = k++;
                ++row;
            }
            ++i2;
        }
        return result;
    }

    public static int factorial(int n) {
        return Utility.factorial(1, n);
    }

    public static long factorialLong(long n) {
        return Utility.factorialLong(1L, n);
    }

    public static int factorial(int s, int e) {
        int result = s;
        int i = s + 1;
        while (i <= e) {
            result *= i;
            ++i;
        }
        return result;
    }

    public static long factorialLong(long s, long e) {
        long result = s;
        long i = s + 1L;
        while (i <= e) {
            result *= i;
            ++i;
        }
        return result;
    }

    public static int binomial(int c, int n) {
        if (n == 0 || n == c) {
            return 1;
        }
        if (n == 1 || n == c - 1) {
            return c;
        }
        if (n > c / 2) {
            return Utility.factorial(n + 1, c) / Utility.factorial(c - n);
        }
        return Utility.factorial(c - n + 1, c) / Utility.factorial(n);
    }

    public static int binomial_continuous(int c, int n) {
        return c - n + 1;
    }

    public static long binomialLong(long c, long n) {
        if (c == 0L || c == n) {
            return 1L;
        }
        if (c == 1L || c == n - 1L) {
            return n;
        }
        if (n > c / 2L) {
            return Utility.factorialLong(n + 1L, c) / Utility.factorialLong(c - n);
        }
        return Utility.factorialLong(c - n + 1L, c) / Utility.factorialLong(n);
    }

    public static int[][] n_air(int c, int n) {
        int combinations = Utility.binomial(c, n);
        int[][] result = new int[combinations][n];
        if (n == 1) {
            int row = 0;
            int i = 0;
            while (i < c) {
                result[row][0] = i++;
                ++row;
            }
            return result;
        }
        if (n == 2) {
            int row = 0;
            int i = 0;
            while (i < c) {
                int j = i + 1;
                while (j < c) {
                    result[row][0] = i;
                    result[row][1] = j++;
                    ++row;
                }
                ++i;
            }
            return result;
        }
        int[][] partialResult = Utility.n_air(c - 1, n - 1);
        int row = 0;
        int i = 0;
        while (i < partialResult.length) {
            int k = partialResult[i][n - 2] + 1;
            do {
                int j = 0;
                while (j < n - 1) {
                    result[row][j] = partialResult[i][j];
                    ++j;
                }
                result[row][n - 1] = k++;
                ++row;
            } while (k < c);
            ++i;
        }
        return result;
    }

    public static int[][] n_air_continuous(int c, int n) {
        int combinations = c - n + 1;
        int[][] result = new int[combinations][n];
        int s = 0;
        while (s < combinations) {
            int e = 0;
            while (e < n) {
                result[s][e] = s + e;
                ++e;
            }
            ++s;
        }
        return result;
    }

    public static int product(int[] array) {
        int result = array[0];
        int i = 1;
        while (i < array.length) {
            result *= array[i];
            ++i;
        }
        return result;
    }

    public static double product(double[] array) {
        double result = array[0];
        int i = 1;
        while (i < array.length) {
            result *= array[i];
            ++i;
        }
        return result;
    }

    public static long product(long[] array) {
        long result = array[0];
        int i = 1;
        while (i < array.length) {
            result *= array[i];
            ++i;
        }
        return result;
    }

    public static int countParenthesis(String line) {
        int result = 0;
        int i = 0;
        while (i < line.length()) {
            if (line.charAt(i) == '(') {
                ++result;
            } else if (line.charAt(i) == ')') {
                --result;
            }
            ++i;
        }
        return result;
    }

    public static int[] permutation(int n) {
        int[] result = new int[n];
        ArrayList<Integer> list = new ArrayList<Integer>();
        int i = 0;
        while (i < n) {
            list.add(new Integer(i));
            ++i;
        }
        Collections.shuffle(list);
        i = 0;
        while (i < n) {
            result[i] = (Integer)list.get(i);
            ++i;
        }
        return result;
    }

    public static String get_unique_root(String eTree) {
        return eTree.substring(eTree.indexOf(40) + 1, eTree.indexOf(32)).trim();
    }

    public static String getCFGcategory(String CFGRule) {
        return CFGRule.substring(0, CFGRule.indexOf(32));
    }

    public static void normalizenCFRulesOnCategory(Hashtable<String, Double> CFGrules, Hashtable<String, Double> CFGcategories) {
        Enumeration<String> e = CFGrules.keys();
        while (e.hasMoreElements()) {
            String rule = e.nextElement();
            String category = Utility.getCFGcategory(rule);
            double count_category = CFGcategories.get(category);
            double weight = CFGrules.get(rule) / count_category;
            CFGrules.put(rule, new Double(weight));
        }
    }

    public static void addAllCFGRules(LinkedList<String> rules, double count, Hashtable<String, Double> CFGRules, Hashtable<String, Double> CFGcategories, boolean prelexical, boolean lexical) {
        ListIterator j = rules.listIterator();
        while (j.hasNext()) {
            boolean isLex;
            String rule = (String)j.next();
            boolean bl = isLex = rule.indexOf(34) != -1;
            if (isLex && !lexical || !isLex && !prelexical) continue;
            if (CFGcategories != null) {
                String category = Utility.getCFGcategory(rule);
                Utility.increaseStringDouble(CFGcategories, category, count);
            }
            Utility.increaseStringDouble(CFGRules, rule, count);
        }
    }

    public static double pLogp(double weight) {
        if (weight == 0.0) {
            return 0.0;
        }
        return weight * Math.log(weight);
    }

    public static double getDouble(Object o) {
        if (o.getClass().isInstance(new Double(0.0))) {
            return (Double)o;
        }
        return ((Integer)o).doubleValue();
    }

    public static String cleanSlash(String s) {
        String result;
        int slash = 92;
        int index = s.lastIndexOf(slash);
        if (index == -1) {
            return s;
        }
        char symbol = s.charAt(index + 1);
        if (symbol == '$' || symbol == '\'' || symbol == '#' || symbol == '=') {
            result = index == 0 ? s.substring(1) : String.valueOf(s.substring(0, index)) + s.substring(index + 1);
            if (symbol == '/') {
                return result;
            }
        } else {
            return s;
        }
        return Utility.cleanSlash(result);
    }

    public static String replaceDoubleSlash(String s) {
        int index = s.indexOf("\\\\");
        if (index == -1) {
            return s;
        }
        return String.valueOf(s.substring(0, index)) + "\\" + s.substring(index + 2);
    }

    public static LinkedList<Object> extractRandomPercentage(LinkedList<Object> inputSet, double percentage) {
        LinkedList<Object> result = new LinkedList<Object>();
        int input_size = inputSet.size();
        int target_size = (int)((double)input_size * percentage);
        int actual_size = 0;
        while (actual_size < target_size) {
            int index = Utility.randomInteger(input_size);
            Object o = inputSet.remove(index);
            result.add(o);
            --input_size;
            ++actual_size;
        }
        return result;
    }

    public static int indexOf(Object o, Object[] array) {
        int i = 0;
        while (i < array.length) {
            if (array[i] == o) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int indexOf(int[] o, int[][] array) {
        int i = 0;
        while (i < array.length) {
            if (Arrays.equals(array[i], o)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int[] intArrayConversion(List<Integer> list) {
        int[] result = new int[list.size()];
        ListIterator<Integer> i = list.listIterator();
        while (i.hasNext()) {
            int interger;
            result[i.previousIndex()] = interger = i.next().intValue();
        }
        return result;
    }

    public static int[] appendIntArraySet(int[] array, int value) {
        if (array == null) {
            return new int[]{value};
        }
        int insertionPoint = Arrays.binarySearch(array, value);
        if (insertionPoint >= 0) {
            return array;
        }
        insertionPoint = -insertionPoint - 1;
        int[] newArray = new int[array.length + 1];
        int index = 0;
        while (index < insertionPoint) {
            newArray[index] = array[index];
            ++index;
        }
        newArray[index++] = value;
        while (index < newArray.length) {
            newArray[index] = array[index - 1];
            ++index;
        }
        return newArray;
    }

    public static boolean isPunctuation(String word) {
        return word.matches("[.,:;'`?!()]+");
    }

    public static boolean matchString(String key, String[] array) {
        Arrays.sort(array);
        return Arrays.binarySearch(array, key) >= 0;
    }

    public static String removeDoubleQuotes(String word) {
        return word.replaceAll("\"", "");
    }

    public static String booleanToOnOff(boolean value) {
        return value ? "on" : "off";
    }

    public static void removeOneToIntArray(int[] array) {
        int i = 0;
        while (i < array.length) {
            int n = i++;
            array[n] = array[n] - 1;
        }
    }

    public static boolean containsFalse(boolean[] array) {
        boolean[] blArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            boolean b = blArray[n2];
            if (!b) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String hashtableStringIntegerToString(Hashtable<String, Integer> table) {
        String result = "";
        Object[] keySet = table.keySet().toArray(new String[0]);
        Arrays.sort(keySet);
        Object[] objectArray = keySet;
        int n = keySet.length;
        int n2 = 0;
        while (n2 < n) {
            Object s = objectArray[n2];
            result = String.valueOf(result) + (String)s + "\t" + table.get(s) + "\n";
            ++n2;
        }
        return result;
    }

    public static void printListStandardOutput(List<? extends Object> list) {
        for (Object object : list) {
            System.out.println(object.toString());
        }
    }

    public static void hashtableOrderedToFile(Hashtable<String, Integer> table, File outputFile) {
        PrintWriter out = FileUtil.getPrintWriter(outputFile);
        IdentityHashMap<Integer, String> reversedTable = Utility.reverseStringIntegerTable(table);
        Object[] countSorted = reversedTable.keySet().toArray(new Integer[0]);
        Arrays.sort(countSorted);
        int i = countSorted.length - 1;
        while (i >= 0) {
            Object count = countSorted[i];
            String pair = reversedTable.get(count);
            out.println(String.valueOf(pair) + "\t" + count);
            --i;
        }
        out.println();
        out.close();
    }

    public static void hashtableRankedToFile(Hashtable<String, Integer> table, File outputFile) {
        PrintWriter out = FileUtil.getPrintWriter(outputFile);
        out.println("Rank\tFreq\tTokens\tTotalFreq");
        IdentityHashMap<Integer, String> reversedTable = Utility.reverseStringIntegerTable(table);
        Object[] countSorted = reversedTable.keySet().toArray(new Integer[0]);
        Arrays.sort(countSorted);
        int rank = 1;
        int rankFreq = (Integer)countSorted[countSorted.length - 1];
        int rankTokens = 0;
        int i = countSorted.length - 1;
        while (i >= 0) {
            Object count = countSorted[i];
            if ((Integer)count != rankFreq) {
                out.println(String.valueOf(rank) + "\t" + rankFreq + "\t" + rankTokens + "\t" + rankFreq * rankTokens);
                ++rank;
                rankFreq = (Integer)count;
                rankTokens = 0;
            }
            ++rankTokens;
            --i;
        }
        out.println(String.valueOf(rank) + "\t" + rankFreq + "\t" + rankTokens + "\t" + rankFreq * rankTokens);
        out.println();
        out.close();
    }

    public static int[] countIntegerListClasses(List<Integer> list, int binSize) {
        int max = Utility.maxIntegerList(list);
        int binNumber = max / binSize + 1;
        int[] result = new int[binNumber];
        for (Integer i : list) {
            int bin;
            int n = bin = i / binSize;
            result[n] = result[n] + 1;
        }
        return result;
    }

    public static String printIntegerListClasses(List<Integer> list, int binSize) {
        int[] classes = Utility.countIntegerListClasses(list, binSize);
        String result = "";
        int i = 0;
        while (i < classes.length) {
            int lowerBound = i * binSize;
            int upperBound = (i + 1) * binSize - 1;
            result = String.valueOf(result) + lowerBound + "-" + upperBound + "\t" + classes[i] + "\n";
            ++i;
        }
        return result;
    }

    public static int maxIntegerList(List<Integer> list) {
        int max = Integer.MIN_VALUE;
        for (Integer i : list) {
            if (i <= max) continue;
            max = i;
        }
        return max;
    }

    public static int maxIndex(int[] list) {
        int maxIndex = 0;
        int max = list[0];
        int i = 1;
        while (i < list.length) {
            if (list[i] > max) {
                maxIndex = i;
                max = list[i];
            }
            ++i;
        }
        return maxIndex;
    }

    public static int max(int[] list) {
        int max = list[0];
        int i = 1;
        while (i < list.length) {
            if (list[i] > max) {
                max = list[i];
            }
            ++i;
        }
        return max;
    }

    public static int min(int[] list) {
        int min = list[0];
        int i = 1;
        while (i < list.length) {
            if (list[i] < min) {
                min = list[i];
            }
            ++i;
        }
        return min;
    }

    public static void fillDoubleIntArray(int[][] array, int value) {
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[i].length) {
                array[i][j] = value;
                ++j;
            }
            ++i;
        }
    }

    public static void fillDoubleFloatArray(float[][] array, float value) {
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[i].length) {
                array[i][j] = value;
                ++j;
            }
            ++i;
        }
    }

    public static void printIntChart(int[][] array, String[] columnHeader, String[] rowHeader) {
        String result = "";
        int i = 0;
        while (i < columnHeader.length) {
            result = String.valueOf(result) + "\t" + columnHeader[i];
            ++i;
        }
        result = String.valueOf(result) + "\n";
        i = 0;
        while (i < array.length) {
            result = String.valueOf(result) + rowHeader[i];
            int j = 0;
            while (j < array[i].length) {
                result = String.valueOf(result) + "\t" + array[i][j];
                ++j;
            }
            result = String.valueOf(result) + "\n";
            ++i;
        }
        System.out.println(result);
    }

    public static void printFloatChart(float[][] array, String[] columnHeader, String[] rowHeader) {
        String result = "";
        int i = 0;
        while (i < columnHeader.length) {
            result = String.valueOf(result) + "\t" + columnHeader[i];
            ++i;
        }
        result = String.valueOf(result) + "\n";
        i = 0;
        while (i < array.length) {
            result = String.valueOf(result) + rowHeader[i];
            int j = 0;
            while (j < array[i].length) {
                result = String.valueOf(result) + "\t" + array[i][j];
                ++j;
            }
            result = String.valueOf(result) + "\n";
            ++i;
        }
        System.out.println(result);
    }

    public static void printFloatArray(float[][] array) {
        String result = "";
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[i].length) {
                result = String.valueOf(result) + "\t" + array[i][j];
                ++j;
            }
            result = String.valueOf(result) + "\n";
            ++i;
        }
        System.out.println(result);
    }

    public static void printIntArray(int[][] array) {
        if (array == null) {
            System.out.println("null");
            return;
        }
        String result = "";
        int i = 0;
        while (i < array.length) {
            int j = 0;
            while (j < array[i].length) {
                result = String.valueOf(result) + "\t" + array[i][j];
                ++j;
            }
            result = String.valueOf(result) + "\n";
            ++i;
        }
        System.out.println(result);
    }

    public static void printIntArray(int[][][][] array) {
        if (array == null) {
            System.out.println("null");
            return;
        }
        String result = "<\n";
        int i = 0;
        while (i < array.length) {
            result = String.valueOf(result) + "\t< ";
            int j = 0;
            while (j < array[i].length) {
                result = String.valueOf(result) + "<";
                int h = 0;
                while (h < array[i][j].length) {
                    result = String.valueOf(result) + "<";
                    int k = 0;
                    while (k < array[i][j][h].length) {
                        result = String.valueOf(result) + array[i][j][h][k];
                        if (k != array[i][j][h].length - 1) {
                            result = String.valueOf(result) + ",";
                        }
                        ++k;
                    }
                    result = String.valueOf(result) + (h != array[i][j].length - 1 ? ">," : ">");
                    ++h;
                }
                result = String.valueOf(result) + (j != array[i].length - 1 ? ">, " : ">");
                ++j;
            }
            result = String.valueOf(result) + " >\n";
            ++i;
        }
        result = String.valueOf(result) + ">\n";
        System.out.println(result);
    }

    public static int[][] split(int n) {
        int[][] result = new int[n - 1][2];
        int row = 0;
        int i = 1;
        while (i < n) {
            result[row][0] = i;
            result[row][1] = n - i;
            ++row;
            ++i;
        }
        return result;
    }

    public static int[] parseIndexList(String[] words) {
        int[] result = new int[words.length];
        int i = 0;
        while (i < words.length) {
            result[i] = Integer.parseInt(words[i]);
            ++i;
        }
        return result;
    }

    public static void tartaglia() {
        int i = 1;
        while (i < Integer.MAX_VALUE) {
            int j = 1;
            while (j <= i) {
                System.out.print(String.valueOf(Utility.binomial(i, j)) + "\t");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    public static boolean greaterThan(int[] a, int[] b) {
        int length = a.length;
        boolean foundGreater = false;
        int i = length - 1;
        while (i > -1) {
            if (a[i] < b[i]) {
                return false;
            }
            if (a[i] > b[i]) {
                foundGreater = true;
            }
            --i;
        }
        return foundGreater;
    }

    public static boolean allZero(int[] a) {
        int[] nArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            int ai = nArray[n2];
            if (ai != 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean allZero(float[] a) {
        float[] fArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            float ai = fArray[n2];
            if (ai != 0.0f) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean allZero(double[] a) {
        double[] dArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            double ai = dArray[n2];
            if (ai != 0.0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean greaterThan(float[] a, float[] b) {
        int length = a.length;
        boolean foundGreater = false;
        int i = length - 1;
        while (i > -1) {
            if (a[i] < b[i]) {
                return false;
            }
            if (a[i] > b[i]) {
                foundGreater = true;
            }
            --i;
        }
        return foundGreater;
    }

    public static boolean greaterThan(double[] a, double[] b) {
        int length = a.length;
        boolean foundGreater = false;
        int i = 0;
        while (i < length) {
            if (a[i] < b[i]) {
                return false;
            }
            if (a[i] > b[i]) {
                foundGreater = true;
            }
            ++i;
        }
        return foundGreater;
    }

    public static boolean greaterThanPriority(double[] a, double[] b) {
        int length = a.length;
        int i = 0;
        while (i < length) {
            if (a[i] < b[i]) {
                return false;
            }
            if (a[i] > b[i]) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static int[] concat(int[] a, int[] b) {
        int[] result = new int[a.length + b.length];
        int i = 0;
        int[] nArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            int ai;
            result[i] = ai = nArray[n2];
            ++i;
            ++n2;
        }
        nArray = b;
        n = b.length;
        n2 = 0;
        while (n2 < n) {
            int bi;
            result[i] = bi = nArray[n2];
            ++i;
            ++n2;
        }
        return result;
    }

    public static int[] concat(int a, int[] b) {
        int[] result = new int[b.length + 1];
        result[0] = a;
        int i = 1;
        int[] nArray = b;
        int n = b.length;
        int n2 = 0;
        while (n2 < n) {
            int bi;
            result[i] = bi = nArray[n2];
            ++i;
            ++n2;
        }
        return result;
    }

    public static int[] concat(int[] a, int b) {
        int[] result = new int[a.length + 1];
        int i = 0;
        int[] nArray = a;
        int n = a.length;
        int n2 = 0;
        while (n2 < n) {
            int ai;
            result[i] = ai = nArray[n2];
            ++i;
            ++n2;
        }
        result[i] = b;
        return result;
    }

    public static double getCondProb(Hashtable<String, Integer> freqTable, Hashtable<String, Integer> condFreqTable, String key, String condKey) {
        Integer keyFreq = freqTable.get(key);
        if (keyFreq == null) {
            return 0.0;
        }
        Integer keyCondFreq = condFreqTable.get(condKey);
        return (double)keyFreq.intValue() / (double)keyCondFreq.intValue();
    }

    public static String joinStringArrayToString(String[] array, String separator) {
        if (array.length == 0) {
            return "";
        }
        String result = array[0];
        int i = 1;
        while (i < array.length) {
            result = String.valueOf(result) + separator + array[i];
            ++i;
        }
        return result;
    }

    public static String joinIntArrayToString(int[] array, String separator) {
        String result = "";
        int i = 0;
        while (i < array.length) {
            result = String.valueOf(result) + array[i];
            if (i != array.length - 1) {
                result = String.valueOf(result) + separator;
            }
            ++i;
        }
        return result;
    }

    public static String[] splitOnTabs(String a) {
        return a.split("\t");
    }

    public static String[] splitOnNewLine(String a) {
        return a.split("\n");
    }

    public static boolean isInInterval(int index, int[] c) {
        return index >= c[0] && index <= c[1];
    }

    public static boolean isInInterval(int[] c1, int[] c2) {
        return c1[0] >= c2[0] && c1[1] <= c2[1];
    }

    public static boolean isIntervalExtreme(int index, int[] c) {
        return index == c[0] || index == c[1];
    }

    public static boolean isIntervalExtreme(int[] c1, int[] c2) {
        return c1[0] == c2[0] || c1[1] == c2[1];
    }

    public static String[] concat(String[] as1, String[] as2) {
        String s;
        String[] result = new String[as1.length + as2.length];
        int i = 0;
        String[] stringArray = as1;
        int n = as1.length;
        int n2 = 0;
        while (n2 < n) {
            result[i] = s = stringArray[n2];
            ++i;
            ++n2;
        }
        stringArray = as2;
        n = as2.length;
        n2 = 0;
        while (n2 < n) {
            result[i] = s = stringArray[n2];
            ++i;
            ++n2;
        }
        return result;
    }

    public static boolean isIntegerList(String[] list) {
        Pattern p = Pattern.compile("-{0,1}\\d+");
        String[] stringArray = list;
        int n = list.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            if (!p.matcher(s).matches()) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean isInteger(String s) {
        Pattern p = Pattern.compile("-{0,1}\\d+");
        return p.matcher(s).matches();
    }

    public static boolean xor(boolean b1, boolean b2) {
        return !(!b1 && !b2 || b1 && b2);
    }

    public static int sum(int[] array) {
        int result = 0;
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            result += i;
            ++n2;
        }
        return result;
    }

    public static boolean iff(boolean a, boolean b) {
        return a && b || !a && !b;
    }

    public static <T> boolean removeAllOnce(ArrayList<T> a, ArrayList<T> b) {
        boolean modified = false;
        BitSet removedElementBIndex = new BitSet();
        ListIterator<T> aIter = a.listIterator();
        while (aIter.hasNext()) {
            T aNext = aIter.next();
            boolean found = false;
            ListIterator<T> bIter = b.listIterator();
            int index = 0;
            while (bIter.hasNext()) {
                T bNext = bIter.next();
                if (!removedElementBIndex.get(index) && aNext.equals(bNext)) {
                    removedElementBIndex.set(index);
                    found = true;
                    break;
                }
                ++index;
            }
            if (!found) continue;
            aIter.remove();
            modified = true;
        }
        return modified;
    }

    public static double logSum2(double a, double b) {
        if (a > b) {
            if (b == Double.NEGATIVE_INFINITY) {
                return a;
            }
            if (a > -10.0) {
                return Math.log(Math.exp(a) + Math.exp(b));
            }
            return a + Math.exp(b - a);
        }
        if (a == Double.NEGATIVE_INFINITY) {
            return b;
        }
        if (b > -10.0) {
            return Math.log(Math.exp(a) + Math.exp(b));
        }
        return b + Math.exp(a - b);
    }

    public static double logSum(double x, double y) {
        if (y == 0.0 || x == 0.0) {
            return Utility.logSumLongWay(x, y);
        }
        if (x < y) {
            double diff = x - y;
            return y + Math.log1p(Math.exp(diff));
        }
        double diff = y - x;
        return x + Math.log1p(Math.exp(diff));
    }

    public static double logSumLongWay(double x, double y) {
        double a = Math.exp(x);
        double b = Math.exp(y);
        return Math.log(a + b);
    }

    public static void regExTest() {
        String a = "  the `/Christian view they *argue |";
        a = a.replaceAll("[^\\w\\s]", "");
        System.out.println(a);
    }

    public static void testLog() {
        double a = Math.random();
        double b = 0.0;
        double lnA = Math.log(a);
        double lnB = Math.log(b);
        double correct = Math.log(a + b);
        double logSumLongWay = Utility.logSumLongWay(lnA, lnB);
        double logSumLongWayError = Math.abs(correct - logSumLongWay);
        double logMarkos = Utility.logSum(lnA, lnB);
        double logMarkosError = Math.abs(correct - logMarkos);
        double logOtherVersion = Utility.logSum2(lnA, lnB);
        double logOtherVersionError = Math.abs(correct - logOtherVersion);
        System.out.println(String.valueOf(lnA) + " " + lnB + "\n\tLong Way Error:" + logSumLongWayError + "\t" + correct + "\n\tWiki Way Error:" + logMarkosError + "\n\tAlternative way Error:" + logOtherVersionError + "\n");
    }

    public static void convertFreqTypesTokens() throws FileNotFoundException {
        File inputFile = new File("/Users/fedja/Desktop/danigraph/daniData2.txt");
        File outputFile = new File("/Users/fedja/Desktop/danigraph/daniData2_conv.txt");
        Scanner scan = new Scanner(inputFile);
        PrintWriter pw = new PrintWriter(outputFile);
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            String[] lineSplit = line.split("\t");
            int binSize = Integer.parseInt(lineSplit[0]);
            int freq = Integer.parseInt(lineSplit[1]);
            int i = 0;
            while (i < binSize) {
                pw.println(freq);
                ++i;
            }
        }
        pw.close();
    }

    public static void getFreqCount() throws FileNotFoundException {
        File inputFile = new File("/Users/fedja/Work/Papers/LREC10/Results/fragmentsTypesFreq.txt");
        File outputFile = new File("/Users/fedja/Work/Papers/LREC10/Results/freqCounts.txt");
        Scanner scan = new Scanner(inputFile);
        int currentFreq = -1;
        int currentTypesCount = 0;
        PrintWriter pw = new PrintWriter(outputFile);
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            String[] lineSplit = line.split("\t");
            Integer freq = Integer.parseInt(lineSplit[1]);
            if (freq != currentFreq) {
                if (currentFreq != -1) {
                    pw.println(String.valueOf(currentFreq) + "\t" + currentTypesCount);
                }
                currentFreq = freq;
                currentTypesCount = 1;
                continue;
            }
            ++currentTypesCount;
        }
        pw.println(String.valueOf(currentFreq) + "\t" + currentTypesCount);
        pw.close();
    }

    public static void getColumn() throws FileNotFoundException {
        File inputFile = new File("/Users/fedja/Work/Papers/LREC10/Results/fragmentsTypesFreq.txt");
        File outputFile = new File("/Users/fedja/Work/Papers/LREC10/Results/freqs.txt");
        Scanner scan = new Scanner(inputFile);
        PrintWriter pw = new PrintWriter(outputFile);
        while (scan.hasNextLine()) {
            String line = scan.nextLine();
            String[] lineSplit = line.split("\t");
            int freq = Integer.parseInt(lineSplit[1]);
            pw.println(freq);
        }
        pw.close();
    }

    public static <T> String arrayToStringDeep(T[][] array) {
        String result = "{";
        T[][] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object[] t = TArray[n2];
            result = String.valueOf(result) + Arrays.toString(t);
            ++n2;
        }
        result = String.valueOf(result) + "}";
        return result;
    }

    public static <T> int match(ArrayList<T> a, ArrayList<T> b) {
        if (a.size() != b.size()) {
            return -1;
        }
        Iterator<T> aIter = a.iterator();
        Iterator<T> bIter = b.iterator();
        int count = 0;
        while (aIter.hasNext()) {
            T bNext;
            T aNext = aIter.next();
            if (!aNext.equals(bNext = bIter.next())) continue;
            ++count;
        }
        return count;
    }

    public static int countCharInString(String currentLabel, char charToFind) {
        char[] array = currentLabel.toCharArray();
        int result = 0;
        char[] cArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            if (c == charToFind) {
                ++result;
            }
            ++n2;
        }
        return result;
    }

    public static int roulette(double[] numberProb) {
        double random = Math.random();
        double total = 0.0;
        int i = 0;
        while (i < numberProb.length) {
            if (random < (total += numberProb[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static void bruinSequences(int k, int n) {
        int[] list = new int[n];
        Arrays.fill(list, k);
        int[][] sequences = Utility.combinations(list);
        int length = sequences.length;
        boolean[] taken = new boolean[length];
        int[] result = new int[length + n - 1];
        int[] seq = sequences[0];
        int i = 0;
        while (i < n) {
            result[i] = seq[i];
            ++i;
        }
        taken[0] = true;
        int resIndex = n;
        int[] lastDigits = Arrays.copyOfRange(seq, 1, n);
        while (resIndex < result.length) {
            boolean found = false;
            int i2 = length - 1;
            while (i2 >= 0) {
                int[] firstDigits;
                if (!taken[i2] && Arrays.equals(lastDigits, firstDigits = Arrays.copyOfRange(seq = sequences[i2], 0, n - 1))) {
                    taken[i2] = true;
                    found = true;
                    lastDigits = Arrays.copyOfRange(seq, 1, n);
                    result[resIndex++] = seq[n - 1];
                    break;
                }
                --i2;
            }
            if (found) continue;
            System.err.println("Sequence not found!");
            return;
        }
        System.out.println(Arrays.toString(result));
    }

    public static <T> Vector<ArrayList<T>> splitArrayList(ArrayList<T> fullList, int splits) {
        Vector<ArrayList<T>> result = new Vector<ArrayList<T>>(splits);
        int size = fullList.size();
        int elementsPerSplit = size / splits;
        int remainingSentences = size % splits;
        if (remainingSentences != 0) {
            ++elementsPerSplit;
        }
        int i = 0;
        while (i < splits - 1) {
            int startIndex = elementsPerSplit * i;
            int endIndex = elementsPerSplit * (i + 1);
            result.add(new ArrayList<T>(fullList.subList(startIndex, endIndex)));
            ++i;
        }
        int startIndex = elementsPerSplit * (splits - 1);
        result.add(new ArrayList<T>(fullList.subList(startIndex, size)));
        return result;
    }

    public static int[] countDownArray(int length) {
        int[] result = new int[length];
        int index = 0;
        int i = length - 1;
        while (i >= 0) {
            result[index++] = i--;
        }
        return result;
    }

    public static int[] countUpArray(int length) {
        int[] result = new int[length];
        int i = 0;
        while (i < length) {
            result[i] = i;
            ++i;
        }
        return result;
    }

    public static BitSet makeBitSet(int[] array) {
        BitSet bs = new BitSet(array.length);
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            bs.set(i);
            ++n2;
        }
        return bs;
    }

    public static void main(String[] args) throws FileNotFoundException {
        String workingDir = "/Users/fedja/Work/Papers/EMNLP11/DOP1vsFS/";
        File inputFile = new File(String.valueOf(workingDir) + "countDOP1vsFS_sorted.txt");
        File outputFilel = new File(String.valueOf(workingDir) + "countDOP1vsFS_sorted_cumulative.txt");
    }
}

