/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.util;

import edu.stanford.nlp.util.Function;
import edu.stanford.nlp.util.Generics;
import edu.stanford.nlp.util.MapFactory;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class TwoDimensionalMap<K1, K2, V>
implements Serializable,
Iterable<Entry<K1, K2, V>> {
    private static final long serialVersionUID = 2L;
    private final MapFactory<K1, Map<K2, V>> mf1;
    private final MapFactory<K2, V> mf2;
    Map<K1, Map<K2, V>> map;

    public int size() {
        int size = 0;
        for (Map.Entry<K1, Map<K2, V>> entry : this.map.entrySet()) {
            size += entry.getValue().size();
        }
        return size;
    }

    public boolean isEmpty() {
        for (Map.Entry<K1, Map<K2, V>> entry : this.map.entrySet()) {
            if (entry.getValue().isEmpty()) continue;
            return false;
        }
        return true;
    }

    public V put(K1 key1, K2 key2, V value) {
        Map<K2, V> m = this.getMap(key1);
        return m.put(key2, value);
    }

    public void put(K1 key1) {
        this.map.put(key1, this.mf2.newMap());
    }

    public boolean contains(K1 key1, K2 key2) {
        if (!this.containsKey(key1)) {
            return false;
        }
        return this.getMap(key1).containsKey(key2);
    }

    public V get(K1 key1, K2 key2) {
        Map<K2, V> m = this.getMap(key1);
        return m.get(key2);
    }

    public V remove(K1 key1, K2 key2) {
        return this.get(key1).remove(key2);
    }

    public void remove(K1 key1) {
        this.map.remove(key1);
    }

    public void clear() {
        this.map.clear();
    }

    public boolean containsKey(K1 key1) {
        return this.map.containsKey(key1);
    }

    public Map<K2, V> get(K1 key1) {
        return this.getMap(key1);
    }

    public Map<K2, V> getMap(K1 key1) {
        Map<K2, V> m = this.map.get(key1);
        if (m == null) {
            m = this.mf2.newMap();
            this.map.put(key1, m);
        }
        return m;
    }

    public Collection<V> values() {
        ArrayList<V> s = Generics.newArrayList();
        for (Map<K2, V> innerMap : this.map.values()) {
            s.addAll(innerMap.values());
        }
        return s;
    }

    public Set<K1> firstKeySet() {
        return this.map.keySet();
    }

    public Set<K2> secondKeySet() {
        Set<K2> keys = Generics.newHashSet();
        for (K1 k1 : this.map.keySet()) {
            keys.addAll(this.get(k1).keySet());
        }
        return keys;
    }

    public <V2> void addAll(TwoDimensionalMap<? extends K1, ? extends K2, ? extends V2> other, Function<V2, V> function) {
        for (Entry<K1, K2, V2> entry : other) {
            this.put(entry.getFirstKey(), entry.getSecondKey(), function.apply(entry.getValue()));
        }
    }

    public TwoDimensionalMap() {
        this(MapFactory.hashMapFactory(), MapFactory.hashMapFactory());
    }

    public TwoDimensionalMap(TwoDimensionalMap<K1, K2, V> tdm) {
        this(tdm.mf1, tdm.mf2);
        for (K1 k1 : tdm.map.keySet()) {
            Map<K2, V> m = tdm.map.get(k1);
            Map<K2, V> copy = this.mf2.newMap();
            copy.putAll(m);
            this.map.put(k1, copy);
        }
    }

    public TwoDimensionalMap(MapFactory<K1, Map<K2, V>> mf1, MapFactory<K2, V> mf2) {
        this.mf1 = mf1;
        this.mf2 = mf2;
        this.map = mf1.newMap();
    }

    public static <K1, K2, V> TwoDimensionalMap<K1, K2, V> hashMap() {
        return new TwoDimensionalMap(MapFactory.hashMapFactory(), MapFactory.hashMapFactory());
    }

    public static <K1, K2, V> TwoDimensionalMap<K1, K2, V> treeMap() {
        return new TwoDimensionalMap(MapFactory.treeMapFactory(), MapFactory.treeMapFactory());
    }

    public static <K1, K2, V> TwoDimensionalMap<K1, K2, V> identityHashMap() {
        return new TwoDimensionalMap(MapFactory.identityHashMapFactory(), MapFactory.identityHashMapFactory());
    }

    public String toString() {
        return this.map.toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TwoDimensionalMap)) {
            return false;
        }
        TwoDimensionalMap other = (TwoDimensionalMap)o;
        return ((Object)this.map).equals(other.map);
    }

    public int hashCode() {
        return ((Object)this.map).hashCode();
    }

    @Override
    public Iterator<Entry<K1, K2, V>> iterator() {
        return new TwoDimensionalMapIterator(this);
    }

    public Iterator<V> valueIterator() {
        return new TwoDimensionalMapValueIterator(this);
    }

    static class TwoDimensionalMapIterator<K1, K2, V>
    implements Iterator<Entry<K1, K2, V>> {
        Iterator<Map.Entry<K1, Map<K2, V>>> outerIterator;
        Iterator<Map.Entry<K2, V>> innerIterator;
        Entry<K1, K2, V> next;

        TwoDimensionalMapIterator(TwoDimensionalMap<K1, K2, V> map) {
            this.outerIterator = map.map.entrySet().iterator();
            this.primeNext();
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Entry<K1, K2, V> next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            Entry<K1, K2, V> result = this.next;
            this.primeNext();
            return result;
        }

        private void primeNext() {
            Object k1 = null;
            if (this.next != null) {
                k1 = this.next.getFirstKey();
            }
            while (this.innerIterator == null || !this.innerIterator.hasNext()) {
                if (!this.outerIterator.hasNext()) {
                    this.next = null;
                    return;
                }
                Map.Entry<K1, Map<K2, V>> outerEntry = this.outerIterator.next();
                k1 = outerEntry.getKey();
                this.innerIterator = outerEntry.getValue().entrySet().iterator();
            }
            Map.Entry<K2, V> innerEntry = this.innerIterator.next();
            this.next = new Entry<Object, K2, V>(k1, innerEntry.getKey(), innerEntry.getValue());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class Entry<K1, K2, V> {
        K1 firstKey;
        K2 secondKey;
        V value;

        Entry(K1 k1, K2 k2, V v) {
            this.firstKey = k1;
            this.secondKey = k2;
            this.value = v;
        }

        public K1 getFirstKey() {
            return this.firstKey;
        }

        public K2 getSecondKey() {
            return this.secondKey;
        }

        public V getValue() {
            return this.value;
        }

        public String toString() {
            return "(" + this.firstKey + "," + this.secondKey + "," + this.value + ")";
        }
    }

    static class TwoDimensionalMapValueIterator<K1, K2, V>
    implements Iterator<V> {
        Iterator<Entry<K1, K2, V>> entryIterator;

        TwoDimensionalMapValueIterator(TwoDimensionalMap<K1, K2, V> map) {
            this.entryIterator = map.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.entryIterator.hasNext();
        }

        @Override
        public V next() {
            Entry<K1, K2, V> next = this.entryIterator.next();
            return next.getValue();
        }

        @Override
        public void remove() {
            this.entryIterator.remove();
        }
    }
}

