/*
 * Decompiled with CFR 0.152.
 */
package edu.stanford.nlp.ling.tokensregex.matcher;

import edu.stanford.nlp.ling.tokensregex.matcher.Match;
import edu.stanford.nlp.ling.tokensregex.matcher.MultiMatch;
import edu.stanford.nlp.util.Interval;
import edu.stanford.nlp.util.StringUtils;
import java.util.List;

public class ApproxMatch<K, V>
extends MultiMatch<K, V> {
    double cost;
    Interval<Integer>[] alignments;

    public ApproxMatch() {
    }

    public ApproxMatch(List<K> matched, V value, int begin, int end, double cost) {
        this.matched = matched;
        this.value = value;
        this.begin = begin;
        this.end = end;
        this.cost = cost;
    }

    public ApproxMatch(List<K> matched, V value, int begin, int end, List<Match<K, V>> multimatches, double cost) {
        this.matched = matched;
        this.value = value;
        this.begin = begin;
        this.end = end;
        this.multimatches = multimatches;
        this.cost = cost;
    }

    public ApproxMatch(List<K> matched, V value, int begin, int end, List<Match<K, V>> multimatches, double cost, Interval[] alignments) {
        this.matched = matched;
        this.value = value;
        this.begin = begin;
        this.end = end;
        this.multimatches = multimatches;
        this.cost = cost;
        this.alignments = alignments;
    }

    public double getCost() {
        return this.cost;
    }

    public Interval<Integer>[] getAlignments() {
        return this.alignments;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ApproxMatch that = (ApproxMatch)o;
        return Double.compare(that.cost, this.cost) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.cost);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append(super.toString());
        sb.append(",").append(this.cost);
        if (this.alignments != null) {
            sb.append(", [").append(StringUtils.join(this.alignments, ", ")).append("]");
        }
        sb.append(")");
        return sb.toString();
    }
}

