from sklearn.metrics import balanced_accuracy_score
import numpy as np
import random

"""
All codes adapted from Understanding Factual Errors in Summarization: Errors, Summarizers, Datasets, Error Detectors (Tang et al., 2023 ACL) https://github.com/Liyan06/AggreFact/tree/main
"""

# We do not consider "LEAD3" and "GOLD"(human reference) in the OLD category
# since they are not generated by models
SOTA = ['BART', 'PegasusDynamic', 'T5', 'Pegasus']
XFORMER = ['BertSum', 'BertExtAbs', 'BertExt', 'GPT2', 'BERTS2S', 'TranS2S']
OLD = ['FastAbsRl','TConvS2S', 'PtGen', 'PtGenCoverage',
            'Summa', 'BottomUp', 'Seq2Seq', 'TextRank', 'missing', 'ImproveAbs', 'NEUSUM',
            'ClosedBookDecoder', 'RNES', 'BanditSum', 'ROUGESal', 'MultiTask', 'UnifiedExtAbs']
MAPPING = {0: "SOTA", 1: "XFORMER", 2: "OLD"}


# from https://github.com/tingofurro/summac/
def choose_best_threshold(labels, scores):
    best_f1 = 0.0
    best_thresh = 0.0
    thresholds = [np.percentile(scores, p) for p in np.arange(0, 100, 0.2)]
    for thresh in thresholds:
        preds = [1 if score > thresh else 0 for score in scores]
        # f1_score = sklearn.metrics.f1_score(labels, preds, average='micro')
        f1_score = balanced_accuracy_score(labels, preds)

        if f1_score >= best_f1:
            best_f1 = f1_score
            best_thresh = thresh
    return best_thresh, best_f1


def resample_balanced_acc(preds, labels, n_samples=1000, sample_ratio=0.8):
    N = len(preds)
    idxs = list(range(N))
    N_batch = int(sample_ratio*N)

    bal_accs = []
    for _ in range(n_samples):
        random.shuffle(idxs)
        batch_preds = [preds[i] for i in idxs[:N_batch]]
        batch_labels = [labels[i] for i in idxs[:N_batch]]
        
        bal_accs.append(balanced_accuracy_score(batch_labels, batch_preds))
    return bal_accs