theory question_41_1

imports Main

begin

typedecl entity
typedecl event

consts
  EarthTilt :: "event ⇒ bool"
  RotatingAxis :: "event ⇒ bool"
  SeasonChange :: "event ⇒ bool"
  ChangesInWeather :: "event ⇒ bool"

(* Explanation 1: Earth's tilt on its rotating axis causes seasons to change. *)
axiomatization where
  explanation_1: "∀e. EarthTilt e ∧ RotatingAxis e ⟶ SeasonChange e"

(* Explanation 2: Weather changes with the variation in seasons. *)
axiomatization where
  explanation_2: "∀e. SeasonChange e ⟶ ChangesInWeather e"

(* Explanation 3: Seasonal changes are the result of Earth's tilt on its rotating axis. *)
axiomatization where
  explanation_3: "∀e. SeasonChange e ⟶ EarthTilt e ∧ RotatingAxis e"

theorem hypothesis:
  assumes asm: "EarthTilt e ∧ RotatingAxis e"
  (* Hypothesis: Earth's tilt on its rotating axis causes changes in weather. *)
  shows "ChangesInWeather e"
proof -
  from asm have "SeasonChange e" using explanation_1 by blast
  then show "ChangesInWeather e" using explanation_2 by blast
qed

end
