theory question_99_10

imports Main

begin

typedecl entity
typedecl event

consts
  Dog :: "entity ⇒ bool"
  Running :: "entity ⇒ entity ⇒ bool"
  Contact :: "entity ⇒ entity ⇒ bool"
  On :: "entity ⇒ entity ⇒ bool"
  Grass :: "entity ⇒ bool"

theorem hypothesis:
  (* Premise: ∃x. Dog(x) ∧ Running(x, grass) *)
  assumes asm: "Dog x ∧ Running x Grass"
  (* Hypothesis: ∃x. Dog(x) ∧ On(x, grass) *)
  shows "∃x. Dog x ∧ On x Grass"
proof -
  from asm have "Running x Grass" by simp
  then have "Contact x Grass" using explanation_1 by blast
  then have "On x Grass" using explanation_2 by blast
  then show "∃x. Dog x ∧ On x Grass" using asm by blast
qed

(* Explanation 1: If an entity is running on something, then they are in contact with it. *)
axiomatization where
  explanation_1: "∀x y. Running x y ⟶ Contact x y"

(* Explanation 2: If an entity is in contact with the grass, then they are on the grass. *)
axiomatization where
  explanation_2: "∀x. Contact x Grass ⟶ On x Grass"

end
