theory question_60_0
imports Main

begin

typedecl entity
typedecl event
typedecl phase

consts
  PhaseChange :: "event ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Change :: "(entity ⇒ entity) ⇒ event ⇒ bool"
  Mass :: "entity ⇒ entity"
  Melting :: "event ⇒ bool"
  HeatEnergy :: "entity ⇒ bool"
  Change_ :: "entity ⇒ phase ⇒ phase ⇒ event ⇒ bool"
  Add :: "entity ⇒ event ⇒ bool"
  Solid :: "phase"
  Liquid :: "phase"
  Matter :: "entity ⇒ bool"
  Object :: "entity ⇒ bool"
  Material :: "entity ⇒ bool"
  Weight :: "entity ⇒ bool"
  Ice :: "entity ⇒ bool"
  Beaker :: "entity ⇒ bool"
  Contains :: "entity ⇒ entity ⇒ bool"
  Volume :: "entity ⇒ nat ⇒ unit ⇒ bool"
  Milliliters :: "unit"
  Placed :: "event ⇒ bool"
  Windowsill :: "entity"
  Hours :: "nat"
  After :: "event ⇒ nat ⇒ bool"

(* Explanation 1: phase changes do not change mass. *)
axiomatization where
  explanation_1: "∀x y e. PhaseChange e ∧ Agent e x ⟹ ¬Change (Mass x) e"

(* Explanation 2: melting means changing from a solid into a liquid by adding heat energy. *)
axiomatization where
  explanation_2: "∀x e h. Melting e ∧ Agent e x ∧ HeatEnergy h ⟹ Change_ x Solid Liquid e ∧ Add h e"

(* Explanation 3: melting is a kind of phase change. *)
axiomatization where
  explanation_3: "∀x e. Melting e ∧ Agent e x ⟹ PhaseChange e"

(* Explanation 4: mass; weight is a property of matter; objects; materials. *)
axiomatization where
  explanation_4: "∀x. Mass x ∧ Weight x ∧ (Matter x ∨ Object x ∨ Material x)"

theorem hypothesis:
  (* Premise 1: a beaker containing 50 milliliters of ice is placed on a windowsill. *)
  assumes asm1: "Beaker b ∧ Contains b (Ice i) ∧ Volume i 50 Milliliters ∧ Placed e ∧ Agent e b ∧ Patient e Windowsill"
  (* Premise 2: after several hours, the ice melts. *)
  assumes asm2: "Hours n ∧ After e n ∧ Melting e ∧ Agent e i"
  (* Hypothesis: The mass of the ice did not change when it melted. *)
  shows "¬Change  Mass i  e"
proof -
  {
    assume "Melting e ∧ Agent e i"
    then have "PhaseChange e ∧ Agent e i" using explanation_3 by blast
    then have "¬Change (Mass i) e" using explanation_1 by blast
  }
  then show ?thesis using asm1 asm2 by blast
qed

end
