theory question_93_3

imports Main

begin

typedecl entity

consts
  AdultEchinoderms :: "entity ⇒ bool"
  RadialSymmetry :: "entity ⇒ bool"
  Starfish :: "entity ⇒ bool"
  Echinoderm :: "entity ⇒ bool"
  ExhibitsRadialSymmetryAsAdult :: "entity ⇒ bool"
  AdultStarfish :: "entity ⇒ bool"
  MaturityReached :: "entity ⇒ bool"

(* Explanation 1: Adult echinoderms have radial symmetry. *)
axiomatization where
  explanation_1: "∀x. AdultEchinoderms x ⟶ RadialSymmetry x"

(* Explanation 2: Starfish are a type of echinoderm that exhibits radial symmetry as adults, and all adult starfish exhibit radial symmetry. *)
axiomatization where
  explanation_2: "∀x. Starfish x ⟶ (Echinoderm x ∧ ExhibitsRadialSymmetryAsAdult x) ∧ (AdultStarfish x ⟶ RadialSymmetry x)"

(* Explanation 3: Adult starfish are starfish that have reached maturity. *)
axiomatization where
  explanation_3: "∀x. AdultStarfish x ⟷ Starfish x ∧ MaturityReached x"

theorem hypothesis:
  assumes asm: "AdultStarfish x"
  (* Hypothesis: Adults of starfish have radial symmetry. *)
  shows "RadialSymmetry x"
proof -
  from asm have "AdultStarfish x" by simp
  then have "Starfish x ∧ MaturityReached x" using explanation_3 by blast
  then have "Starfish x" by simp
  then have "Echinoderm x ∧ ExhibitsRadialSymmetryAsAdult x" using explanation_2 by blast
  then have "Echinoderm x" by simp
  then have "AdultEchinoderms x" using explanation_2 by blast
  then have "RadialSymmetry x" using explanation_1 by blast
  show ?thesis using asm `RadialSymmetry x` by blast
qed

end
