theory question_17_0

imports Main

begin

typedecl entity
typedecl event

consts
  Consumers :: "entity ⇒ bool"
  Feed :: "event ⇒ bool"
  TrophicLevel :: "entity ⇒ bool"
  Producers :: "entity ⇒ bool"
  Omnivores :: "entity ⇒ bool"
  Different :: "entity ⇒ entity ⇒ bool"
  Agent :: "event ⇒ entity ⇒ bool"
  Patient :: "event ⇒ entity ⇒ bool"
  Plants :: "entity ⇒ bool"

(* Explanation 1: Many consumers feed at more than one trophic level. *)
axiomatization where
  explanation_1: "∀x e1 e2 t1 t2. Consumers x ∧ Feed e1 ∧ Feed e2 ∧ TrophicLevel t1 ∧ TrophicLevel t2 ∧ Agent e1 x ∧ Patient e1 t1 ∧ Agent e2 x ∧ Patient e2 t2 ∧ Different t1 t2"

(* Explanation 2: Plants are producers, consumers are omnivores. *)
axiomatization where
  explanation_2: "∀x y. Plants x ⟶ Producers x ∧ Consumers y ⟶ Omnivores y"

theorem hypothesis:
  assumes asm: "Omnivores x ∧ Feed e1 ∧ Feed e2 ∧ TrophicLevel t1 ∧ TrophicLevel t2 ∧ Agent e1 x ∧ Patient e1 t1 ∧ Agent e2 x ∧ Patient e2 t2"
  (* Hypothesis: Omnivores can feed at more than one trophic level. *)
  shows "∃x e1 e2 t1 t2. Omnivores x ∧ Feed e1 ∧ Feed e2 ∧ TrophicLevel t1 ∧ TrophicLevel t2 ∧ Agent e1 x ∧ Patient e1 t1 ∧ Agent e2 x ∧ Patient e2 t2 ∧ Different t1 t2"
proof -
  from asm have "Omnivores x" by simp
  from asm have "Feed e1" by simp
  from asm have "Feed e2" by simp
  from asm have "TrophicLevel t1" by simp
  from asm have "TrophicLevel t2" by simp
  from asm have "Agent e1 x" by simp
  from asm have "Patient e1 t1" by simp
  from asm have "Agent e2 x" by simp
  from asm have "Patient e2 t2" by simp
  from explanation_1[OF this(1), where x=x, e1=e1, e2=e2, t1=t1, t2=t2]
    and explanation_2[OF this(1), where x=x, y=t1]
    and explanation_2[OF this(1), where x=x, y=t2]
  have "Different t1 t2" by blast
  then show ?thesis using asm `Different t1 t2` by blast
qed

end
